/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.zipkin;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="zipkin_service_span_traffic", scopeId=52, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false)
@BanyanDB.IndexMode
public class ZipkinServiceSpanTraffic
extends Metrics {
    public static final String INDEX_NAME = "zipkin_service_span_traffic";
    public static final String SERVICE_NAME = "service_name";
    public static final String SPAN_NAME = "span_name";
    @Column(name="service_name")
    private String serviceName;
    @Column(name="span_name")
    private String spanName = "";

    @Override
    protected StorageID id0() {
        return new StorageID().append(this.serviceName).append(SPAN_NAME, this.spanName);
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder remoteBuilder = RemoteData.newBuilder();
        remoteBuilder.addDataLongs(this.getTimeBucket());
        remoteBuilder.addDataStrings(this.serviceName);
        remoteBuilder.addDataStrings(this.spanName);
        return remoteBuilder;
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTimeBucket(remoteData.getDataLongs(0));
        this.setServiceName(remoteData.getDataStrings(0));
        this.setSpanName(remoteData.getDataStrings(1));
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipkinServiceSpanTraffic)) {
            return false;
        }
        ZipkinServiceSpanTraffic other = (ZipkinServiceSpanTraffic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$spanName = this.getSpanName();
        String other$spanName = other.getSpanName();
        return !(this$spanName == null ? other$spanName != null : !this$spanName.equals(other$spanName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZipkinServiceSpanTraffic;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $spanName = this.getSpanName();
        result = result * 59 + ($spanName == null ? 43 : $spanName.hashCode());
        return result;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public void setSpanName(String spanName) {
        this.spanName = spanName;
    }

    @Generated
    public String getSpanName() {
        return this.spanName;
    }

    public static class Builder
    implements StorageBuilder<ZipkinServiceSpanTraffic> {
        @Override
        public ZipkinServiceSpanTraffic storage2Entity(Convert2Entity converter) {
            ZipkinServiceSpanTraffic spanTraffic = new ZipkinServiceSpanTraffic();
            spanTraffic.setServiceName((String)converter.get(ZipkinServiceSpanTraffic.SERVICE_NAME));
            spanTraffic.setSpanName((String)converter.get(ZipkinServiceSpanTraffic.SPAN_NAME));
            spanTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return spanTraffic;
        }

        @Override
        public void entity2Storage(ZipkinServiceSpanTraffic storageData, Convert2Storage converter) {
            converter.accept(ZipkinServiceSpanTraffic.SERVICE_NAME, storageData.getServiceName());
            converter.accept(ZipkinServiceSpanTraffic.SPAN_NAME, storageData.getSpanName());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

