/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als;

import com.google.common.base.Strings;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.HTTPAccessLogEntry;
import io.envoyproxy.envoy.data.accesslog.v3.HTTPRequestProperties;
import io.envoyproxy.envoy.data.accesslog.v3.ResponseFlags;
import io.envoyproxy.envoy.data.accesslog.v3.TLSProperties;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.DetectPoint;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.Protocol;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;

public class LogEntry2MetricsAdapter {
    protected final HTTPAccessLogEntry entry;
    protected final ServiceMetaInfo sourceService;
    protected final ServiceMetaInfo targetService;

    public HTTPServiceMeshMetric.Builder adaptToDownstreamMetrics() {
        AccessLogCommon properties = this.entry.getCommonProperties();
        long startTime = LogEntry2MetricsAdapter.formatAsLong(properties.getStartTime());
        long duration = LogEntry2MetricsAdapter.formatAsLong(properties.getTimeToLastDownstreamTxByte());
        return this.adaptCommonPart().setStartTime(startTime).setEndTime(startTime + duration).setLatency((int)Math.max(1L, duration)).setDetectPoint(DetectPoint.server);
    }

    public HTTPServiceMeshMetric.Builder adaptToUpstreamMetrics() {
        AccessLogCommon properties = this.entry.getCommonProperties();
        long startTime = LogEntry2MetricsAdapter.formatAsLong(properties.getStartTime());
        long outboundStartTime = startTime + LogEntry2MetricsAdapter.formatAsLong(properties.getTimeToFirstUpstreamTxByte());
        long outboundEndTime = startTime + LogEntry2MetricsAdapter.formatAsLong(properties.getTimeToLastUpstreamRxByte());
        HTTPServiceMeshMetric.Builder builder = this.adaptCommonPart();
        boolean status = builder.getResponseCode() < 400;
        return builder.setStartTime(outboundStartTime).setEndTime(outboundEndTime).setLatency((int)Math.max(1L, outboundEndTime - outboundStartTime)).setStatus(status).setDetectPoint(DetectPoint.client);
    }

    public HTTPServiceMeshMetric.Builder adaptCommonPart() {
        AccessLogCommon properties = this.entry.getCommonProperties();
        String endpoint = this.endpoint();
        int responseCode = this.entry.getResponse().getResponseCode().getValue();
        responseCode = responseCode > 0 ? responseCode : 200;
        boolean status = responseCode < 500;
        Protocol protocol = LogEntry2MetricsAdapter.requestProtocol(this.entry.getRequest());
        String tlsMode = LogEntry2MetricsAdapter.parseTLS(properties.getTlsProperties());
        String internalErrorCode = LogEntry2MetricsAdapter.parseInternalErrorCode(properties.getResponseFlags());
        long internalRequestLatencyNanos = properties.getTimeToFirstUpstreamTxByte().getNanos();
        long internalResponseLatencyNanos = properties.getTimeToFirstDownstreamTxByte().getNanos() - properties.getTimeToFirstUpstreamRxByte().getNanos();
        HTTPServiceMeshMetric.Builder builder = HTTPServiceMeshMetric.newBuilder().setEndpoint(endpoint).setResponseCode(Math.toIntExact(responseCode)).setStatus(status).setProtocol(protocol).setTlsMode(tlsMode).setInternalErrorCode(internalErrorCode).setInternalRequestLatencyNanos(internalRequestLatencyNanos).setInternalResponseLatencyNanos(internalResponseLatencyNanos);
        Optional.ofNullable(this.sourceService).map(ServiceMetaInfo::getServiceName).ifPresent(arg_0 -> ((HTTPServiceMeshMetric.Builder)builder).setSourceServiceName(arg_0));
        Optional.ofNullable(this.sourceService).map(ServiceMetaInfo::getServiceInstanceName).ifPresent(arg_0 -> ((HTTPServiceMeshMetric.Builder)builder).setSourceServiceInstance(arg_0));
        Optional.ofNullable(this.targetService).map(ServiceMetaInfo::getServiceName).ifPresent(arg_0 -> ((HTTPServiceMeshMetric.Builder)builder).setDestServiceName(arg_0));
        Optional.ofNullable(this.targetService).map(ServiceMetaInfo::getServiceInstanceName).ifPresent(arg_0 -> ((HTTPServiceMeshMetric.Builder)builder).setDestServiceInstance(arg_0));
        Optional.ofNullable(this.sourceService).map(ServiceMetaInfo::getTags).ifPresent(tags -> tags.forEach(p -> builder.addSourceInstanceProperties(KeyStringValuePair.newBuilder().setKey(p.getKey()).setValue(p.getValue()))));
        Optional.ofNullable(this.targetService).map(ServiceMetaInfo::getTags).ifPresent(tags -> tags.forEach(p -> builder.addDestInstanceProperties(KeyStringValuePair.newBuilder().setKey(p.getKey()).setValue(p.getValue()))));
        return builder;
    }

    protected String endpoint() {
        if (!this.entry.hasRequest()) {
            return "/";
        }
        HTTPRequestProperties request = this.entry.getRequest();
        String method = request.getRequestMethod().name();
        return method + ":" + request.getPath();
    }

    public static long formatAsLong(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()).toEpochMilli();
    }

    public static long formatAsLong(Duration duration) {
        return Instant.ofEpochSecond(duration.getSeconds(), duration.getNanos()).toEpochMilli();
    }

    public static Protocol requestProtocol(HTTPRequestProperties request) {
        if (request == null) {
            return Protocol.HTTP;
        }
        String scheme = request.getScheme();
        if (scheme.startsWith("http")) {
            return Protocol.HTTP;
        }
        return Protocol.gRPC;
    }

    public static String parseTLS(TLSProperties properties) {
        if (properties == null) {
            return "NONE";
        }
        TLSProperties.CertificateProperties lp = properties.getLocalCertificateProperties();
        if (Strings.isNullOrEmpty((String)lp.getSubject()) && !LogEntry2MetricsAdapter.hasSAN(lp.getSubjectAltNameList())) {
            return "NONE";
        }
        TLSProperties.CertificateProperties pp = properties.getPeerCertificateProperties();
        if (Strings.isNullOrEmpty((String)pp.getSubject()) && !LogEntry2MetricsAdapter.hasSAN(pp.getSubjectAltNameList())) {
            return "TLS";
        }
        return "mTLS";
    }

    public static String parseInternalErrorCode(ResponseFlags responseFlags) {
        if (responseFlags != null) {
            if (responseFlags.getFailedLocalHealthcheck()) {
                return "failed_local_healthcheck";
            }
            if (responseFlags.getNoHealthyUpstream()) {
                return "no_healthy_upstream";
            }
            if (responseFlags.getUpstreamRequestTimeout()) {
                return "upstream_request_timeout";
            }
            if (responseFlags.getLocalReset()) {
                return "local_reset";
            }
            if (responseFlags.getUpstreamConnectionFailure()) {
                return "upstream_connection_failure";
            }
            if (responseFlags.getUpstreamConnectionTermination()) {
                return "upstream_connection_termination";
            }
            if (responseFlags.getUpstreamOverflow()) {
                return "upstream_overflow";
            }
            if (responseFlags.getNoRouteFound()) {
                return "no_route_found";
            }
            if (responseFlags.getDelayInjected()) {
                return "delay_injected";
            }
            if (responseFlags.getFaultInjected()) {
                return "fault_injected";
            }
            if (responseFlags.getRateLimited()) {
                return "rate_limited";
            }
            if (responseFlags.hasUnauthorizedDetails()) {
                return "unauthorized_details";
            }
            if (responseFlags.getRateLimitServiceError()) {
                return "rate_limit_service_error";
            }
            if (responseFlags.getDownstreamConnectionTermination()) {
                return "downstream_connection_termination";
            }
            if (responseFlags.getUpstreamRetryLimitExceeded()) {
                return "upstream_retry_limit_exceeded";
            }
            if (responseFlags.getStreamIdleTimeout()) {
                return "stream_idle_timeout";
            }
            if (responseFlags.getInvalidEnvoyRequestHeaders()) {
                return "invalid_envoy_request_headers";
            }
            if (responseFlags.getDownstreamProtocolError()) {
                return "downstream_protocol_error";
            }
        }
        return "";
    }

    private static boolean hasSAN(List<TLSProperties.CertificateProperties.SubjectAltName> subjectAltNameList) {
        for (TLSProperties.CertificateProperties.SubjectAltName san : subjectAltNameList) {
            if (Strings.isNullOrEmpty((String)san.getUri())) continue;
            return true;
        }
        return false;
    }

    @Generated
    public LogEntry2MetricsAdapter(HTTPAccessLogEntry entry, ServiceMetaInfo sourceService, ServiceMetaInfo targetService) {
        this.entry = entry;
        this.sourceService = sourceService;
        this.targetService = targetService;
    }
}

