/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContentDispositionBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ContentDisposition {
    private static final ContentDisposition EMPTY = new ContentDisposition("", null, null, null);
    private static final Map<String, Charset> supportedCharsets = ImmutableMap.of("utf-8", StandardCharsets.UTF_8, "iso-8859-1", StandardCharsets.ISO_8859_1);
    private final String type;
    @Nullable
    private final String name;
    @Nullable
    private final String filename;
    @Nullable
    private final Charset charset;
    @Nullable
    private String strVal;

    public static ContentDispositionBuilder builder(String type) {
        Objects.requireNonNull(type, "type");
        Preconditions.checkArgument(!type.isEmpty(), "type should not be empty");
        return new ContentDispositionBuilder(type);
    }

    public static ContentDisposition of(String type) {
        return ContentDisposition.builder(type).build();
    }

    public static ContentDisposition of(String type, String name) {
        return ContentDisposition.builder(type).name(name).build();
    }

    public static ContentDisposition of(String type, String name, String filename) {
        return ContentDisposition.builder(type).name(name).filename(filename).build();
    }

    public static ContentDisposition of() {
        return EMPTY;
    }

    public static ContentDisposition parse(String contentDisposition) {
        Objects.requireNonNull(contentDisposition, "contentDisposition");
        List<String> parts = ContentDisposition.tokenize(contentDisposition);
        String type = parts.get(0);
        String name = null;
        String filename = null;
        Charset charset = null;
        for (int i = 1; i < parts.size(); ++i) {
            String part = parts.get(i);
            int eqIndex = part.indexOf(61);
            if (eqIndex != -1) {
                String attribute = part.substring(0, eqIndex);
                String value = part.startsWith("\"", eqIndex + 1) && part.endsWith("\"") ? part.substring(eqIndex + 2, part.length() - 1) : part.substring(eqIndex + 1);
                if ("name".equals(attribute)) {
                    name = value;
                    continue;
                }
                if ("filename*".equals(attribute)) {
                    int idx1 = value.indexOf(39);
                    int idx2 = value.indexOf(39, idx1 + 1);
                    if (idx1 != -1 && idx2 != -1) {
                        String charsetString = value.substring(0, idx1).trim();
                        charset = supportedCharsets.getOrDefault(Ascii.toLowerCase(charsetString), StandardCharsets.ISO_8859_1);
                        filename = ContentDisposition.decodeFilename(value.substring(idx2 + 1), charset);
                        continue;
                    }
                    filename = ContentDisposition.decodeFilename(value, StandardCharsets.US_ASCII);
                    continue;
                }
                if (!"filename".equals(attribute) || filename != null) continue;
                filename = value;
                continue;
            }
            throw new IllegalArgumentException("Invalid content disposition format: " + contentDisposition);
        }
        return new ContentDisposition(type, name, filename, charset);
    }

    ContentDisposition(String type, @Nullable String name, @Nullable String filename, @Nullable Charset charset) {
        this.type = type;
        this.name = name;
        this.filename = filename;
        this.charset = charset;
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public String filename() {
        return this.filename;
    }

    @Nullable
    public Charset charset() {
        return this.charset;
    }

    private static List<String> tokenize(String headerValue) {
        int index = headerValue.indexOf(59);
        String type = (index >= 0 ? headerValue.substring(0, index) : headerValue).trim();
        Preconditions.checkArgument(!type.isEmpty(), "Content-Disposition header must not be empty");
        ImmutableList.Builder parts = ImmutableList.builderWithExpectedSize(4);
        parts.add(type);
        if (index >= 0) {
            int nextIndex;
            do {
                String part;
                boolean quoted = false;
                boolean escaped = false;
                for (nextIndex = index + 1; nextIndex < headerValue.length(); ++nextIndex) {
                    char ch = headerValue.charAt(nextIndex);
                    if (ch == ';') {
                        if (!quoted) {
                            break;
                        }
                    } else if (!escaped && ch == '\"') {
                        quoted = !quoted;
                    }
                    escaped = !escaped && ch == '\\';
                }
                if ((part = headerValue.substring(index + 1, nextIndex).trim()).isEmpty()) continue;
                parts.add(part);
            } while ((index = nextIndex) < headerValue.length());
        }
        return parts.build();
    }

    private static String decodeFilename(String filename, Charset charset) {
        byte[] value = filename.getBytes(charset);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int index = 0;
        while (index < value.length) {
            byte b = value[index];
            if (ContentDisposition.isRFC5987AttrChar(b)) {
                baos.write((char)b);
                ++index;
                continue;
            }
            if (b == 37 && index < value.length - 2) {
                char[] array = new char[]{(char)value[index + 1], (char)value[index + 2]};
                try {
                    baos.write(Integer.parseInt(String.valueOf(array), 16));
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid filename header field parameter format (as defined in RFC 5987): " + filename + " (charset: " + charset + ')', ex);
                }
                index += 3;
                continue;
            }
            throw new IllegalArgumentException("Invalid filename header field parameter format (as defined in RFC 5987): " + filename + " (charset: " + charset + ')');
        }
        try {
            return baos.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new Error();
        }
    }

    private static boolean isRFC5987AttrChar(byte c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 33 || c == 35 || c == 36 || c == 38 || c == 43 || c == 45 || c == 46 || c == 94 || c == 95 || c == 96 || c == 124 || c == 126;
    }

    private static void escapeQuotationsInFilename(StringBuilder sb, String filename) {
        if (filename.indexOf(34) == -1 && filename.indexOf(92) == -1) {
            sb.append(filename);
            return;
        }
        boolean escaped = false;
        for (char c : filename.toCharArray()) {
            if (!escaped && c == '\"') {
                sb.append("\\\"");
            } else {
                sb.append(c);
            }
            escaped = !escaped && c == '\\';
        }
        if (escaped) {
            sb.deleteCharAt(sb.length() - 1);
        }
    }

    private static void encodeFilename(StringBuilder sb, String input, Charset charset) {
        byte[] source = input.getBytes(charset);
        sb.append(charset.name());
        sb.append("''");
        for (byte b : source) {
            if (ContentDisposition.isRFC5987AttrChar(b)) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            char hex1 = Ascii.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Ascii.toUpperCase(Character.forDigit(b & 0xF, 16));
            sb.append(hex1);
            sb.append(hex2);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentDisposition)) {
            return false;
        }
        ContentDisposition that = (ContentDisposition)other;
        return this.type.equals(that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.filename, that.filename) && Objects.equals(this.charset, that.charset);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.filename, this.charset);
    }

    public String asHeaderValue() {
        if (this.strVal != null) {
            return this.strVal;
        }
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder sb = tempThreadLocals.stringBuilder();
            sb.append(this.type);
            if (this.name != null) {
                sb.append("; name=\"");
                sb.append(this.name).append('\"');
            }
            if (this.filename != null) {
                if (this.charset == null || StandardCharsets.US_ASCII.equals(this.charset)) {
                    sb.append("; filename=\"");
                    ContentDisposition.escapeQuotationsInFilename(sb, this.filename);
                    sb.append('\"');
                } else {
                    sb.append("; filename*=");
                    ContentDisposition.encodeFilename(sb, this.filename, this.charset);
                }
            }
            String string = this.strVal = sb.toString();
            return string;
        }
    }

    public String toString() {
        return this.asHeaderValue();
    }
}

