/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Internal;
import graphql.util.LockKit;
import java.util.function.Supplier;

@Internal
public class InterThreadMemoizedSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    private volatile boolean initialized;
    private final LockKit.ReentrantLock lock = new LockKit.ReentrantLock();
    private T value;

    public InterThreadMemoizedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (this.initialized) {
                    T t = this.value;
                    return t;
                }
                this.value = this.delegate.get();
                this.initialized = true;
                T t = this.value;
                return t;
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.value;
    }
}

