/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.util.prometheus.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.prometheus.metrics.Metric;

public class Gauge
extends Metric {
    private double value;

    public Gauge(String name, Map<String, String> labels, double value, long timestamp) {
        super(name, labels, timestamp);
        this.value = value;
    }

    @Override
    public Metric sum(Metric m) {
        this.value += m.value().doubleValue();
        return this;
    }

    @Override
    public Double value() {
        return this.value;
    }

    @Generated
    public static GaugeBuilder builder() {
        return new GaugeBuilder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Gauge)) {
            return false;
        }
        Gauge other = (Gauge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Gauge;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Gauge(super=" + super.toString() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public static class GaugeBuilder {
        @Generated
        private String name;
        @Generated
        private ArrayList<String> labels$key;
        @Generated
        private ArrayList<String> labels$value;
        @Generated
        private double value;
        @Generated
        private long timestamp;

        @Generated
        GaugeBuilder() {
        }

        @Generated
        public GaugeBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public GaugeBuilder label(String labelKey, String labelValue) {
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            this.labels$key.add(labelKey);
            this.labels$value.add(labelValue);
            return this;
        }

        @Generated
        public GaugeBuilder labels(Map<? extends String, ? extends String> labels) {
            if (labels == null) {
                throw new NullPointerException("labels cannot be null");
            }
            if (this.labels$key == null) {
                this.labels$key = new ArrayList();
                this.labels$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : labels.entrySet()) {
                this.labels$key.add($lombokEntry.getKey());
                this.labels$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public GaugeBuilder clearLabels() {
            if (this.labels$key != null) {
                this.labels$key.clear();
                this.labels$value.clear();
            }
            return this;
        }

        @Generated
        public GaugeBuilder value(double value) {
            this.value = value;
            return this;
        }

        @Generated
        public GaugeBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Generated
        public Gauge build() {
            Map<String, String> labels;
            switch (this.labels$key == null ? 0 : this.labels$key.size()) {
                case 0: {
                    labels = Collections.emptyMap();
                    break;
                }
                case 1: {
                    labels = Collections.singletonMap(this.labels$key.get(0), this.labels$value.get(0));
                    break;
                }
                default: {
                    labels = new LinkedHashMap(this.labels$key.size() < 0x40000000 ? 1 + this.labels$key.size() + (this.labels$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.labels$key.size(); ++$i) {
                        labels.put(this.labels$key.get($i), this.labels$value.get($i));
                    }
                    labels = Collections.unmodifiableMap(labels);
                }
            }
            return new Gauge(this.name, labels, this.value, this.timestamp);
        }

        @Generated
        public String toString() {
            return "Gauge.GaugeBuilder(name=" + this.name + ", labels$key=" + String.valueOf(this.labels$key) + ", labels$value=" + String.valueOf(this.labels$value) + ", value=" + this.value + ", timestamp=" + this.timestamp + ")";
        }
    }
}

