/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.mqe.rt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.mqe.rt.MQEVisitorBase;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.grammar.MQEParser;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.query.AggregationQueryService;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.MetricsQueryService;
import org.apache.skywalking.oap.server.core.query.PointOfTime;
import org.apache.skywalking.oap.server.core.query.RecordQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.Order;
import org.apache.skywalking.oap.server.core.query.input.AttrCondition;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.Entity;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.input.RecordCondition;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQEVisitor
extends MQEVisitorBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQEVisitor.class);
    private final Entity entity;
    private final Duration duration;
    private final ModuleManager moduleManager;
    private MetricsQueryService metricsQueryService;
    private AggregationQueryService aggregationQueryService;
    private RecordQueryService recordQueryService;

    public MQEVisitor(ModuleManager moduleManager, Entity entity, Duration duration) {
        super(moduleManager, duration.getStep());
        this.moduleManager = moduleManager;
        this.entity = entity;
        this.duration = duration;
    }

    private MetricsQueryService getMetricsQueryService() {
        if (this.metricsQueryService == null) {
            this.metricsQueryService = (MetricsQueryService)this.moduleManager.find("core").provider().getService(MetricsQueryService.class);
        }
        return this.metricsQueryService;
    }

    private AggregationQueryService getAggregationQueryService() {
        if (this.aggregationQueryService == null) {
            this.aggregationQueryService = (AggregationQueryService)this.moduleManager.find("core").provider().getService(AggregationQueryService.class);
        }
        return this.aggregationQueryService;
    }

    private RecordQueryService getRecordQueryService() {
        if (this.recordQueryService == null) {
            this.recordQueryService = (RecordQueryService)this.moduleManager.find("core").provider().getService(RecordQueryService.class);
        }
        return this.recordQueryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ExpressionResult visitMetric(MQEParser.MetricContext ctx) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = traceContext.createSpan("MQE Metric OP: " + ctx.getText());
        try {
            ExpressionResult result;
            block31: {
                result = new ExpressionResult();
                String metricName = ctx.metricName().getText();
                Optional valueColumn = ValueColumnMetadata.INSTANCE.readValueColumnDefinition(metricName);
                if (valueColumn.isEmpty()) {
                    result.setType(ExpressionResultType.UNKNOWN);
                    result.setError("Metric: [" + metricName + "] does not exist.");
                    ExpressionResult expressionResult = result;
                    return expressionResult;
                }
                Column.ValueDataType dataType = ((ValueColumnMetadata.ValueColumn)valueColumn.get()).getDataType();
                try {
                    MQEParser.TopNContext parent;
                    if (Column.ValueDataType.COMMON_VALUE == dataType) {
                        if (ctx.parent instanceof MQEParser.TopNContext) {
                            parent = (MQEParser.TopNContext)ctx.parent;
                            int topN = Integer.parseInt(parent.INTEGER().getText());
                            if (topN <= 0) {
                                throw new IllegalExpressionException("TopN value must be > 0.");
                            }
                            ArrayList<AttrCondition> attrConditions = new ArrayList<AttrCondition>();
                            if (parent.attributeList() != null) {
                                for (MQEParser.AttributeContext attributeContext : parent.attributeList().attribute()) {
                                    String attrName = attributeContext.attributeName().getText();
                                    String attrValue = attributeContext.VALUE_STRING().getText();
                                    if (!StringUtil.isNotBlank((String)attrValue)) continue;
                                    String attrValueTrim = attrValue.substring(1, attrValue.length() - 1);
                                    if (attributeContext.EQ() != null) {
                                        attrConditions.add(new AttrCondition(attrName, attrValueTrim, true));
                                        continue;
                                    }
                                    if (attributeContext.NEQ() == null) continue;
                                    attrConditions.add(new AttrCondition(attrName, attrValueTrim, false));
                                }
                            }
                            this.querySortMetrics(metricName, Integer.parseInt(parent.INTEGER().getText()), Order.valueOf((String)parent.order().getText().toUpperCase()), attrConditions, result);
                        } else if (ctx.parent instanceof MQEParser.TrendOPContext) {
                            parent = (MQEParser.TrendOPContext)ctx.parent;
                            int trendRange = Integer.parseInt(parent.INTEGER().getText());
                            this.queryMetrics(metricName, this.getTrendQueryDuration(trendRange), result);
                        } else if (ctx.parent instanceof MQEParser.BaselineOPContext) {
                            parent = (MQEParser.BaselineOPContext)ctx.parent;
                            ArrayList<String> times = new ArrayList<String>();
                            for (PointOfTime pointOfTime : this.duration.assembleDurationPoints()) {
                                times.add(Long.toString(pointOfTime.getPoint()));
                            }
                            List valuesList = super.queryBaseline(this.entity.getServiceName(), metricName, times, parent.baseline_type().getStart().getType());
                            result.setResults(valuesList);
                            result.setType(ExpressionResultType.TIME_SERIES_VALUES);
                        } else {
                            this.queryMetrics(metricName, this.duration, result);
                        }
                        break block31;
                    }
                    if (Column.ValueDataType.LABELED_VALUE == dataType) {
                        if (ctx.parent instanceof MQEParser.TopNOPContext) {
                            throw new IllegalExpressionException("Metric: [" + metricName + "] is labeled value, does not support top_n query.");
                        }
                        List queryLabels = super.buildLabels(ctx.labelList());
                        if (ctx.parent instanceof MQEParser.TrendOPContext) {
                            MQEParser.TrendOPContext parent2 = (MQEParser.TrendOPContext)ctx.parent;
                            int trendRange = Integer.parseInt(parent2.INTEGER().getText());
                            this.queryLabeledMetrics(metricName, queryLabels, this.getTrendQueryDuration(trendRange), result);
                        } else if (ctx.parent instanceof MQEParser.BaselineOPContext) {
                            MQEParser.BaselineOPContext parent3 = (MQEParser.BaselineOPContext)ctx.parent;
                            ArrayList<String> times = new ArrayList<String>();
                            for (PointOfTime pointOfTime : this.duration.assembleDurationPoints()) {
                                times.add(Long.toString(pointOfTime.getPoint()));
                            }
                            List valuesList = super.queryLabeledBaseline(this.entity.getServiceName(), metricName, queryLabels, times, parent3.baseline_type().getStart().getType());
                            result.setResults(valuesList);
                            result.setType(ExpressionResultType.TIME_SERIES_VALUES);
                        } else {
                            this.queryLabeledMetrics(metricName, queryLabels, this.duration, result);
                        }
                        break block31;
                    }
                    if (Column.ValueDataType.SAMPLED_RECORD != dataType) break block31;
                    if (ctx.parent instanceof MQEParser.TopNContext) {
                        parent = (MQEParser.TopNContext)ctx.parent;
                        int topN = Integer.parseInt(parent.INTEGER().getText());
                        if (topN <= 0) {
                            throw new IllegalExpressionException("TopN value must be > 0.");
                        }
                        this.queryRecords(metricName, Integer.parseInt(parent.INTEGER().getText()), Order.valueOf((String)parent.order().getText().toUpperCase()), result);
                        break block31;
                    }
                    throw new IllegalExpressionException("Metric: [" + metricName + "] is topN record, need top_n function for query.");
                }
                catch (IllegalExpressionException e) {
                    ExpressionResult topN = this.getErrorResult(e.getMessage());
                    traceContext.stopSpan(span);
                    return topN;
                }
                catch (IOException e) {
                    ExpressionResult errorResult = this.getErrorResult("Internal IO exception, query metrics error.");
                    log.error("Query metrics from backend error.", (Throwable)e);
                    ExpressionResult expressionResult = errorResult;
                    traceContext.stopSpan(span);
                    return expressionResult;
                }
            }
            ExpressionResult expressionResult = result;
            return expressionResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            traceContext.stopSpan(span);
        }
    }

    private void querySortMetrics(String metricName, int topN, Order order, List<AttrCondition> attrConditions, ExpressionResult result) throws IOException {
        TopNCondition topNCondition = new TopNCondition();
        topNCondition.setName(metricName);
        topNCondition.setTopN(topN);
        topNCondition.setParentService(this.entity.getServiceName());
        topNCondition.setOrder(order);
        topNCondition.setNormal(this.entity.getNormal());
        topNCondition.setAttributes(attrConditions);
        List selectedRecords = this.getAggregationQueryService().sortMetrics(topNCondition, this.duration);
        ArrayList mqeValueList = new ArrayList(selectedRecords.size());
        selectedRecords.forEach(selectedRecord -> {
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(selectedRecord.getName());
            mqeValue.setEmptyValue(false);
            mqeValue.setDoubleValue(Double.parseDouble(selectedRecord.getValue()));
            mqeValue.setOwner(selectedRecord.getOwner());
            mqeValueList.add(mqeValue);
        });
        MQEValues mqeValues = new MQEValues();
        mqeValues.setValues(mqeValueList);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.SORTED_LIST);
    }

    private void queryRecords(String metricName, int topN, Order order, ExpressionResult result) throws IOException {
        RecordCondition recordCondition = new RecordCondition();
        recordCondition.setName(metricName);
        recordCondition.setTopN(topN);
        recordCondition.setParentEntity(this.entity);
        recordCondition.setOrder(order);
        List records = this.getRecordQueryService().readRecords(recordCondition, this.duration);
        ArrayList mqeValueList = new ArrayList(records.size());
        records.forEach(record -> {
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(record.getName());
            mqeValue.setEmptyValue(false);
            mqeValue.setDoubleValue(Double.parseDouble(record.getValue()));
            mqeValue.setTraceID(record.getRefId());
            mqeValueList.add(mqeValue);
        });
        MQEValues mqeValues = new MQEValues();
        mqeValues.setValues(mqeValueList);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.RECORD_LIST);
    }

    private void queryMetrics(String metricName, Duration queryDuration, ExpressionResult result) throws IOException {
        MetricsCondition metricsCondition = new MetricsCondition();
        metricsCondition.setName(metricName);
        metricsCondition.setEntity(this.entity);
        MetricsValues metricsValues = this.getMetricsQueryService().readMetricsValues(metricsCondition, queryDuration);
        List times = queryDuration.assembleDurationPoints();
        if (metricsValues.getValues().getValues().size() != times.size()) {
            log.warn("Metric: {} values size is not equal to duration points size, metrics values size: {}, duration points size: {}", new Object[]{metricName, metricsValues.getValues().getValues().size(), times.size()});
            return;
        }
        ArrayList<MQEValue> mqeValueList = new ArrayList<MQEValue>(times.size());
        for (int i = 0; i < times.size(); ++i) {
            long retTimestamp = DurationUtils.INSTANCE.parseToDateTime(queryDuration.getStep(), ((PointOfTime)times.get(i)).getPoint()).getMillis();
            KVInt kvInt = (KVInt)metricsValues.getValues().getValues().get(i);
            MQEValue mqeValue = new MQEValue();
            mqeValue.setId(Long.toString(retTimestamp));
            mqeValue.setEmptyValue(kvInt.isEmptyValue());
            mqeValue.setDoubleValue((double)kvInt.getValue());
            mqeValueList.add(mqeValue);
        }
        MQEValues mqeValues = new MQEValues();
        mqeValues.setValues(mqeValueList);
        result.getResults().add(mqeValues);
        result.setType(ExpressionResultType.TIME_SERIES_VALUES);
    }

    private void queryLabeledMetrics(String metricName, List<KeyValue> queryLabels, Duration queryDuration, ExpressionResult result) throws IOException {
        MetricsCondition metricsCondition = new MetricsCondition();
        metricsCondition.setName(metricName);
        metricsCondition.setEntity(this.entity);
        List metricsValuesList = this.getMetricsQueryService().readLabeledMetricsValues(metricsCondition, queryLabels, queryDuration);
        List times = queryDuration.assembleDurationPoints();
        metricsValuesList.forEach(metricsValues -> {
            if (metricsValues.getValues().getValues().size() != times.size()) {
                log.warn("Metric: {} values size is not equal to duration points size, metrics values size: {}, duration points size: {}", new Object[]{metricName, metricsValues.getValues().getValues().size(), times.size()});
                return;
            }
            ArrayList<MQEValue> mqeValueList = new ArrayList<MQEValue>(times.size());
            for (int i = 0; i < times.size(); ++i) {
                long retTimestamp = DurationUtils.INSTANCE.parseToDateTime(queryDuration.getStep(), ((PointOfTime)times.get(i)).getPoint()).getMillis();
                KVInt kvInt = (KVInt)metricsValues.getValues().getValues().get(i);
                MQEValue mqeValue = new MQEValue();
                mqeValue.setEmptyValue(kvInt.isEmptyValue());
                mqeValue.setId(Long.toString(retTimestamp));
                mqeValueList.add(mqeValue);
                if (kvInt.isEmptyValue()) continue;
                mqeValue.setDoubleValue((double)kvInt.getValue());
            }
            MQEValues mqeValues = new MQEValues();
            DataLabel dataLabel = new DataLabel();
            dataLabel.put(metricsValues.getLabel());
            for (Map.Entry label : dataLabel.entrySet()) {
                mqeValues.getMetric().getLabels().add(new KeyValue((String)label.getKey(), (String)label.getValue()));
            }
            mqeValues.getMetric().sortLabelsByKey(Comparator.naturalOrder());
            mqeValues.setValues(mqeValueList);
            result.getResults().add(mqeValues);
        });
        result.setType(ExpressionResultType.TIME_SERIES_VALUES);
        result.setLabeledResult(true);
    }

    private Duration getTrendQueryDuration(int stepRange) {
        Duration duration = new Duration();
        duration.setStep(this.duration.getStep());
        duration.setEnd(this.duration.getEnd());
        DateTime startDT = new DateTime(this.duration.getStartTimestamp());
        switch (duration.getStep()) {
            case DAY: {
                duration.setStart(startDT.minusDays(stepRange).toString(DurationUtils.YYYY_MM_DD));
                break;
            }
            case HOUR: {
                duration.setStart(startDT.minusHours(stepRange).toString(DurationUtils.YYYY_MM_DD_HH));
                break;
            }
            case MINUTE: {
                duration.setStart(startDT.minusMinutes(stepRange).toString(DurationUtils.YYYY_MM_DD_HHMM));
                break;
            }
            case SECOND: {
                duration.setStart(startDT.minusSeconds(stepRange).toString(DurationUtils.YYYY_MM_DD_HHMMSS));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported query step: " + String.valueOf(duration.getStep()));
            }
        }
        return duration;
    }
}

