/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.SQLAndParameters;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;

public class JDBCProfileTaskLogQueryDAO
implements IProfileTaskLogQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    public List<ProfileTaskLog> getTaskLogList() {
        List<String> tables = this.tableHelper.getTablesWithinTTL("profile_task_log");
        ArrayList<ProfileTaskLog> results = new ArrayList<ProfileTaskLog>();
        for (String table : tables) {
            SQLAndParameters sqlAndParameters = this.buildSQL(table);
            results.addAll((Collection)this.jdbcClient.executeQuery(sqlAndParameters.sql(), resultSet -> {
                ArrayList<ProfileTaskLog> tasks = new ArrayList<ProfileTaskLog>();
                while (resultSet.next()) {
                    tasks.add(this.parseLog(resultSet));
                }
                return tasks;
            }, sqlAndParameters.parameters()));
        }
        return results;
    }

    protected SQLAndParameters buildSQL(String table) {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>(2);
        sql.append("select * from ").append(table).append(" where ").append("table_name").append(" = ?");
        parameters.add("profile_task_log");
        sql.append(" ORDER BY ").append("operation_time").append(" DESC ");
        return new SQLAndParameters(sql.toString(), parameters);
    }

    private ProfileTaskLog parseLog(ResultSet data) throws SQLException {
        return ProfileTaskLog.builder().id(data.getString("id")).taskId(data.getString("task_id")).instanceId(data.getString("instance_id")).operationType(ProfileTaskLogOperationType.parse((int)data.getInt("operation_type"))).operationTime(data.getLong("operation_time")).build();
    }

    @Generated
    public JDBCProfileTaskLogQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

