/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.logging.DefaultLogWriter;
import com.linecorp.armeria.common.logging.LogFormatter;
import com.linecorp.armeria.common.logging.LogWriterBuilder;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import java.util.Objects;
import org.slf4j.Logger;

@UnstableApi
public interface LogWriter {
    public static LogWriter of() {
        return DefaultLogWriter.DEFAULT;
    }

    public static LogWriter of(Logger logger) {
        return LogWriter.builder().logger(logger).build();
    }

    public static LogWriter of(LogFormatter logFormatter) {
        return LogWriter.builder().logFormatter(logFormatter).build();
    }

    public static LogWriterBuilder builder() {
        return new LogWriterBuilder();
    }

    public void logRequest(RequestOnlyLog var1);

    public void logResponse(RequestLog var1);

    default public LogWriter andThen(final LogWriter after) {
        Objects.requireNonNull(after, "after");
        return new LogWriter(){

            @Override
            public void logRequest(RequestOnlyLog log) {
                try {
                    LogWriter.this.logRequest(log);
                }
                finally {
                    after.logRequest(log);
                }
            }

            @Override
            public void logResponse(RequestLog log) {
                try {
                    LogWriter.this.logResponse(log);
                }
                finally {
                    after.logResponse(log);
                }
            }
        };
    }
}

