/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.pprof.provider.handler.stream;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.network.pprof.v10.PprofCollectionResponse;
import org.apache.skywalking.apm.network.pprof.v10.PprofData;
import org.apache.skywalking.apm.network.pprof.v10.PprofProfilingStatus;
import org.apache.skywalking.oap.server.core.query.type.PprofEventType;
import org.apache.skywalking.oap.server.core.query.type.PprofTask;
import org.apache.skywalking.oap.server.core.query.type.PprofTaskLogOperationType;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.PprofProfilingData;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.storage.profiling.pprof.IPprofTaskQueryDAO;
import org.apache.skywalking.oap.server.library.pprof.parser.PprofParser;
import org.apache.skywalking.oap.server.library.pprof.type.FrameTree;
import org.apache.skywalking.oap.server.receiver.pprof.provider.handler.PprofServiceHandler;
import org.apache.skywalking.oap.server.receiver.pprof.provider.handler.stream.PprofCollectionMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PprofByteBufCollectionObserver
implements StreamObserver<PprofData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PprofByteBufCollectionObserver.class);
    private final IPprofTaskQueryDAO taskDAO;
    private final StreamObserver<PprofCollectionResponse> responseObserver;
    private final SourceReceiver sourceReceiver;
    private final int pprofMaxSize;
    private PprofCollectionMetaData taskMetaData;
    private ByteBuffer buf;

    public PprofByteBufCollectionObserver(IPprofTaskQueryDAO taskDAO, StreamObserver<PprofCollectionResponse> responseObserver, SourceReceiver sourceReceiver, int pprofMaxSize) {
        this.taskDAO = taskDAO;
        this.responseObserver = responseObserver;
        this.sourceReceiver = sourceReceiver;
        this.pprofMaxSize = pprofMaxSize;
    }

    public void onNext(PprofData pprofData) {
        try {
            if (Objects.isNull(this.taskMetaData) && pprofData.hasMetadata()) {
                this.taskMetaData = PprofServiceHandler.parseMetaData(pprofData.getMetadata(), this.taskDAO);
                if (PprofProfilingStatus.PPROF_PROFILING_SUCCESS.equals((Object)this.taskMetaData.getType())) {
                    int size = this.taskMetaData.getContentSize();
                    if (this.pprofMaxSize >= size) {
                        this.buf = ByteBuffer.allocate(size);
                        this.responseObserver.onNext((Object)PprofCollectionResponse.newBuilder().setStatus(PprofProfilingStatus.PPROF_PROFILING_SUCCESS).build());
                    } else {
                        this.responseObserver.onNext((Object)PprofCollectionResponse.newBuilder().setStatus(PprofProfilingStatus.PPROF_TERMINATED_BY_OVERSIZE).build());
                        PprofServiceHandler.recordPprofTaskLog(this.taskMetaData.getTask(), this.taskMetaData.getInstanceId(), PprofTaskLogOperationType.PPROF_UPLOAD_FILE_TOO_LARGE_ERROR);
                    }
                } else {
                    this.responseObserver.onNext((Object)PprofCollectionResponse.newBuilder().setStatus(PprofProfilingStatus.PPROF_EXECUTION_TASK_ERROR).build());
                    PprofServiceHandler.recordPprofTaskLog(this.taskMetaData.getTask(), this.taskMetaData.getInstanceId(), PprofTaskLogOperationType.EXECUTION_TASK_ERROR);
                }
            } else if (pprofData.hasContent() && this.buf != null) {
                pprofData.getContent().copyTo(this.buf);
            }
        }
        catch (IOException e) {
            log.error("Error processing pprof data", (Throwable)e);
            this.responseObserver.onError((Throwable)Status.INTERNAL.withDescription("Error processing pprof data: " + e.getMessage()).asRuntimeException());
        }
    }

    public void onError(Throwable throwable) {
        Status status = Status.fromThrowable((Throwable)throwable);
        if (Status.CANCELLED.getCode() == status.getCode()) {
            if (log.isDebugEnabled()) {
                log.debug(throwable.getMessage(), throwable);
            }
            return;
        }
        log.error("Error in receiving pprof profiling data", throwable);
    }

    public void onCompleted() {
        this.responseObserver.onCompleted();
        if (Objects.nonNull(this.buf)) {
            this.buf.flip();
            try {
                this.parseAndStorageData(this.taskMetaData, this.buf);
            }
            catch (IOException e) {
                log.error("Failed to parse and store pprof data", (Throwable)e);
            }
        }
    }

    private void parseAndStorageData(PprofCollectionMetaData taskMetaData, ByteBuffer buf) throws IOException {
        PprofTask task = taskMetaData.getTask();
        if (task == null) {
            log.error("Pprof instanceId:{} has not been assigned a task but still uploaded data", (Object)taskMetaData.getInstanceId());
            return;
        }
        PprofServiceHandler.recordPprofTaskLog(task, taskMetaData.getInstanceId(), PprofTaskLogOperationType.EXECUTION_FINISHED);
        this.parsePprofAndStorage(taskMetaData, buf);
    }

    public void parsePprofAndStorage(PprofCollectionMetaData taskMetaData, ByteBuffer buf) throws IOException {
        PprofTask task = taskMetaData.getTask();
        FrameTree tree = PprofParser.dumpTree((ByteBuffer)buf);
        PprofProfilingData data = new PprofProfilingData();
        data.setEventType(PprofEventType.valueOfString((String)task.getEvents().name()));
        data.setFrameTree((Object)tree);
        data.setTaskId(task.getId());
        data.setInstanceId(taskMetaData.getInstanceId());
        data.setUploadTime(taskMetaData.getUploadTime());
        this.sourceReceiver.receive((ISource)data);
    }
}

