/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cta.impl;

import java.util.Collections;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.bytecode.Descriptor;
import org.apache.sling.cta.impl.AgentInfo;
import org.apache.sling.cta.impl.MBeanAwareTimeoutTransformer;

public abstract class UpdateFieldsInConstructorTimeoutTransformer
extends MBeanAwareTimeoutTransformer {
    private final String connectTimeoutFieldName;
    private final String readTimeoutFieldName;
    private final long connectTimeoutMillis;
    private final long readTimeoutMillis;

    public UpdateFieldsInConstructorTimeoutTransformer(String className, String connectTimeoutFieldName, String readTimeoutFieldName, long connectTimeoutMillis, long readTimeoutMillis, AgentInfo agentInfo) {
        super(agentInfo, Collections.singleton(className));
        this.connectTimeoutFieldName = connectTimeoutFieldName;
        this.readTimeoutFieldName = readTimeoutFieldName;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Override
    protected byte[] doTransformClass(CtClass cc) throws Exception {
        CtConstructor noArgCtor = cc.getConstructor(Descriptor.ofConstructor((CtClass[])new CtClass[0]));
        CtField connectTimeout = cc.getDeclaredField(this.connectTimeoutFieldName);
        CtField readTimeout = cc.getDeclaredField(this.readTimeoutFieldName);
        noArgCtor.insertAfter("this." + connectTimeout.getName() + " = " + this.connectTimeoutMillis + ";");
        noArgCtor.insertAfter("this." + readTimeout.getName() + " = " + this.readTimeoutMillis + ";");
        byte[] classfileBuffer = cc.toBytecode();
        cc.detach();
        return classfileBuffer;
    }
}

