/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.servlets.ErrorHandler;
import org.apache.sling.api.servlets.JakartaErrorHandler;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.api.wrappers.JakartaToJavaxResponseWrapper;
import org.apache.sling.engine.impl.ProductInfoProvider;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorHandler
implements JakartaErrorHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile String serverInfo = ProductInfoProvider.PRODUCT_NAME;
    private volatile JakartaErrorHandler delegate;
    private volatile JakartaErrorHandler errorHandler;
    private volatile JakartaErrorHandler jakartaErrorHandler;
    private volatile ServiceReference<?> errorHandlerRef;
    private volatile ServiceReference<?> jakartaErrorHandlerRef;

    void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo != null ? serverInfo : ProductInfoProvider.PRODUCT_NAME;
    }

    public synchronized void setDelegate(ServiceReference<?> ref, final ErrorHandler eh) {
        if (eh != null) {
            this.errorHandler = new JakartaErrorHandler(){

                public void handleError(int status, String message, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
                    eh.handleError(status, message, JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((SlingJakartaHttpServletResponse)response));
                }

                public void handleError(Throwable throwable, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
                    eh.handleError(throwable, JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)request), JakartaToJavaxResponseWrapper.toJavaxResponse((SlingJakartaHttpServletResponse)response));
                }
            };
            this.errorHandlerRef = ref;
            if (this.jakartaErrorHandlerRef == null || this.jakartaErrorHandlerRef.compareTo(ref) < 0) {
                this.delegate = this.errorHandler;
            }
        } else {
            this.errorHandler = null;
            this.errorHandlerRef = null;
            this.delegate = this.jakartaErrorHandler;
        }
    }

    public synchronized void setDelegate(ServiceReference<?> ref, JakartaErrorHandler eh) {
        if (eh != null) {
            this.jakartaErrorHandler = eh;
            this.jakartaErrorHandlerRef = ref;
            if (this.errorHandlerRef == null || this.errorHandlerRef.compareTo(ref) < 0) {
                this.delegate = this.jakartaErrorHandler;
            }
        } else {
            this.jakartaErrorHandler = null;
            this.jakartaErrorHandlerRef = null;
            this.delegate = this.errorHandler;
        }
    }

    private void delegateFailed(int originalStatus, String originalMessage, Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String m = "Error handler failed:" + t.getClass().getName();
        this.log.error(m, t);
        if (response.isCommitted()) {
            this.log.warn("handleError: Response already committed; cannot send error " + originalStatus + " : " + originalMessage);
            return;
        }
        response.reset();
        this.sendError(originalStatus, originalMessage, null, request, response);
    }

    public void handleError(int status, String message, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        JakartaErrorHandler local = this.delegate;
        if (local != null) {
            try {
                local.handleError(status, (String)message, request, response);
            }
            catch (Exception e) {
                this.delegateFailed(status, (String)message, e, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            return;
        }
        message = message == null ? "HTTP ERROR:" + String.valueOf(status) : "HTTP ERROR:" + status + " - " + (String)message;
        this.sendError(status, (String)message, null, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public void handleError(Throwable throwable, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        int status = 500;
        JakartaErrorHandler local = this.delegate;
        if (local != null) {
            try {
                local.handleError(throwable, request, response);
            }
            catch (Exception e) {
                this.delegateFailed(500, throwable.toString(), e, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            return;
        }
        this.sendError(500, throwable.getMessage(), throwable, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    private void sendError(int status, String message, Throwable throwable, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String servletName = (String)request.getAttribute("jakarta.servlet.error.servlet_name");
        String requestURI = (String)request.getAttribute("jakarta.servlet.error.request_uri");
        if (requestURI == null) {
            requestURI = request.getRequestURI();
        }
        response.setStatus(status);
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter pw = response.getWriter();
        pw.print("<html><head><title>");
        if (message == null) {
            pw.print("Internal error");
        } else {
            pw.print(ResponseUtil.escapeXml((String)message));
        }
        pw.println("</title></head><body><h1>");
        if (throwable != null) {
            pw.println(ResponseUtil.escapeXml((String)throwable.toString()));
        } else if (message != null) {
            pw.println(ResponseUtil.escapeXml((String)message));
        } else {
            pw.println("Internal error (no Exception to report)");
        }
        pw.println("</h1><p>");
        pw.print("RequestURI=");
        pw.println(ResponseUtil.escapeXml((String)request.getRequestURI()));
        if (servletName != null) {
            pw.println("</p><p>Servlet=");
            pw.println(ResponseUtil.escapeXml((String)servletName));
        }
        pw.println("</p>");
        if (throwable != null) {
            PrintWriter escapingWriter = new PrintWriter(ResponseUtil.getXmlEscapingWriter((Writer)pw));
            pw.println("<h3>Exception stacktrace:</h3>");
            pw.println("<pre>");
            pw.flush();
            throwable.printStackTrace(escapingWriter);
            escapingWriter.flush();
            pw.println("</pre>");
            RequestProgressTracker tracker = ((SlingJakartaHttpServletRequest)request).getRequestProgressTracker();
            pw.println("<h3>Request Progress:</h3>");
            pw.println("<pre>");
            pw.flush();
            tracker.dump(new PrintWriter(escapingWriter));
            escapingWriter.flush();
            pw.println("</pre>");
        }
        pw.println("<hr /><address>");
        pw.println(ResponseUtil.escapeXml((String)this.serverInfo));
        pw.println("</address></body></html>");
        response.flushBuffer();
        pw.close();
    }
}

