/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.api;

public class UpdateResult {
    private final String url;
    private String digest;
    private Integer priority;
    private boolean resourceIsMoved = false;

    public UpdateResult(String url) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        this.url = url;
    }

    public String getURL() {
        return this.url;
    }

    public String getScheme() {
        int pos = this.url.indexOf(58);
        return this.url.substring(0, pos);
    }

    public String getResourceId() {
        int pos = this.url.indexOf(58);
        return this.url.substring(pos + 1);
    }

    public String getDigest() {
        return this.digest;
    }

    public int getPriority() {
        return this.priority != null ? this.priority : 100;
    }

    public void setPriority(Integer prio) {
        this.priority = prio;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setResourceIsMoved(boolean flag) {
        this.resourceIsMoved = flag;
    }

    public boolean getResourceIsMoved() {
        return this.resourceIsMoved;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", priority=" + this.getPriority() + ", url=" + this.url;
    }
}

