/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.ResourceChangeListener;
import org.apache.sling.installer.api.UpdateHandler;
import org.apache.sling.installer.api.UpdateResult;
import org.apache.sling.installer.api.info.InfoProvider;
import org.apache.sling.installer.api.info.InstallationState;
import org.apache.sling.installer.api.info.Resource;
import org.apache.sling.installer.api.info.ResourceGroup;
import org.apache.sling.installer.api.tasks.ChangeStateTask;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.InstallTaskFactory;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.api.tasks.RegisteredResource;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.ResourceTransformer;
import org.apache.sling.installer.api.tasks.ResourceUpdater;
import org.apache.sling.installer.api.tasks.RetryHandler;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.api.tasks.UpdatableResourceGroup;
import org.apache.sling.installer.core.impl.AsyncWrapperInstallTask;
import org.apache.sling.installer.core.impl.EntityResourceList;
import org.apache.sling.installer.core.impl.FileDataStore;
import org.apache.sling.installer.core.impl.InstallListener;
import org.apache.sling.installer.core.impl.InternalResource;
import org.apache.sling.installer.core.impl.PersistentResourceList;
import org.apache.sling.installer.core.impl.RegisteredResourceImpl;
import org.apache.sling.installer.core.impl.ResourceData;
import org.apache.sling.installer.core.impl.SortingServiceTracker;
import org.apache.sling.installer.core.impl.UpdateHandlerTracker;
import org.apache.sling.installer.core.impl.tasks.BundleUpdateTask;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiInstallerImpl
implements OsgiInstaller,
ResourceChangeListener,
RetryHandler,
InfoProvider,
Runnable {
    private static final String PROP_START_LEVEL_HANDLING = "sling.installer.switchstartlevel";
    private static final String PROP_EXPERIMENTAL_MULTI_VERSION_SUPPORT = "sling.installer.experimental.multiversion";
    private static final String PROP_REQUIRED_SERVICES = "sling.installer.requiredservices";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Logger auditLogger = LoggerFactory.getLogger((String)"org.apache.sling.audit.osgi.installer");
    private final BundleContext ctx;
    private final Map<String, List<InternalResource>> newResourcesSchemes = new HashMap<String, List<InternalResource>>();
    private final List<InternalResource> newResources = new LinkedList<InternalResource>();
    private final Set<String> urlsToRemove = new HashSet<String>();
    private final List<UpdateInfo> updateInfos = new ArrayList<UpdateInfo>();
    private volatile boolean satisfied = false;
    private volatile boolean active = true;
    private volatile Thread backgroundThread;
    private volatile boolean retryDuringTaskExecution = false;
    private PersistentResourceList persistentList;
    private SortingServiceTracker<InstallTaskFactory> factoryTracker;
    private SortingServiceTracker<ResourceTransformer> transformerTracker;
    private UpdateHandlerTracker updateHandlerTracker;
    private SortingServiceTracker<ResourceUpdater> updaterTracker;
    private final Object resourcesLock = new Object();
    private final InstallListener listener;
    private final AtomicLong backgroundTaskCounter = new AtomicLong();
    private final boolean switchStartLevel;
    private static final Comparator<ResourceGroup> COMPARATOR = new Comparator<ResourceGroup>(){

        @Override
        public int compare(ResourceGroup o1, ResourceGroup o2) {
            int result;
            RegisteredResource r1 = null;
            RegisteredResource r2 = null;
            if (o1.getResources().size() > 0) {
                r1 = o1.getResources().iterator().next();
            }
            if (o2.getResources().size() > 0) {
                r2 = o2.getResources().iterator().next();
            }
            if (r1 == null && r2 == null) {
                result = 0;
            } else if (r1 == null) {
                result = -1;
            } else if (r2 == null) {
                result = 1;
            } else {
                result = r1.getType().compareTo(r2.getType());
                if (result == 0) {
                    result = r1.getEntityId().compareTo(r2.getEntityId());
                }
            }
            return result;
        }
    };

    public OsgiInstallerImpl(BundleContext ctx) {
        this.ctx = ctx;
        new FileDataStore(ctx);
        File f = FileDataStore.SHARED.getDataFile("RegisteredResourceList.ser");
        this.listener = new InstallListener(ctx, this.logger);
        this.persistentList = new PersistentResourceList(f, this.listener);
        this.switchStartLevel = (Boolean)((Converting)Converters.standardConverter().convert((Object)ctx.getProperty(PROP_START_LEVEL_HANDLING)).defaultValue((Object)Boolean.FALSE)).to(Boolean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.resourcesLock;
        synchronized (object) {
            this.logger.debug("Deactivating and notifying resourcesLock");
            this.active = false;
            this.resourcesLock.notify();
        }
        if (this.factoryTracker != null) {
            this.factoryTracker.close();
        }
        if (this.transformerTracker != null) {
            this.transformerTracker.close();
        }
        if (this.updateHandlerTracker != null) {
            this.updateHandlerTracker.close();
        }
        if (this.updaterTracker != null) {
            this.updaterTracker.close();
        }
        this.listener.dispose();
        if (this.backgroundThread != null) {
            Thread t;
            if (this.logger.isDebugEnabled() && (t = this.backgroundThread) != null) {
                this.logger.debug("Waiting for main background thread {} to stop", (Object)t.getName());
            }
            while (this.backgroundThread != null) {
                t = this.backgroundThread;
                if (t == null) continue;
                try {
                    t.join(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.logger.debug("Done waiting for background thread");
        }
        FileDataStore.SHARED = null;
        this.logger.info("Apache Sling OSGi Installer Service stopped.");
    }

    public void start() {
        this.startBackgroundThread();
    }

    private void init() {
        this.factoryTracker = new SortingServiceTracker(this.ctx, InstallTaskFactory.class.getName(), this);
        this.transformerTracker = new SortingServiceTracker(this.ctx, ResourceTransformer.class.getName(), this);
        this.updateHandlerTracker = new UpdateHandlerTracker(this.ctx, this);
        this.updaterTracker = new SortingServiceTracker(this.ctx, ResourceUpdater.class.getName(), this);
        this.factoryTracker.open();
        this.transformerTracker.open();
        this.updateHandlerTracker.open();
        this.updaterTracker.open();
        this.logger.info("Apache Sling OSGi Installer Service started.");
        this.checkSatisfied();
    }

    private void startBackgroundThread() {
        this.backgroundThread = new Thread(this);
        this.backgroundThread.setName(this.getClass().getSimpleName());
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug("Main background thread starts");
        try {
            this.init();
            while (this.active) {
                this.listener.start();
                this.handleResourceUpdaters();
                this.processUpdateInfos();
                this.mergeNewlyRegisteredResources();
                Object object = this.resourcesLock;
                synchronized (object) {
                    if (!this.satisfied) {
                        this.logger.debug("Required services are not available yet.");
                        try {
                            this.logger.debug("wait() on resourcesLock");
                            this.resourcesLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.retryDuringTaskExecution = false;
                }
                this.transformResources();
                SortedSet<InstallTask> tasks = this.computeTasks();
                ACTION action = this.executeTasks(tasks);
                if (action == ACTION.SLEEP) {
                    Object object2 = this.resourcesLock;
                    synchronized (object2) {
                        if (!this.hasNewResources() && this.active && !this.retryDuringTaskExecution) {
                            this.logger.debug("No more tasks to process, suspending listener and going idle");
                            this.listener.suspend();
                            try {
                                this.logger.debug("wait() on resourcesLock");
                                this.resourcesLock.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (this.active) {
                                this.logger.debug("Done wait()ing on resourcesLock, restarting listener");
                                this.listener.start();
                            } else {
                                this.logger.debug("Done wait()ing on resourcesLock, but active={}, listener won't be restarted now", (Object)this.active);
                            }
                        }
                        continue;
                    }
                }
                if (action != ACTION.SHUTDOWN) continue;
                this.logger.debug("Action is SHUTDOWN, going inactive");
                this.active = false;
            }
            this.listener.suspend();
        }
        catch (Exception fatal) {
            this.logger.error("An unexpected error occured in the installer task. Installer is stopped now!", (Throwable)fatal);
        }
        finally {
            this.backgroundThread = null;
        }
        this.logger.debug("Main background thread ends");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() {
        this.logger.debug("wakeUp called");
        this.listener.start();
        Object object = this.resourcesLock;
        synchronized (object) {
            this.resourcesLock.notify();
        }
    }

    private boolean hasNewResources() {
        return !this.newResources.isEmpty() || !this.newResourcesSchemes.isEmpty() || !this.urlsToRemove.isEmpty() || !this.updateInfos.isEmpty();
    }

    private void checkScheme(String scheme) {
        if (scheme == null || scheme.length() == 0) {
            throw new IllegalArgumentException("Scheme required");
        }
        if (scheme.indexOf(58) != -1) {
            throw new IllegalArgumentException("Scheme must not contain a colon");
        }
    }

    private List<InternalResource> createResources(String scheme, InstallableResource[] resources) {
        this.checkScheme(scheme);
        ArrayList<InternalResource> createdResources = null;
        if (resources != null && resources.length > 0) {
            createdResources = new ArrayList<InternalResource>();
            for (InstallableResource r : resources) {
                try {
                    InternalResource rr = InternalResource.create(scheme, r);
                    createdResources.add(rr);
                    this.logger.debug("Registering new resource: {}", (Object)rr);
                }
                catch (Exception e) {
                    this.logger.warn("Cannot create InternalResource (resource will be ignored):" + r, (Throwable)e);
                }
            }
        }
        return createdResources;
    }

    private void closeInputStreams(InstallableResource[] resources) {
        if (resources != null) {
            for (InstallableResource r : resources) {
                InputStream is = r.getInputStream();
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResources(String scheme, InstallableResource[] resources, String[] idsToRemove) {
        this.listener.start();
        try {
            List<InternalResource> updatedResources = this.createResources(scheme, resources);
            Object object = this.resourcesLock;
            synchronized (object) {
                if (updatedResources != null && updatedResources.size() > 0) {
                    this.newResources.addAll(updatedResources);
                    HashSet<String> newUrls = new HashSet<String>();
                    for (InternalResource rsrc : updatedResources) {
                        newUrls.add(rsrc.getURL());
                    }
                    Iterator<String> urlIter = this.urlsToRemove.iterator();
                    while (urlIter.hasNext() && !newUrls.isEmpty()) {
                        String url = (String)urlIter.next();
                        if (!newUrls.remove(url)) continue;
                        urlIter.remove();
                    }
                }
                if (idsToRemove != null && idsToRemove.length > 0) {
                    HashSet<String> removedUrls = new HashSet<String>();
                    for (String id : idsToRemove) {
                        String url = scheme + ':' + id;
                        this.urlsToRemove.add(url);
                        removedUrls.add(url);
                    }
                    Iterator<InternalResource> rsrcIter = this.newResources.iterator();
                    while (rsrcIter.hasNext() && !removedUrls.isEmpty()) {
                        InternalResource rsrc = rsrcIter.next();
                        if (!removedUrls.remove(rsrc.getURL())) continue;
                        if (rsrc.getPrivateCopyOfFile() != null) {
                            rsrc.getPrivateCopyOfFile().delete();
                        }
                        rsrcIter.remove();
                    }
                }
            }
            this.wakeUp();
        }
        finally {
            this.closeInputStreams(resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerResources(String scheme, InstallableResource[] resources) {
        this.listener.start();
        try {
            List<InternalResource> incomingResources = this.createResources(scheme, resources);
            if (incomingResources == null) {
                incomingResources = new ArrayList<InternalResource>();
            }
            this.logger.debug("Registered new resource scheme: {}", (Object)scheme);
            Object object = this.resourcesLock;
            synchronized (object) {
                this.newResourcesSchemes.put(scheme, incomingResources);
                String prefix = scheme + ':';
                Iterator<InternalResource> rsrcIter = this.newResources.iterator();
                while (rsrcIter.hasNext()) {
                    InternalResource rsrc = rsrcIter.next();
                    if (!rsrc.getURL().startsWith(prefix)) continue;
                    this.prepareToRemove(rsrc, incomingResources);
                    rsrcIter.remove();
                }
                Iterator<String> urlIter = this.urlsToRemove.iterator();
                while (urlIter.hasNext()) {
                    String url = urlIter.next();
                    if (!url.startsWith(prefix)) continue;
                    urlIter.remove();
                }
            }
            this.wakeUp();
        }
        finally {
            this.closeInputStreams(resources);
        }
    }

    private void prepareToRemove(InternalResource existing, Collection<InternalResource> incoming) {
        if (existing.getPrivateCopyOfFile() != null) {
            for (InternalResource r : incoming) {
                if (!r.getURL().equals(existing.getURL())) continue;
                if (r.getPrivateCopyOfFile() == null) {
                    this.logger.debug("{} has no private data file, using the one from {}", (Object)r.getURL(), (Object)existing.getURL());
                    r.setPrivateCopyOfFile(existing.getPrivateCopyOfFile());
                    existing.setPrivateCopyOfFile(null);
                    break;
                }
                if (!r.getPrivateCopyOfFile().equals(existing.getPrivateCopyOfFile())) break;
                this.logger.debug("{} has same private data file as existing resource, keeping it", (Object)r.getURL());
                existing.setPrivateCopyOfFile(null);
                break;
            }
            if (existing.getPrivateCopyOfFile() != null) {
                this.logger.debug("Private data file not needed anymore, deleting it: {}", (Object)existing.getURL());
                existing.getPrivateCopyOfFile().delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNewlyRegisteredResources() {
        Object object = this.resourcesLock;
        synchronized (object) {
            for (Map.Entry<String, List<InternalResource>> entry : this.newResourcesSchemes.entrySet()) {
                String scheme = entry.getKey();
                List<InternalResource> registeredResources = entry.getValue();
                this.logger.debug("Processing set of new resources with scheme {}", (Object)scheme);
                for (String entityId : this.persistentList.getEntityIds()) {
                    EntityResourceList group = this.persistentList.getEntityResourceList(entityId);
                    ArrayList<TaskResource> toRemove = new ArrayList<TaskResource>();
                    boolean first = true;
                    for (TaskResource taskResource : group.listResources()) {
                        if (taskResource.getScheme().equals(scheme)) {
                            this.logger.debug("Checking {}", (Object)taskResource);
                            boolean found = false;
                            if (registeredResources != null) {
                                Iterator<InternalResource> m = registeredResources.iterator();
                                while (!found && m.hasNext()) {
                                    InternalResource testResource = m.next();
                                    found = testResource.getURL().equals(taskResource.getURL());
                                }
                            }
                            if (!found) {
                                this.logger.debug("Resource {} seems to be removed.", (Object)taskResource);
                                if (first && (taskResource.getState() == ResourceState.INSTALLED || taskResource.getState() == ResourceState.INSTALL)) {
                                    ((RegisteredResourceImpl)taskResource).setState(ResourceState.UNINSTALL, null);
                                } else {
                                    toRemove.add(taskResource);
                                }
                            }
                        }
                        first = false;
                    }
                    for (TaskResource taskResource : toRemove) {
                        this.persistentList.remove(taskResource.getURL());
                    }
                }
                if (registeredResources == null) continue;
                this.newResources.addAll(registeredResources);
            }
            this.newResourcesSchemes.clear();
            this.mergeNewResources();
            this.printResources("Merged");
            this.persistentList.save();
        }
    }

    private void mergeNewResources() {
        if (this.newResources.size() > 0) {
            this.logger.debug("Added set of {} new resources: {}", new Object[]{this.newResources.size(), this.newResources});
            for (InternalResource r : this.newResources) {
                this.persistentList.addOrUpdate(r);
            }
            this.newResources.clear();
        }
        if (!this.urlsToRemove.isEmpty()) {
            this.logger.debug("Removing set of {} resources: {}", new Object[]{this.urlsToRemove.size(), this.urlsToRemove});
            for (String url : this.urlsToRemove) {
                this.persistentList.remove(url);
            }
            this.urlsToRemove.clear();
        }
    }

    private void printResources(String hint) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        int counter = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(hint);
        sb.append(" Resources={\n");
        for (String id : this.persistentList.getEntityIds()) {
            sb.append("- ").append(hint).append(" RegisteredResource ");
            sb.append(id);
            sb.append("\n    RegisteredResource.info=[");
            String sep = "";
            for (RegisteredResource registeredResource : this.persistentList.getEntityResourceList(id).listResources()) {
                sb.append(sep);
                sep = ", ";
                sb.append(registeredResource);
                ++counter;
            }
            sb.append("]\n");
        }
        sb.append("} (").append(hint).append("): ").append(counter).append(" RegisteredResources\n");
        this.logger.debug(sb.toString());
    }

    private SortedSet<InstallTask> computeTasks() {
        TreeSet<InstallTask> tasks = new TreeSet<InstallTask>();
        List<InstallTaskFactory> services = this.factoryTracker.getSortedServices();
        if (services.size() > 0) {
            for (String entityId : this.persistentList.getEntityIds()) {
                InstallTask task;
                EntityResourceList group = this.persistentList.getEntityResourceList(entityId);
                TaskResource toActivate = group.getActiveResource();
                if (toActivate == null || (task = this.getTask(services, group)) == null) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }

    private InstallTask getTask(List<InstallTaskFactory> services, TaskResourceGroup rrg) {
        InstallTask result = null;
        for (InstallTaskFactory factory : services) {
            if (factory == null) continue;
            try {
                result = factory.createTask(rrg);
            }
            catch (Exception fatal) {
                String message = MessageFormat.format("An exception occured while creating a task for {0}. Resource will be ignored: {1}", rrg.getActiveResource(), fatal.getMessage());
                this.logger.error(message, (Throwable)fatal);
                result = new ChangeStateTask(rrg, ResourceState.IGNORED, message);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ACTION executeTasks(SortedSet<InstallTask> tasks) {
        if (this.switchStartLevel && this.hasBundleUpdateTask(tasks)) {
            ServiceReference ref = this.ctx.getServiceReference(StartLevel.class.getName());
            StartLevel startLevel = (StartLevel)this.ctx.getService(ref);
            try {
                int targetStartLevel = this.getLowestStartLevel(tasks, startLevel);
                int currentStartLevel = startLevel.getStartLevel();
                if (targetStartLevel < currentStartLevel) {
                    ACTION aCTION;
                    this.auditLogger.info("Switching to start level {}", (Object)targetStartLevel);
                    try {
                        startLevel.setStartLevel(targetStartLevel);
                        while (startLevel.getStartLevel() > targetStartLevel) {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        aCTION = this.doExecuteTasks(tasks);
                    }
                    catch (Throwable throwable) {
                        startLevel.setStartLevel(currentStartLevel);
                        this.auditLogger.info("Switching back to start level {} after performing the required installation tasks", (Object)currentStartLevel);
                        throw throwable;
                    }
                    startLevel.setStartLevel(currentStartLevel);
                    this.auditLogger.info("Switching back to start level {} after performing the required installation tasks", (Object)currentStartLevel);
                    return aCTION;
                }
            }
            finally {
                this.ctx.ungetService(ref);
            }
        }
        return this.doExecuteTasks(tasks);
    }

    private int getLowestStartLevel(SortedSet<InstallTask> tasks, StartLevel startLevel) {
        int currentStartLevel;
        int startLevelToTarget = currentStartLevel = startLevel.getStartLevel();
        for (InstallTask task : tasks) {
            Bundle b;
            if (!(task instanceof BundleUpdateTask) || (b = ((BundleUpdateTask)task).getBundle()) == null) continue;
            try {
                int bundleStartLevel = startLevel.getBundleStartLevel(b) - 1;
                if (bundleStartLevel >= startLevelToTarget) continue;
                startLevelToTarget = bundleStartLevel;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        int ownStartLevel = startLevel.getBundleStartLevel(this.ctx.getBundle());
        if (ownStartLevel > startLevelToTarget) {
            startLevelToTarget = ownStartLevel;
        }
        return startLevelToTarget;
    }

    private boolean hasBundleUpdateTask(SortedSet<InstallTask> tasks) {
        boolean result = false;
        for (InstallTask task : tasks) {
            if (task.isAsynchronousTask()) {
                result = false;
                break;
            }
            if (!(task instanceof BundleUpdateTask)) continue;
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ACTION doExecuteTasks(final SortedSet<InstallTask> tasks) {
        if (!tasks.isEmpty()) {
            final InstallationContext ctx = new InstallationContext(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void addTaskToNextCycle(InstallTask t) {
                    OsgiInstallerImpl.this.logger.warn("Deprecated method addTaskToNextCycle was called. Task will be executed in this cycle instead: {}", (Object)t);
                    SortedSet sortedSet = tasks;
                    synchronized (sortedSet) {
                        tasks.add(t);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void addTaskToCurrentCycle(InstallTask t) {
                    OsgiInstallerImpl.this.logger.debug("Adding {}task to current cycle: {}", (Object)(t.isAsynchronousTask() ? "async " : ""), (Object)t);
                    SortedSet sortedSet = tasks;
                    synchronized (sortedSet) {
                        tasks.add(t);
                    }
                }

                @Override
                public void addAsyncTask(InstallTask t) {
                    if (t.isAsynchronousTask()) {
                        OsgiInstallerImpl.this.logger.warn("Deprecated method addAsyncTask was called: {}", (Object)t);
                        this.addTaskToCurrentCycle(t);
                    } else {
                        OsgiInstallerImpl.this.logger.warn("Deprecated method addAsyncTask is called with non async task(!): {}", (Object)t);
                        this.addTaskToCurrentCycle(new AsyncWrapperInstallTask(t));
                    }
                }

                @Override
                public void log(String message, Object ... args) {
                    OsgiInstallerImpl.this.auditLogger.info(message, args);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void asyncTaskFailed(InstallTask t) {
                    OsgiInstallerImpl.this.logger.debug("asyncTaskFailed: {}", (Object)t);
                    if (t.getResource() != null) {
                        t.getResource().setAttribute("org.apache.sling.installer.api.tasks.ASyncInstallTask", null);
                    }
                    OsgiInstallerImpl.this.persistentList.save();
                    Object object = OsgiInstallerImpl.this.resourcesLock;
                    synchronized (object) {
                        if (!OsgiInstallerImpl.this.active) {
                            OsgiInstallerImpl.this.logger.debug("Restarting background thread from asyncTaskFailed");
                            OsgiInstallerImpl.this.active = true;
                            OsgiInstallerImpl.this.startBackgroundThread();
                        } else {
                            OsgiInstallerImpl.this.logger.debug("active={}, no need to restart background thread", (Object)OsgiInstallerImpl.this.active);
                        }
                    }
                }
            };
            while (this.active && !tasks.isEmpty()) {
                InstallTask task = null;
                SortedSet<InstallTask> sortedSet = tasks;
                synchronized (sortedSet) {
                    task = tasks.first();
                    tasks.remove(task);
                }
                if (task.isAsynchronousTask()) {
                    Integer oldValue;
                    this.logger.debug("Executing async task: {}", (Object)task);
                    if (task.getResource() != null) {
                        oldValue = (Integer)task.getResource().getAttribute("org.apache.sling.installer.api.tasks.ASyncInstallTask");
                        Integer newValue = oldValue == null ? Integer.valueOf(1) : Integer.valueOf(oldValue + 1);
                        task.getResource().setAttribute("org.apache.sling.installer.api.tasks.ASyncInstallTask", newValue);
                    } else {
                        oldValue = null;
                    }
                    this.cleanupInstallableResources();
                    final InstallTask aSyncTask = task;
                    String threadName = "BackgroundTaskThread" + this.backgroundTaskCounter.incrementAndGet();
                    Thread t = new Thread(threadName){

                        @Override
                        public void run() {
                            OsgiInstallerImpl.this.logger.debug("Starting background thread {} to execute {}", (Object)Thread.currentThread().getName(), (Object)aSyncTask);
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (aSyncTask.getResource() != null) {
                                aSyncTask.getResource().setAttribute("org.apache.sling.installer.api.tasks.ASyncInstallTask", oldValue);
                            }
                            aSyncTask.execute(ctx);
                            OsgiInstallerImpl.this.logger.debug("Background thread {} ends", (Object)Thread.currentThread().getName());
                        }
                    };
                    t.start();
                    return ACTION.SHUTDOWN;
                }
                try {
                    this.logger.debug("Executing task: {}", (Object)task);
                    task.execute(ctx);
                }
                catch (Throwable t) {
                    this.logger.error("Uncaught exception during task execution!", t);
                }
            }
            boolean newCycle = this.cleanupInstallableResources();
            if (newCycle) {
                return ACTION.CYCLE;
            }
        }
        return ACTION.SLEEP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanupInstallableResources() {
        Object object = this.resourcesLock;
        synchronized (object) {
            boolean result = this.persistentList.compact();
            this.persistentList.save();
            this.printResources("Compacted");
            this.logger.debug("cleanupInstallableResources returns {}", (Object)result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformResources() {
        boolean changed = false;
        List<ServiceReference<ResourceTransformer>> serviceRefs = this.transformerTracker.getSortedServiceReferences();
        if (serviceRefs.size() > 0) {
            Object object = this.resourcesLock;
            synchronized (object) {
                List<RegisteredResource> unknownList = this.persistentList.getUntransformedResources();
                block5: for (int index = 0; index < unknownList.size(); ++index) {
                    RegisteredResource resource = unknownList.get(index);
                    for (ServiceReference<ResourceTransformer> reference : serviceRefs) {
                        ResourceTransformer transformer;
                        Long id = (Long)reference.getProperty("service.id");
                        String transformers = (String)((RegisteredResourceImpl)resource).getAttribute(ResourceTransformer.class.getName());
                        if (id == null || transformers != null && transformers.contains(":" + id + ':') || (transformer = (ResourceTransformer)this.transformerTracker.getService(reference)) == null) continue;
                        try {
                            Object[] result = transformer.transform(resource);
                            String newTransformers = transformers == null ? ":" + id + ':' : transformers + id + ':';
                            ((RegisteredResourceImpl)resource).setAttribute(ResourceTransformer.class.getName(), newTransformers);
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Invoked transformer {} on {} : {}", new Object[]{transformer, resource, Arrays.toString(result)});
                            }
                            if (result == null || result.length <= 0) continue;
                            this.persistentList.transform(resource, (TransformationResult[])result);
                            changed = true;
                            --index;
                            continue block5;
                        }
                        catch (Throwable t) {
                            this.logger.error("Uncaught exception during resource transformation!", t);
                        }
                    }
                }
            }
            if (changed) {
                this.persistentList.save();
                this.printResources("Transformed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSatisfied() {
        Object object = this.resourcesLock;
        synchronized (object) {
            if (!this.satisfied) {
                this.satisfied = true;
                if (this.ctx.getProperty(PROP_REQUIRED_SERVICES) != null) {
                    String[] reqs = this.ctx.getProperty(PROP_REQUIRED_SERVICES).split(",");
                    this.satisfied = true;
                    for (String val : reqs) {
                        String name;
                        if (val.startsWith("resourcetransformer:")) {
                            name = val.substring(20);
                            this.satisfied = this.transformerTracker.check("resourcetransformer.name", name);
                            continue;
                        }
                        if (val.startsWith("installtaskfactory:")) {
                            name = val.substring(19);
                            this.satisfied = this.factoryTracker.check("installtaskfactory.name", name);
                            continue;
                        }
                        this.logger.warn("Invalid requirements for installer: {}", (Object)val);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleRetry() {
        this.logger.debug("scheduleRetry called");
        this.listener.start();
        Object object = this.resourcesLock;
        synchronized (object) {
            this.retryDuringTaskExecution = true;
            this.checkSatisfied();
        }
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceAddedOrUpdated(String resourceType, String entityId, InputStream is, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        try {
            UpdateInfo ui = new UpdateInfo();
            ui.data = ResourceData.create(is, dict);
            ui.resourceType = resourceType;
            ui.dict = dict;
            ui.entityId = entityId;
            ui.attributes = attributes;
            Object object = this.resourcesLock;
            synchronized (object) {
                this.updateInfos.add(ui);
                this.wakeUp();
            }
        }
        catch (IOException ioe) {
            this.logger.error("Unable to handle resource add or update of " + resourceType + ':' + entityId, (Throwable)ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resourceRemoved(String resourceType, String resourceId) {
        UpdateInfo ui = new UpdateInfo();
        ui.resourceType = resourceType;
        ui.entityId = resourceId;
        Object object = this.resourcesLock;
        synchronized (object) {
            this.updateInfos.add(ui);
            this.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdateInfos() {
        ArrayList<UpdateInfo> infos = new ArrayList<UpdateInfo>();
        Iterator iterator = this.resourcesLock;
        synchronized (iterator) {
            infos.addAll(this.updateInfos);
            this.updateInfos.clear();
        }
        for (UpdateInfo info : infos) {
            if (info.data != null) {
                this.internalResourceAddedOrUpdated(info.resourceType, info.entityId, info.data, info.dict, info.attributes);
                continue;
            }
            this.internalResourceRemoved(info.resourceType, info.entityId);
        }
    }

    private boolean handleExternalUpdateWithoutWriteBack(EntityResourceList erl) {
        TaskResource tr = erl.getFirstResource();
        if (tr.getState() == ResourceState.UNINSTALLED || tr.getState() == ResourceState.IGNORED) {
            return false;
        }
        if (tr.getState() == ResourceState.UNINSTALL) {
            erl.setFinishState(ResourceState.UNINSTALLED, null);
            return true;
        }
        erl.setForceFinishState(ResourceState.IGNORED, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalResourceAddedOrUpdated(String resourceType, String entityId, ResourceData data, Dictionary<String, Object> dict, Map<String, Object> attributes) {
        String key = resourceType + ':' + entityId;
        boolean persistChange = attributes != null ? (Boolean)((Converting)Converters.standardConverter().convert(attributes.get("org.apache.sling.installer.api.persist")).defaultValue((Object)Boolean.TRUE)).to(Boolean.class) : true;
        try {
            boolean compactAndSave = false;
            boolean done = false;
            Object object = this.resourcesLock;
            synchronized (object) {
                EntityResourceList newGroup;
                EntityResourceList erl = this.persistentList.getEntityResourceList(key);
                this.logger.debug("Added or updated {} : {}", (Object)key, (Object)erl);
                if (erl != null && erl.getFirstResource() != null) {
                    UpdateHandler handler;
                    TaskResource tr = erl.getFirstResource();
                    if (dict != null) {
                        String digest = FileDataStore.computeDigest(dict);
                        if (tr.getDigest().equals(digest)) {
                            if (tr.getState() == ResourceState.INSTALLED) {
                                this.logger.debug("Resource did not change {}", (Object)key);
                            } else if (tr.getState() == ResourceState.INSTALL || tr.getState() == ResourceState.IGNORED) {
                                erl.setForceFinishState(ResourceState.INSTALLED, null);
                                compactAndSave = true;
                            }
                            done = true;
                        }
                    }
                    if (!done && persistChange) {
                        handler = this.findHandler(tr.getScheme());
                        if (handler == null) {
                            this.logger.debug("No handler found to handle update of resource with scheme {}", (Object)tr.getScheme());
                        }
                    } else {
                        handler = null;
                    }
                    if (!done && handler == null) {
                        compactAndSave = this.handleExternalUpdateWithoutWriteBack(erl);
                        done = true;
                    }
                    if (!done) {
                        InputStream localIS = data.getInputStream();
                        try {
                            UpdateResult result;
                            UpdateResult updateResult = result = localIS == null ? handler.handleUpdate(resourceType, entityId, tr.getURL(), data.getDictionary(), attributes) : handler.handleUpdate(resourceType, entityId, tr.getURL(), localIS, attributes);
                            if (result != null) {
                                if (!result.getURL().equals(tr.getURL()) && !result.getResourceIsMoved()) {
                                    InternalResource internalResource = new InternalResource(result.getScheme(), result.getResourceId(), null, data.getDictionary(), data.getDictionary() != null ? "properties" : "file", data.getDigest(result.getURL(), result.getDigest()), result.getPriority(), data.getDataFile(), null);
                                    RegisteredResource rr = this.persistentList.addOrUpdate(internalResource);
                                    TransformationResult transRes = new TransformationResult();
                                    int pos = erl.getResourceId().indexOf(58);
                                    transRes.setId(erl.getResourceId().substring(pos + 1));
                                    transRes.setResourceType(resourceType);
                                    if (attributes != null) {
                                        transRes.setAttributes(attributes);
                                    }
                                    this.persistentList.transform(rr, new TransformationResult[]{transRes});
                                    newGroup = this.persistentList.getEntityResourceList(key);
                                    newGroup.setFinishState(ResourceState.INSTALLED, null);
                                    newGroup.compact();
                                } else {
                                    ((RegisteredResourceImpl)tr).update(data.getDataFile(), data.getDictionary(), data.getDigest(result.getURL(), result.getDigest()), result.getPriority(), result.getURL());
                                    erl.setForceFinishState(ResourceState.INSTALLED, null);
                                }
                                compactAndSave = true;
                            } else {
                                compactAndSave = this.handleExternalUpdateWithoutWriteBack(erl);
                            }
                        }
                        finally {
                            if (localIS != null) {
                                try {
                                    localIS.close();
                                }
                                catch (IOException result) {}
                            }
                        }
                        done = true;
                    }
                }
                if (!done && persistChange) {
                    List handlerList = this.updateHandlerTracker.getSortedServices();
                    for (UpdateHandler handler : handlerList) {
                        InputStream localIS = data.getInputStream();
                        try {
                            UpdateResult result = localIS == null ? handler.handleUpdate(resourceType, entityId, null, data.getDictionary(), attributes) : handler.handleUpdate(resourceType, entityId, null, localIS, attributes);
                            if (result == null) continue;
                            InternalResource internalResource = new InternalResource(result.getScheme(), result.getResourceId(), null, data.getDictionary(), data.getDictionary() != null ? "properties" : "file", data.getDigest(result.getURL(), result.getDigest()), result.getPriority(), data.getDataFile(), null);
                            RegisteredResource rr = this.persistentList.addOrUpdate(internalResource);
                            TransformationResult transRes = new TransformationResult();
                            transRes.setId(entityId);
                            transRes.setResourceType(resourceType);
                            if (attributes != null) {
                                transRes.setAttributes(attributes);
                            }
                            this.persistentList.transform(rr, new TransformationResult[]{transRes});
                            newGroup = this.persistentList.getEntityResourceList(key);
                            newGroup.setFinishState(ResourceState.INSTALLED);
                            newGroup.compact();
                            compactAndSave = true;
                            done = true;
                            break;
                        }
                        finally {
                            if (localIS == null) continue;
                            try {
                                localIS.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (!done) {
                        this.logger.debug("No handler found to handle creation of resource {}", (Object)key);
                    }
                }
                if (compactAndSave) {
                    if (erl != null) {
                        erl.compact();
                    }
                    this.persistentList.save();
                }
            }
        }
        catch (IOException ioe) {
            this.logger.error("Unable to handle resource add or update of " + key, (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalResourceRemoved(String resourceType, String entityId) {
        String key = resourceType + ':' + entityId;
        Object object = this.resourcesLock;
        synchronized (object) {
            EntityResourceList erl = this.persistentList.getEntityResourceList(key);
            this.logger.debug("Removed {} : {}", (Object)key, (Object)erl);
            if (erl != null) {
                String resourceId = erl.getResourceId();
                key = resourceType + ':' + resourceId;
                TaskResource tr = erl.getFirstResource();
                if (tr != null) {
                    if (tr.getState() == ResourceState.IGNORED) {
                        if (tr.getDictionary() == null || tr.getDictionary().get("org.apache.sling.installer.api.template") == null) {
                            ((RegisteredResourceImpl)tr).setState(ResourceState.INSTALL, null);
                            this.persistentList.save();
                        }
                    } else if (tr.getState() != ResourceState.UNINSTALLED) {
                        UpdateHandler handler = this.findHandler(tr.getScheme());
                        if (handler == null) {
                            String message = MessageFormat.format("No handler found to handle resource with scheme {0}", tr.getScheme());
                            this.logger.debug(message);
                            ((RegisteredResourceImpl)tr).setState(ResourceState.IGNORED, message);
                        } else if (handler.handleRemoval(resourceType, resourceId, tr.getURL()) != null) {
                            erl.setForceFinishState(ResourceState.UNINSTALLED, null);
                            erl.compact();
                        } else {
                            String message = MessageFormat.format("No handler found to handle removal of resource with scheme {0}", tr.getScheme());
                            this.logger.debug(message);
                            ((RegisteredResourceImpl)tr).setState(ResourceState.IGNORED, message);
                        }
                        this.persistentList.save();
                    }
                }
            }
        }
    }

    private UpdateHandler findHandler(String scheme) {
        List references = this.updateHandlerTracker.getSortedServiceReferences();
        for (ServiceReference ref : references) {
            String[] supportedSchemes;
            for (String support : supportedSchemes = (String[])Converters.standardConverter().convert(ref.getProperty("handler.schemes")).to(String[].class)) {
                if (!scheme.equals(support)) continue;
                return (UpdateHandler)this.updateHandlerTracker.getService(ref);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallationState getInstallationState() {
        Object object = this.resourcesLock;
        synchronized (object) {
            InstallationState state = new InstallationState(){
                private final List<ResourceGroup> activeResources = new ArrayList<ResourceGroup>();
                private final List<ResourceGroup> installedResources = new ArrayList<ResourceGroup>();
                private final List<RegisteredResource> untransformedResources = new ArrayList<RegisteredResource>();

                @Override
                public List<ResourceGroup> getActiveResources() {
                    return this.activeResources;
                }

                @Override
                public List<ResourceGroup> getInstalledResources() {
                    return this.installedResources;
                }

                @Override
                public List<RegisteredResource> getUntransformedResources() {
                    return this.untransformedResources;
                }

                public String toString() {
                    return "InstallationState[active resources: " + this.activeResources + ", installed resources: " + this.installedResources + ", untransformed resources: " + this.untransformedResources + "]";
                }
            };
            for (String entityId : this.persistentList.getEntityIds()) {
                if (this.persistentList.isSpecialEntityId(entityId)) continue;
                EntityResourceList group = this.persistentList.getEntityResourceList(entityId);
                final String alias = group.getAlias();
                final ArrayList<4> resources = new ArrayList<4>();
                boolean first = true;
                boolean isActive = false;
                for (final TaskResource taskResource : group.getResources()) {
                    final ResourceState resourceState = taskResource.getState();
                    if (first) {
                        if (resourceState == ResourceState.INSTALL || resourceState == ResourceState.UNINSTALL) {
                            isActive = true;
                        }
                        first = false;
                    }
                    resources.add(new Resource(){

                        @Override
                        public String getScheme() {
                            return taskResource.getScheme();
                        }

                        @Override
                        public String getURL() {
                            return taskResource.getURL();
                        }

                        @Override
                        public String getType() {
                            return taskResource.getType();
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return taskResource.getInputStream();
                        }

                        @Override
                        public Dictionary<String, Object> getDictionary() {
                            return taskResource.getDictionary();
                        }

                        @Override
                        public String getDigest() {
                            return taskResource.getDigest();
                        }

                        @Override
                        public int getPriority() {
                            return taskResource.getPriority();
                        }

                        @Override
                        public String getEntityId() {
                            return taskResource.getEntityId();
                        }

                        @Override
                        public ResourceState getState() {
                            return resourceState;
                        }

                        @Override
                        public Version getVersion() {
                            return taskResource.getVersion();
                        }

                        @Override
                        public long getLastChange() {
                            return ((RegisteredResourceImpl)taskResource).getLastChange();
                        }

                        @Override
                        public Object getAttribute(String key) {
                            return taskResource.getAttribute(key);
                        }

                        @Override
                        @Nullable
                        public String getError() {
                            return taskResource.getError();
                        }

                        public String toString() {
                            return "resource[entityId=" + this.getEntityId() + ", scheme=" + this.getScheme() + ", url=" + this.getURL() + ", type=" + this.getType() + ", error=" + this.getError() + ", state=" + (Object)((Object)this.getState()) + ", version=" + this.getVersion() + ", lastChange=" + this.getLastChange() + ", priority=" + this.getPriority() + ", digest=" + this.getDigest() + "]";
                        }
                    });
                }
                ResourceGroup rg = new ResourceGroup(){

                    @Override
                    public List<Resource> getResources() {
                        return resources;
                    }

                    @Override
                    public String getAlias() {
                        return alias;
                    }

                    public String toString() {
                        return "group[" + resources + "]";
                    }
                };
                if (isActive) {
                    state.getActiveResources().add(rg);
                    continue;
                }
                state.getInstalledResources().add(rg);
            }
            Collections.sort(state.getActiveResources(), COMPARATOR);
            Collections.sort(state.getInstalledResources(), COMPARATOR);
            state.getUntransformedResources().addAll(this.persistentList.getUntransformedResources());
            return state;
        }
    }

    private void handleResourceUpdaters() {
        List<ResourceUpdater> updaters = this.updaterTracker.getSortedServices();
        for (ResourceUpdater up : updaters) {
            this.logger.info("Invoking installer resource updater {}", (Object)up.getClass().getName());
            ArrayList<UpdatableResourceGroup> groups = new ArrayList<UpdatableResourceGroup>();
            for (final String groupId : this.persistentList.getEntityIds()) {
                final EntityResourceList list = this.persistentList.getEntityResourceList(groupId);
                final String resourceType = list.getFirstResource().getType();
                final String rsrcId = groupId.substring(resourceType.length() + 1);
                UpdatableResourceGroup grp = new UpdatableResourceGroup(){
                    private String id;
                    private String alias;
                    {
                        this.id = rsrcId;
                        this.alias = list.getAlias();
                    }

                    @Override
                    public void setId(String id) {
                        if (id == null) {
                            throw new IllegalArgumentException();
                        }
                        this.id = id;
                    }

                    @Override
                    public void setAlias(String value) {
                        this.alias = value;
                    }

                    @Override
                    public String getResourceType() {
                        return resourceType;
                    }

                    @Override
                    public String getId() {
                        return this.id;
                    }

                    @Override
                    public String getAlias() {
                        return this.alias;
                    }

                    @Override
                    public void update() {
                        if (!rsrcId.equals(this.id) || list.getAlias() == null && this.alias != null || list.getAlias() != null && !list.getAlias().equals(this.alias)) {
                            String newGroupId = resourceType + ':' + this.id;
                            OsgiInstallerImpl.this.auditLogger.info("Updating resource group from {} to {}", (Object)groupId, (Object)newGroupId);
                            OsgiInstallerImpl.this.persistentList.update(groupId, this.alias, newGroupId);
                            OsgiInstallerImpl.this.persistentList.save();
                        }
                    }
                };
                groups.add(grp);
            }
            up.update(groups);
        }
    }

    public static boolean isMultiVersionSupportEnabled(BundleContext bundleContext) {
        return (Boolean)((Converting)Converters.standardConverter().convert((Object)bundleContext.getProperty(PROP_EXPERIMENTAL_MULTI_VERSION_SUPPORT)).defaultValue((Object)false)).to(Boolean.class);
    }

    private static final class UpdateInfo {
        public ResourceData data;
        public Dictionary<String, Object> dict;
        public String resourceType;
        public String entityId;
        public Map<String, Object> attributes;

        private UpdateInfo() {
        }
    }

    private static enum ACTION {
        SLEEP,
        SHUTDOWN,
        CYCLE;

    }
}

