/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.impl.servlet;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.junit.Renderer;
import org.apache.sling.junit.RendererFactory;
import org.apache.sling.junit.TestSelector;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class JUnitResultRenderer
extends RunListener
implements Renderer,
RendererFactory {
    public static final String EXTENSION = "junit_result";
    private ObjectOutputStream outputStream;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public Renderer createRenderer() {
        return new JUnitResultRenderer();
    }

    @Override
    public boolean appliesTo(TestSelector s) {
        return EXTENSION.equals(s.getExtension());
    }

    @Override
    public String getExtension() {
        return EXTENSION;
    }

    @Override
    public void setup(HttpServletResponse response, String pageTitle) throws IOException, UnsupportedEncodingException {
        response.setContentType("application/x-java-serialized-object");
        this.outputStream = new ObjectOutputStream((OutputStream)response.getOutputStream());
    }

    @Override
    public void cleanup() {
        try {
            this.outputStream.flush();
            this.outputStream.close();
        }
        catch (IOException e) {
            this.log.warn("Exception in cleanup()", (Throwable)e);
        }
        this.outputStream = null;
    }

    @Override
    public RunListener getRunListener() {
        return this;
    }

    @Override
    public void info(String role, String info) {
    }

    @Override
    public void link(String info, String url, String method) {
    }

    @Override
    public void list(String role, Collection<String> data) {
    }

    @Override
    public void title(int level, String title) {
    }

    @Override
    public void testRunFinished(Result result) throws IOException {
        this.outputStream.writeObject(result);
    }
}

