/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.defaults;

import java.io.IOException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 3806788918045433043L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Resource resource = request.getResource();
        if (resource instanceof NonExistingResource) {
            String msg = String.format("Resource not found at path %s", resource.getPath());
            LOG.error(msg);
            response.sendError(404, msg);
        } else {
            String msg = String.format("Cannot find servlet to handle resource %s", resource.getPath());
            LOG.error(msg);
            response.sendError(500, msg);
        }
    }
}

