/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.internal.concurrent;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;

public final class ForkJoinUtils {
    public static ForkJoinTask<Void> submitInCustomPool(String poolName, int parallelism, Runnable task) {
        return ForkJoinUtils.submitInCustomPool(poolName, parallelism, ForkJoinTask.adapt(task));
    }

    public static void executeInCustomPool(String poolName, int parallelism, Runnable task) {
        ForkJoinUtils.submitInCustomPool(poolName, parallelism, task).join();
    }

    public static <T> ForkJoinTask<T> submitInCustomPool(String poolName, int parallelism, Callable<T> task) {
        return ForkJoinUtils.submitInCustomPool(poolName, parallelism, ForkJoinTask.adapt(task));
    }

    public static <T> T invokeInCustomPool(String poolName, int parallelism, Callable<T> task) {
        return ForkJoinUtils.submitInCustomPool(poolName, parallelism, task).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> ForkJoinTask<T> submitInCustomPool(final String poolName, int parallelism, ForkJoinTask<T> task) {
        if (parallelism <= 0) {
            throw new IllegalArgumentException("Parallelism must be greater than 0");
        }
        ForkJoinPool workerPool = ForkJoinUtils.getWorkerPool(Thread.currentThread());
        ForkJoinPool poolToShutdown = null;
        if (workerPool == null || workerPool == ForkJoinPool.commonPool()) {
            poolToShutdown = workerPool = new ForkJoinPool(parallelism, p -> new ForkJoinWorkerThread(p){

                @Override
                protected void onStart() {
                    super.onStart();
                    this.setName(poolName + "-" + this.getPoolIndex());
                }
            }, null, false);
        }
        try {
            ForkJoinTask<T> forkJoinTask = workerPool.submit(task);
            return forkJoinTask;
        }
        finally {
            Optional.ofNullable(poolToShutdown).ifPresent(ForkJoinPool::shutdown);
        }
    }

    static ForkJoinPool getWorkerPool(Thread thread) {
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread workerThread = (ForkJoinWorkerThread)thread;
            return workerThread.getPool();
        }
        return null;
    }

    private ForkJoinUtils() {
    }
}

