/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.tree.impl.AbstractTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractMutableTree
extends AbstractTree {
    @Override
    public boolean remove() {
        String name = this.getName();
        AbstractTree parent = this.getParentOrNull();
        if (parent != null && parent.hasChild(name)) {
            this.getNodeBuilder().remove();
            NodeBuilder parentBuilder = parent.getNodeBuilder();
            PropertyState order = parentBuilder.getProperty(":childOrder");
            if (order != null) {
                ArrayList<String> names = new ArrayList<String>(order.count());
                for (String n : order.getValue(Type.NAMES)) {
                    if (n.equals(name)) continue;
                    names.add(n);
                }
                parentBuilder.setProperty(":childOrder", names, Type.NAMES);
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Tree addChild(@NotNull String name) throws IllegalArgumentException {
        Validate.checkArgument(!this.isHidden(name));
        if (!this.hasChild(name)) {
            NodeBuilder nodeBuilder = this.getNodeBuilder();
            nodeBuilder.setChildNode(name);
            PropertyState order = nodeBuilder.getProperty(":childOrder");
            if (order != null) {
                ArrayList<String> names = new ArrayList<String>(order.count() + 1);
                for (String n : order.getValue(Type.NAMES)) {
                    if (n.equals(name)) continue;
                    names.add(n);
                }
                names.add(name);
                nodeBuilder.setProperty(":childOrder", names, Type.NAMES);
            }
        }
        return this.createChild(name);
    }

    @Override
    public void setOrderableChildren(boolean enable) {
        if (enable) {
            this.updateChildOrder(true);
        } else {
            this.getNodeBuilder().removeProperty(":childOrder");
        }
    }

    protected void updateChildOrder(boolean force) {
        if (force || this.hasOrderableChildren()) {
            this.getNodeBuilder().setProperty(PropertyStates.createProperty(":childOrder", this.getChildNames(), Type.NAMES));
        }
    }

    @Override
    public boolean orderBefore(@Nullable String name) {
        String thisName = this.getName();
        AbstractTree parent = this.getParentOrNull();
        if (parent == null) {
            return false;
        }
        if (thisName.equals(name)) {
            return false;
        }
        ArrayList<String> names = new ArrayList<String>(10000);
        NodeBuilder builder = parent.getNodeBuilder();
        boolean found = false;
        for (String n : builder.getNames(":childOrder")) {
            if (n.equals(name) && parent.hasChild(name)) {
                names.add(thisName);
                found = true;
            }
            if (n.equals(thisName)) continue;
            names.add(n);
        }
        if (!found) {
            names.clear();
            for (String n : parent.getChildNames()) {
                if (n.equals(name)) {
                    names.add(thisName);
                    found = true;
                }
                if (n.equals(thisName)) continue;
                names.add(n);
            }
        }
        if (name == null) {
            names.add(thisName);
            found = true;
        }
        if (found) {
            builder.setProperty(":childOrder", names, Type.NAMES);
            return true;
        }
        return false;
    }

    @Override
    public void setProperty(@NotNull PropertyState property) {
        Validate.checkArgument(!this.isHidden(Objects.requireNonNull(property).getName()));
        this.getNodeBuilder().setProperty(property);
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value) throws IllegalArgumentException {
        Validate.checkArgument(!this.isHidden(Objects.requireNonNull(name)));
        this.getNodeBuilder().setProperty(name, Objects.requireNonNull(value));
    }

    @Override
    public <T> void setProperty(@NotNull String name, @NotNull T value, @NotNull Type<T> type) throws IllegalArgumentException {
        Validate.checkArgument(!this.isHidden(Objects.requireNonNull(name)));
        this.getNodeBuilder().setProperty(name, Objects.requireNonNull(value), Objects.requireNonNull(type));
    }

    @Override
    public void removeProperty(@NotNull String name) {
        this.getNodeBuilder().removeProperty(Objects.requireNonNull(name));
    }
}

