/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.CompositeWorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.apache.jackrabbit.oak.stats.Monitor;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class CompositeConfiguration<T extends SecurityConfiguration>
implements SecurityConfiguration {
    public static final String PARAM_RANKING = "configurationRanking";
    private static final int NO_RANKING = Integer.MIN_VALUE;
    private final List<T> configurations = new CopyOnWriteArrayList<T>();
    private final Ranking rankings = new Ranking();
    private final String name;
    private final CompositeContext ctx = new CompositeContext();
    private SecurityProvider securityProvider;
    private RootProvider rootProvider;
    private TreeProvider treeProvider;
    private T defaultConfig;

    public CompositeConfiguration(@NotNull String name) {
        this.name = name;
    }

    public CompositeConfiguration(@NotNull String name, @NotNull SecurityProvider securityProvider) {
        this.name = name;
        this.securityProvider = securityProvider;
    }

    @Nullable
    public T getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(@NotNull T defaultConfig) {
        this.defaultConfig = defaultConfig;
        this.ctx.defaultCtx = defaultConfig.getContext();
    }

    public void addConfiguration(@NotNull T configuration) {
        this.addConfiguration(configuration, ConfigurationParameters.EMPTY);
    }

    public void addConfiguration(@NotNull T configuration, @NotNull ConfigurationParameters params) {
        int ranking = configuration.getParameters().getConfigValue(PARAM_RANKING, Integer.MIN_VALUE);
        if (ranking == Integer.MIN_VALUE) {
            ranking = params.getConfigValue("service.ranking", Integer.MIN_VALUE);
        }
        if (ranking == Integer.MIN_VALUE || this.configurations.isEmpty()) {
            this.configurations.add(configuration);
        } else {
            SecurityConfiguration c;
            int r;
            int i = 0;
            Iterator<T> iterator = this.configurations.iterator();
            while (iterator.hasNext() && ranking <= (r = this.rankings.get(c = (SecurityConfiguration)iterator.next()))) {
                ++i;
            }
            this.configurations.add(i, configuration);
        }
        this.rankings.set((SecurityConfiguration)configuration, ranking);
        this.ctx.add((SecurityConfiguration)configuration);
    }

    public void removeConfiguration(@NotNull T configuration) {
        this.configurations.remove(configuration);
        this.rankings.remove((SecurityConfiguration)configuration);
        this.ctx.refresh(this.configurations);
    }

    @NotNull
    public List<T> getConfigurations() {
        if (this.configurations.isEmpty() && this.defaultConfig != null) {
            return List.of(this.defaultConfig);
        }
        return List.copyOf(this.configurations);
    }

    public void setSecurityProvider(@NotNull SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    @NotNull
    protected SecurityProvider getSecurityProvider() {
        if (this.securityProvider == null) {
            throw new IllegalStateException("SecurityProvider missing => CompositeConfiguration is not ready.");
        }
        return this.securityProvider;
    }

    public void setRootProvider(@NotNull RootProvider rootProvider) {
        this.rootProvider = rootProvider;
    }

    @NotNull
    protected RootProvider getRootProvider() {
        if (this.rootProvider == null) {
            throw new IllegalStateException("RootProvider missing.");
        }
        return this.rootProvider;
    }

    public void setTreeProvider(@NotNull TreeProvider treeProvider) {
        this.treeProvider = treeProvider;
    }

    @NotNull
    protected TreeProvider getTreeProvider() {
        if (this.treeProvider == null) {
            throw new IllegalStateException("TreeProvider missing.");
        }
        return this.treeProvider;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ConfigurationParameters getParameters() {
        List<T> configs = this.getConfigurations();
        ConfigurationParameters[] params = new ConfigurationParameters[configs.size()];
        for (int i = 0; i < configs.size(); ++i) {
            params[i] = ((SecurityConfiguration)configs.get(i)).getParameters();
        }
        return ConfigurationParameters.of(params);
    }

    @Override
    @NotNull
    public WorkspaceInitializer getWorkspaceInitializer() {
        return new CompositeWorkspaceInitializer(this.getConfigurations().stream().map(SecurityConfiguration::getWorkspaceInitializer).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public RepositoryInitializer getRepositoryInitializer() {
        return new CompositeInitializer(this.getConfigurations().stream().map(SecurityConfiguration::getRepositoryInitializer).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public List<? extends CommitHook> getCommitHooks(@NotNull String workspaceName) {
        return Collections.unmodifiableList(this.getConfigurations().stream().map(securityConfiguration -> securityConfiguration.getCommitHooks(workspaceName)).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
        return Collections.unmodifiableList(this.getConfigurations().stream().map(securityConfiguration -> securityConfiguration.getValidators(workspaceName, principals, moveTracker)).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public List<ThreeWayConflictHandler> getConflictHandlers() {
        return this.getConfigurations().stream().map(SecurityConfiguration::getConflictHandlers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters() {
        return Collections.unmodifiableList(this.getConfigurations().stream().map(SecurityConfiguration::getProtectedItemImporters).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public Context getContext() {
        return this.ctx;
    }

    @Override
    @NotNull
    public Iterable<Monitor<?>> getMonitors(@NotNull StatisticsProvider statisticsProvider) {
        return IterableUtils.chainedIterable(IterableUtils.transform(this.getConfigurations(), securityConfiguration -> securityConfiguration.getMonitors(statisticsProvider)));
    }

    private static final class ContextFunction
    implements Function<SecurityConfiguration, Context> {
        private static final ContextFunction INSTANCE = new ContextFunction();

        private ContextFunction() {
        }

        @Override
        public Context apply(SecurityConfiguration input) {
            return input.getContext();
        }
    }

    private static final class CompositeContext
    implements Context {
        @NotNull
        private Context defaultCtx = DEFAULT;
        @Nullable
        private Context[] delegatees = null;

        private CompositeContext() {
        }

        private void refresh(@NotNull List<? extends SecurityConfiguration> configurations) {
            Set s = SetUtils.newLinkedHashSet(configurations.size());
            for (Context c : IterableUtils.transform(configurations, ContextFunction.INSTANCE::apply)) {
                if (DEFAULT == c) continue;
                s.add(c);
            }
            this.delegatees = s.isEmpty() ? null : s.toArray(new Context[0]);
        }

        private void add(@NotNull SecurityConfiguration configuration) {
            Context c = configuration.getContext();
            if (DEFAULT != c) {
                if (this.delegatees == null) {
                    this.delegatees = new Context[]{c};
                } else {
                    for (Context ctx : this.delegatees) {
                        if (!ctx.equals(c)) continue;
                        return;
                    }
                    this.delegatees = (Context[])ArrayUtils.add((Object[])this.delegatees, (Object)c);
                }
            }
        }

        @Override
        public boolean definesProperty(@NotNull Tree parent, @NotNull PropertyState property) {
            if (this.delegatees == null) {
                return this.defaultCtx.definesProperty(parent, property);
            }
            for (Context ctx : this.delegatees) {
                if (!ctx.definesProperty(parent, property)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean definesContextRoot(@NotNull Tree tree) {
            if (this.delegatees == null) {
                return this.defaultCtx.definesContextRoot(tree);
            }
            for (Context ctx : this.delegatees) {
                if (!ctx.definesContextRoot(tree)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean definesTree(@NotNull Tree tree) {
            if (this.delegatees == null) {
                return this.defaultCtx.definesTree(tree);
            }
            for (Context ctx : this.delegatees) {
                if (!ctx.definesTree(tree)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean definesLocation(@NotNull TreeLocation location) {
            if (this.delegatees == null) {
                return this.defaultCtx.definesLocation(location);
            }
            for (Context ctx : this.delegatees) {
                if (!ctx.definesLocation(location)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean definesInternal(@NotNull Tree tree) {
            if (this.delegatees == null) {
                return this.defaultCtx.definesInternal(tree);
            }
            for (Context ctx : this.delegatees) {
                if (!ctx.definesInternal(tree)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class Ranking {
        private Map<SecurityConfiguration, Integer> m = new ConcurrentHashMap<SecurityConfiguration, Integer>();

        private Ranking() {
        }

        private int get(@NotNull SecurityConfiguration configuration) {
            Integer ranking = this.m.get(configuration);
            if (ranking == null) {
                return Integer.MIN_VALUE;
            }
            return ranking;
        }

        private void set(@NotNull SecurityConfiguration configuration, int ranking) {
            if (ranking != Integer.MIN_VALUE) {
                this.m.put(configuration, ranking);
            }
        }

        private void remove(@NotNull SecurityConfiguration configuration) {
            this.m.remove(configuration);
        }
    }
}

