/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.util.AssertUtils;
import org.apache.streampark.common.util.CompletableFutureUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.common.util.ThreadUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.InternalException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationConfig;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.entity.FlinkCluster;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.entity.Savepoint;
import org.apache.streampark.console.core.enums.CheckPointType;
import org.apache.streampark.console.core.enums.Operation;
import org.apache.streampark.console.core.enums.OptionState;
import org.apache.streampark.console.core.mapper.SavepointMapper;
import org.apache.streampark.console.core.service.ApplicationConfigService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkClusterService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.SavepointService;
import org.apache.streampark.console.core.task.FlinkAppHttpWatcher;
import org.apache.streampark.flink.client.FlinkClient;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.util.FlinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class SavepointServiceImpl
extends ServiceImpl<SavepointMapper, Savepoint>
implements SavepointService {
    private static final Logger log = LoggerFactory.getLogger(SavepointServiceImpl.class);
    @Autowired
    private FlinkEnvService flinkEnvService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationConfigService configService;
    @Autowired
    private FlinkClusterService flinkClusterService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private FlinkAppHttpWatcher flinkAppHttpWatcher;
    private static final String SAVEPOINT_DIRECTORY_NEW_KEY = "execution.checkpointing.savepoint-dir";
    private static final String MAX_RETAINED_CHECKPOINTS_NEW_KEY = "execution.checkpointing.num-retained";
    private static final int CPU_NUM = Math.max(2, Runtime.getRuntime().availableProcessors());
    private final ExecutorService flinkTriggerExecutor = new ThreadPoolExecutor(CPU_NUM, CPU_NUM, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.threadFactory((String)"streampark-flink-savepoint-trigger"));
    @Autowired
    private SavepointMapper savepointMapper;

    @Override
    public void expire(Long appId) {
        this.cleanLatest(appId);
    }

    private void clearExpire(Savepoint entity) {
        int cpThreshold;
        block16: {
            FlinkEnv flinkEnv = this.flinkEnvService.getByAppId(entity.getAppId());
            Application application = (Application)this.applicationService.getById(entity.getAppId());
            AssertUtils.notNull((Object)flinkEnv);
            AssertUtils.notNull((Object)application);
            String numRetainedKey = CheckpointingOptions.MAX_RETAINED_CHECKPOINTS.key();
            String numRetainedFromDynamicProp = (String)PropertiesUtils.extractDynamicPropertiesAsJava((String)application.getDynamicProperties()).get(numRetainedKey);
            if (StringUtils.isBlank((CharSequence)numRetainedFromDynamicProp)) {
                numRetainedFromDynamicProp = (String)PropertiesUtils.extractDynamicPropertiesAsJava((String)application.getDynamicProperties()).get(MAX_RETAINED_CHECKPOINTS_NEW_KEY);
            }
            cpThreshold = 0;
            if (numRetainedFromDynamicProp != null) {
                try {
                    int value = Integer.parseInt(numRetainedFromDynamicProp.trim());
                    if (value > 0) {
                        cpThreshold = value;
                    } else {
                        log.warn("this value of dynamicProperties key: state.checkpoints.num-retained or execution.checkpointing.num-retained is invalid, must be gt 0");
                    }
                }
                catch (NumberFormatException e) {
                    log.warn("this value of dynamicProperties key: state.checkpoints.num-retained or execution.checkpointing.num-retained invalid, must be number");
                }
            }
            if (cpThreshold == 0) {
                String flinkConfNumRetained = this.flinkEnvService.getFlinkConfig(flinkEnv, application).getProperty(numRetainedKey);
                int numRetainedDefaultValue = 1;
                if (flinkConfNumRetained != null) {
                    try {
                        int value = Integer.parseInt(flinkConfNumRetained.trim());
                        if (value > 0) {
                            cpThreshold = value;
                            break block16;
                        }
                        cpThreshold = numRetainedDefaultValue;
                        log.warn("the value of key: state.checkpoints.num-retained or execution.checkpointing.num-retained in flink-conf.yaml is invalid, must be gt 0, default value: {} will be use", (Object)numRetainedDefaultValue);
                    }
                    catch (NumberFormatException e) {
                        cpThreshold = numRetainedDefaultValue;
                        log.warn("the value of key: state.checkpoints.num-retained or execution.checkpointing.num-retained in flink-conf.yaml is invalid, must be number, flink env: {}, default value: {} will be use", (Object)flinkEnv.getFlinkHome(), (Object)flinkConfNumRetained);
                    }
                } else {
                    cpThreshold = numRetainedDefaultValue;
                    log.info("the application: {} is not set {} in dynamicProperties or value is invalid, and flink-conf.yaml is the same problem of flink env: {}, default value: {} will be use.", new Object[]{application.getJobName(), numRetainedKey, flinkEnv.getFlinkHome(), numRetainedDefaultValue});
                }
            }
        }
        if (CheckPointType.CHECKPOINT.equals(CheckPointType.of(entity.getType()))) {
            --cpThreshold;
        }
        if (cpThreshold == 0) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Savepoint::getAppId, (Object)entity.getAppId())).eq(Savepoint::getType, (Object)1);
            this.remove((Wrapper)queryWrapper);
        } else {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Savepoint::getTriggerTime}).eq(Savepoint::getAppId, (Object)entity.getAppId())).eq(Savepoint::getType, (Object)CheckPointType.CHECKPOINT.get())).orderByDesc(Savepoint::getTriggerTime);
            Page savepointPage = (Page)((SavepointMapper)this.baseMapper).selectPage((IPage)new Page(1L, (long)(cpThreshold + 1)), (Wrapper)queryWrapper);
            if (!savepointPage.getRecords().isEmpty() && savepointPage.getRecords().size() > cpThreshold) {
                Savepoint savepoint = (Savepoint)savepointPage.getRecords().get(cpThreshold - 1);
                LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Savepoint::getAppId, (Object)entity.getAppId())).eq(Savepoint::getType, (Object)1)).lt(Savepoint::getTriggerTime, (Object)savepoint.getTriggerTime());
                this.remove((Wrapper)lambdaQueryWrapper);
            }
        }
    }

    @Override
    public Savepoint getLatest(Long id) {
        List savepointList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Savepoint::getAppId, (Object)id)).eq(Savepoint::getLatest, (Object)true)).orderByDesc(Savepoint::getCreateTime)).list();
        if (!savepointList.isEmpty()) {
            return (Savepoint)savepointList.get(0);
        }
        return (Savepoint)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Savepoint::getAppId, (Object)id)).orderByDesc(Savepoint::getTriggerTime)).one();
    }

    @Override
    public String getSavePointPath(Application appParam) throws Exception {
        Map<String, String> map;
        ApplicationConfig applicationConfig;
        Application application = (Application)this.applicationService.getById(appParam.getId());
        HashMap properties = PropertiesUtils.extractDynamicPropertiesAsJava((String)application.getDynamicProperties());
        String savepointPath = (String)properties.getOrDefault(CheckpointingOptions.SAVEPOINT_DIRECTORY.key(), properties.get(SAVEPOINT_DIRECTORY_NEW_KEY));
        if (StringUtils.isBlank((CharSequence)savepointPath) && (application.isStreamParkJob() || application.isFlinkSqlJob()) && (applicationConfig = this.configService.getEffective(application.getId())) != null && FlinkUtils.isCheckpointEnabled(map = applicationConfig.readConfig())) {
            savepointPath = map.getOrDefault(CheckpointingOptions.SAVEPOINT_DIRECTORY.key(), map.get(SAVEPOINT_DIRECTORY_NEW_KEY));
        }
        if (StringUtils.isBlank((CharSequence)savepointPath) && ExecutionMode.isRemoteMode((Integer)application.getExecutionMode())) {
            FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
            AssertUtils.notNull((Object)cluster, (String)String.format("The clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
            Map<String, String> config = cluster.getFlinkConfig();
            if (!config.isEmpty()) {
                savepointPath = config.getOrDefault(CheckpointingOptions.SAVEPOINT_DIRECTORY.key(), config.get(SAVEPOINT_DIRECTORY_NEW_KEY));
            }
        }
        if (StringUtils.isBlank((CharSequence)savepointPath)) {
            FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(application.getVersionId());
            Properties flinkConfig = this.flinkEnvService.getFlinkConfig(flinkEnv, application);
            savepointPath = flinkConfig.getProperty(CheckpointingOptions.SAVEPOINT_DIRECTORY.key(), flinkConfig.getProperty(SAVEPOINT_DIRECTORY_NEW_KEY));
        }
        return this.processPath(savepointPath, application.getJobName(), application.getId());
    }

    @Override
    public String processPath(String path, String jobName, Long jobId) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            return path.replaceAll("\\$\\{job(Name|name)}|\\$job(Name|name)", jobName).replaceAll("\\$\\{job(Id|id)}|\\$job(Id|id)", jobId.toString());
        }
        return path;
    }

    @Override
    public void saveSavePoint(Savepoint savepoint) {
        this.clearExpire(savepoint);
        this.cleanLatest(savepoint.getAppId());
        super.save((Object)savepoint);
    }

    private void cleanLatest(Long appId) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(Savepoint::getAppId, (Object)appId)).set(Savepoint::getLatest, (Object)false)).update();
    }

    @Override
    public void trigger(Long appId, @Nullable String savepointPath) throws Exception {
        log.info("Start to trigger savepoint for app {}", (Object)appId);
        Application application = (Application)this.applicationService.getById(appId);
        ApplicationLog applicationLog = new ApplicationLog();
        applicationLog.setOptionName(Operation.SAVEPOINT.getValue());
        applicationLog.setAppId(application.getId());
        applicationLog.setJobManagerUrl(application.getJobManagerUrl());
        applicationLog.setOptionTime(new Date());
        if (ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
            applicationLog.setYarnAppId(application.getClusterId());
        }
        if (!application.isKubernetesModeJob()) {
            FlinkAppHttpWatcher.addSavepoint(application.getId());
            application.setOptionState(OptionState.SAVEPOINTING.getValue());
            application.setOptionTime(new Date());
            this.applicationService.updateById(application);
            this.flinkAppHttpWatcher.initialize();
        }
        FlinkEnv flinkEnv = (FlinkEnv)this.flinkEnvService.getById(application.getVersionId());
        String customSavepoint = this.getFinalSavepointDir(savepointPath, application);
        if (StringUtils.isNotBlank((CharSequence)customSavepoint)) {
            customSavepoint = this.processPath(customSavepoint, application.getJobName(), application.getId());
        }
        FlinkCluster cluster = (FlinkCluster)this.flinkClusterService.getById(application.getFlinkClusterId());
        String clusterId = this.getClusterId(application, cluster);
        Map<String, Object> properties = this.tryGetRestProps(application, cluster);
        TriggerSavepointRequest request = new TriggerSavepointRequest(flinkEnv.getFlinkVersion(), application.getExecutionModeEnum(), properties, clusterId, application.getJobId(), customSavepoint, application.getK8sNamespace());
        CompletableFuture<SavepointResponse> savepointFuture = CompletableFuture.supplyAsync(() -> FlinkClient.triggerSavepoint((TriggerSavepointRequest)request), this.flinkTriggerExecutor);
        this.handleSavepointResponseFuture(application, applicationLog, savepointFuture);
    }

    private void handleSavepointResponseFuture(Application application, ApplicationLog applicationLog, CompletableFuture<SavepointResponse> savepointFuture) {
        CompletableFutureUtils.runTimeout(savepointFuture, (long)10L, (TimeUnit)TimeUnit.MINUTES, savepointResponse -> {
            if (savepointResponse != null && savepointResponse.savepointDir() != null) {
                applicationLog.setSuccess(true);
                String savepointDir = savepointResponse.savepointDir();
                log.info("Request savepoint successful, savepointDir: {}", (Object)savepointDir);
            }
        }, e -> {
            log.error("Trigger savepoint for flink job failed.", e);
            String exception = Utils.stringifyException((Throwable)e);
            applicationLog.setException(exception);
            if (!(e instanceof TimeoutException)) {
                applicationLog.setSuccess(false);
            }
        }).whenComplete((t, e) -> {
            this.applicationLogService.save(applicationLog);
            if (!application.isKubernetesModeJob()) {
                application.setOptionState(OptionState.NONE.getValue());
                application.setOptionTime(new Date());
                this.applicationService.update(application);
                this.flinkAppHttpWatcher.cleanSavepoint(application);
                this.flinkAppHttpWatcher.initialize();
            }
        });
    }

    private String getFinalSavepointDir(@Nullable String savepointPath, Application application) throws Exception {
        String result = savepointPath;
        if (StringUtils.isBlank((CharSequence)savepointPath)) {
            result = this.getSavePointPath(application);
        }
        if (StringUtils.isBlank((CharSequence)result) && ExecutionMode.isYarnMode((Integer)application.getExecutionMode())) {
            result = Workspace.remote().APP_SAVEPOINTS();
        }
        if (!StringUtils.isNotBlank((CharSequence)result)) {
            throw new IllegalArgumentException(String.format("[StreamPark] executionMode: %s, savePoint path is null or invalid.", application.getExecutionModeEnum().getName()));
        }
        this.processPath(result, application.getJobName(), application.getId());
        return result;
    }

    @Nonnull
    private Map<String, Object> tryGetRestProps(Application application, FlinkCluster cluster) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (ExecutionMode.isRemoteMode((ExecutionMode)application.getExecutionModeEnum())) {
            AssertUtils.notNull((Object)cluster, (String)String.format("The clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getFlinkClusterId()));
            URI activeAddress = cluster.getRemoteURI();
            properties.put(RestOptions.ADDRESS.key(), activeAddress.getHost());
            properties.put(RestOptions.PORT.key(), activeAddress.getPort());
        }
        return properties;
    }

    private String getClusterId(Application application, FlinkCluster cluster) {
        switch (application.getExecutionModeEnum()) {
            case YARN_APPLICATION: 
            case YARN_PER_JOB: {
                return application.getClusterId();
            }
            case KUBERNETES_NATIVE_APPLICATION: {
                return application.getJobName();
            }
            case KUBERNETES_NATIVE_SESSION: 
            case YARN_SESSION: {
                AssertUtils.notNull((Object)cluster, (String)String.format("The %s clusterId=%s cannot be find, maybe the clusterId is wrong or the cluster has been deleted. Please contact the Admin.", application.getExecutionModeEnum().getName(), application.getFlinkClusterId()));
                return cluster.getClusterId();
            }
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean delete(Long id, Application application) throws InternalException {
        Savepoint savepoint = (Savepoint)this.getById(id);
        try {
            if (CommonUtils.notEmpty(savepoint.getPath()).booleanValue()) {
                application.getFsOperator().delete(savepoint.getPath());
            }
            this.removeById(id);
            return true;
        }
        catch (Exception e) {
            log.error("Delete application {} failed!", (Object)id, (Object)e);
            throw new InternalException(e.getMessage());
        }
    }

    @Override
    public IPage<Savepoint> page(Savepoint savepoint, RestRequest request) {
        request.setSortField("trigger_time");
        Page page = MybatisPager.getPage(request);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Savepoint::getAppId, (Object)savepoint.getAppId());
        return this.page((IPage)page, (Wrapper)queryWrapper);
    }

    @Override
    public void removeApp(Application application) {
        Long appId = application.getId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Savepoint::getAppId, (Object)appId);
        this.remove((Wrapper)queryWrapper);
        try {
            application.getFsOperator().delete(application.getWorkspace().APP_SAVEPOINTS().concat("/").concat(appId.toString()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

