/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.fs.FsOperator;
import org.apache.streampark.common.util.AssertUtils$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Logger$class;
import org.apache.streampark.common.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class LfsOperator$
extends FsOperator
implements Logger {
    public static final LfsOperator$ MODULE$;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new LfsOperator$();
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public String logName() {
        return Logger$class.logName(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger$class.logger(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger$class.logInfo(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger$class.logDebug(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger$class.logTrace(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger$class.logWarn(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger$class.logWarn(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger$class.logError(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger$class.isTraceEnabled(this);
    }

    @Override
    public boolean exists(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && new File(path).exists();
    }

    @Override
    public void mkdirs(String path) {
        if (!Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))) {
            FileUtils.forceMkdir((File)new File(path));
        }
    }

    @Override
    public void delete(String path) {
        File file;
        if (AssertUtils$.MODULE$.isNotEmpty(path) && (file = new File(path)).exists()) {
            FileUtils.forceDelete((File)file);
        }
    }

    @Override
    public void move(String srcPath, String dstPath) {
        if (Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcPath, dstPath}))) {
            return;
        }
        File srcFile = new File(srcPath);
        File dstFile = new File(dstPath);
        if (srcFile.exists()) {
            String string = srcFile.getCanonicalPath();
            String string2 = dstFile.getCanonicalPath();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return;
            }
            FileUtils.moveToDirectory((File)srcFile, (File)dstFile, (boolean)true);
            return;
        }
    }

    @Override
    public void upload(String srcPath, String dstPath, boolean delSrc, boolean overwrite) {
        if (new File(srcPath).isDirectory()) {
            this.copyDir(srcPath, dstPath, delSrc, overwrite);
        } else {
            this.copy(srcPath, dstPath, delSrc, overwrite);
        }
    }

    @Override
    public void copy(String srcPath, String dstPath, boolean delSrc, boolean overwrite) {
        if (Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcPath, dstPath}))) {
            return;
        }
        File srcFile = new File(srcPath);
        if (srcFile.exists()) {
            boolean shouldCopy;
            boolean bl;
            File file;
            Predef$.MODULE$.require(srcFile.isFile(), (Function0)new Serializable(srcPath){
                public static final long serialVersionUID = 0L;
                private final String srcPath$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] ", " must be a file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.srcPath$2}));
                }
                {
                    this.srcPath$2 = srcPath$2;
                }
            });
            File file2 = new File(dstPath);
            if (file2.exists()) {
                file = file2.isDirectory() ? new File(file2, srcFile.getName()) : file2;
            } else {
                Predef$.MODULE$.require(file2.getParentFile().exists(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "[StreamPark] dstPath is invalid and does not exist. Please check";
                    }
                });
                file = file2;
            }
            File dstFile = file;
            String string = srcFile.getCanonicalPath();
            String string2 = dstFile.getCanonicalPath();
            Predef$.MODULE$.require(string != null ? !string.equals(string2) : string2 != null);
            if (overwrite) {
                bl = true;
            } else if (dstFile.exists()) {
                String string3 = dstFile.getName();
                String string4 = srcFile.getName();
                bl = string3 != null ? !string3.equals(string4) : string4 != null;
            } else {
                bl = shouldCopy = true;
            }
            if (shouldCopy) {
                FileUtils.copyFile((File)srcFile, (File)dstFile);
                if (delSrc) {
                    FileUtils.forceDelete((File)srcFile);
                }
            }
            return;
        }
    }

    @Override
    public void copyDir(String srcPath, String dstPath, boolean delSrc, boolean overwrite) {
        if (Utils$.MODULE$.isAnyBank((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{srcPath, dstPath}))) {
            return;
        }
        File srcFile = new File(srcPath);
        if (srcFile.exists()) {
            boolean shouldCopy;
            boolean bl;
            Predef$.MODULE$.require(srcFile.isDirectory(), (Function0)new Serializable(srcPath){
                public static final long serialVersionUID = 0L;
                private final String srcPath$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] ", " must be a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.srcPath$1}));
                }
                {
                    this.srcPath$1 = srcPath$1;
                }
            });
            File dstFile = new File(dstPath);
            if (!overwrite && dstFile.exists()) {
                String string = srcFile.getCanonicalPath();
                String string2 = dstFile.getCanonicalPath();
                bl = string != null ? !string.equals(string2) : string2 != null;
            } else {
                bl = shouldCopy = true;
            }
            if (shouldCopy) {
                FileUtils.copyDirectory((File)srcFile, (File)dstFile);
                if (delSrc) {
                    FileUtils.deleteDirectory((File)srcFile);
                }
            }
            return;
        }
    }

    @Override
    public String fileMd5(String path) {
        Predef$.MODULE$.require(path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] LFsOperator.fileMd5: file must not be null."})).s((Seq)Nil$.MODULE$);
            }
        });
        File file = new File(path);
        Predef$.MODULE$.require(file.exists(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[StreamPark] LFsOperator.fileMd5: file must exists."})).s((Seq)Nil$.MODULE$);
            }
        });
        return DigestUtils.md5Hex(IOUtils.toByteArray((InputStream)new FileInputStream(path)));
    }

    @Override
    public void mkCleanDirs(String path) {
        this.delete(path);
        this.mkdirs(path);
    }

    public File[] listDir(String path) {
        File[] fileArray;
        if (path == null || path.trim().isEmpty()) {
            fileArray = (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
        } else {
            File file = new File(path);
            File[] fileArray2 = file.exists() ? (file.isFile() ? (File[])((Object[])new File[]{file}) : file.listFiles()) : (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class));
            fileArray = fileArray2;
        }
        return fileArray;
    }

    private LfsOperator$() {
        MODULE$ = this;
        Logger$class.$init$(this);
    }
}

