/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.cache.ProcessorListener;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class SharedProcessor<T> {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private List<ProcessorListener<T>> listeners = new ArrayList<ProcessorListener<T>>();
    private List<ProcessorListener<T>> syncingListeners = new ArrayList<ProcessorListener<T>>();
    private final Executor executor;

    public SharedProcessor() {
        this(Runnable::run);
    }

    public SharedProcessor(Executor executor) {
        this.executor = executor;
    }

    public void addListener(ProcessorListener<T> processorListener) {
        this.lock.writeLock().lock();
        try {
            this.listeners.add(processorListener);
            this.syncingListeners.add(processorListener);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distribute(ProcessorListener.Notification<T> obj, boolean isSync) {
        ArrayList toCall;
        this.lock.readLock().lock();
        try {
            toCall = isSync ? new ArrayList(this.syncingListeners) : new ArrayList<ProcessorListener<T>>(this.listeners);
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.executor.execute(() -> {
            for (ProcessorListener listener : toCall) {
                listener.add(obj);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldResync() {
        this.lock.writeLock().lock();
        boolean resyncNeeded = false;
        try {
            this.syncingListeners = new ArrayList<ProcessorListener<T>>();
            ZonedDateTime now = ZonedDateTime.now();
            for (ProcessorListener<T> listener : this.listeners) {
                if (!listener.shouldResync(now)) continue;
                resyncNeeded = true;
                this.syncingListeners.add(listener);
                listener.determineNextResync(now);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return resyncNeeded;
    }

    public void stop() {
        this.lock.writeLock().lock();
        try {
            this.syncingListeners = null;
            this.listeners = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorListener<T> addProcessorListener(ResourceEventHandler<T> handler, long resyncPeriodMillis, Supplier<Collection<T>> initialItems) {
        this.lock.writeLock().lock();
        try {
            ProcessorListener<T> listener = new ProcessorListener<T>(handler, resyncPeriodMillis);
            for (T item : initialItems.get()) {
                listener.add(new ProcessorListener.AddNotification<T>(item));
            }
            this.addListener(listener);
            ProcessorListener<T> processorListener = listener;
            return processorListener;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

