/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.binding;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.ibatis.annotations.Flush;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ParamNameResolver;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

public class MapperMethod {
    private final SqlCommand command;
    private final MethodSignature method;

    public MapperMethod(Class<?> mapperInterface, Method method, Configuration config) {
        this.command = new SqlCommand(config, mapperInterface, method);
        this.method = new MethodSignature(config, mapperInterface, method);
    }

    public Object execute(SqlSession sqlSession, Object[] args) {
        Optional<Object> result;
        switch (this.command.getType()) {
            case INSERT: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.insert(this.command.getName(), param));
                break;
            }
            case UPDATE: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.update(this.command.getName(), param));
                break;
            }
            case DELETE: {
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = this.rowCountResult(sqlSession.delete(this.command.getName(), param));
                break;
            }
            case SELECT: {
                if (this.method.returnsVoid() && this.method.hasResultHandler()) {
                    this.executeWithResultHandler(sqlSession, args);
                    result = null;
                    break;
                }
                if (this.method.returnsMany()) {
                    result = this.executeForMany(sqlSession, args);
                    break;
                }
                if (this.method.returnsMap()) {
                    result = this.executeForMap(sqlSession, args);
                    break;
                }
                if (this.method.returnsCursor()) {
                    result = this.executeForCursor(sqlSession, args);
                    break;
                }
                Object param = this.method.convertArgsToSqlCommandParam(args);
                result = sqlSession.selectOne(this.command.getName(), param);
                if (!this.method.returnsOptional() || result != null && this.method.getReturnType().equals(result.getClass())) break;
                result = Optional.ofNullable(result);
                break;
            }
            case FLUSH: {
                result = sqlSession.flushStatements();
                break;
            }
            default: {
                throw new BindingException("Unknown execution method for: " + this.command.getName());
            }
        }
        if (result == null && this.method.getReturnType().isPrimitive() && !this.method.returnsVoid()) {
            throw new BindingException("Mapper method '" + this.command.getName() + " attempted to return null from a method with a primitive return type (" + this.method.getReturnType() + ").");
        }
        return result;
    }

    private Object rowCountResult(int rowCount) {
        Constable result;
        if (this.method.returnsVoid()) {
            result = null;
        } else if (Integer.class.equals(this.method.getReturnType()) || Integer.TYPE.equals(this.method.getReturnType())) {
            result = rowCount;
        } else if (Long.class.equals(this.method.getReturnType()) || Long.TYPE.equals(this.method.getReturnType())) {
            result = rowCount;
        } else if (Boolean.class.equals(this.method.getReturnType()) || Boolean.TYPE.equals(this.method.getReturnType())) {
            result = Boolean.valueOf(rowCount > 0);
        } else {
            throw new BindingException("Mapper method '" + this.command.getName() + "' has an unsupported return type: " + this.method.getReturnType());
        }
        return result;
    }

    private void executeWithResultHandler(SqlSession sqlSession, Object[] args) {
        MappedStatement ms = sqlSession.getConfiguration().getMappedStatement(this.command.getName());
        if (!StatementType.CALLABLE.equals((Object)ms.getStatementType()) && Void.TYPE.equals(ms.getResultMaps().get(0).getType())) {
            throw new BindingException("method " + this.command.getName() + " needs either a @ResultMap annotation, a @ResultType annotation, or a resultType attribute in XML so a ResultHandler can be used as a parameter.");
        }
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            sqlSession.select(this.command.getName(), param, rowBounds, this.method.extractResultHandler(args));
        } else {
            sqlSession.select(this.command.getName(), param, this.method.extractResultHandler(args));
        }
    }

    private <E> Object executeForMany(SqlSession sqlSession, Object[] args) {
        List result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectList(this.command.getName(), param, rowBounds);
        } else {
            result = sqlSession.selectList(this.command.getName(), param);
        }
        if (!this.method.getReturnType().isAssignableFrom(result.getClass())) {
            if (this.method.getReturnType().isArray()) {
                return this.convertToArray(result);
            }
            return this.convertToDeclaredCollection(sqlSession.getConfiguration(), result);
        }
        return result;
    }

    private <T> Cursor<T> executeForCursor(SqlSession sqlSession, Object[] args) {
        Cursor result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectCursor(this.command.getName(), param, rowBounds);
        } else {
            result = sqlSession.selectCursor(this.command.getName(), param);
        }
        return result;
    }

    private <E> Object convertToDeclaredCollection(Configuration config, List<E> list) {
        Object collection = config.getObjectFactory().create(this.method.getReturnType());
        MetaObject metaObject = config.newMetaObject(collection);
        metaObject.addAll(list);
        return collection;
    }

    private <E> Object convertToArray(List<E> list) {
        Class<?> arrayComponentType = this.method.getReturnType().getComponentType();
        Object array = Array.newInstance(arrayComponentType, list.size());
        if (arrayComponentType.isPrimitive()) {
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return array;
        }
        return list.toArray((Object[])array);
    }

    private <K, V> Map<K, V> executeForMap(SqlSession sqlSession, Object[] args) {
        Map result;
        Object param = this.method.convertArgsToSqlCommandParam(args);
        if (this.method.hasRowBounds()) {
            RowBounds rowBounds = this.method.extractRowBounds(args);
            result = sqlSession.selectMap(this.command.getName(), param, this.method.getMapKey(), rowBounds);
        } else {
            result = sqlSession.selectMap(this.command.getName(), param, this.method.getMapKey());
        }
        return result;
    }

    public static class MethodSignature {
        private final boolean returnsMany;
        private final boolean returnsMap;
        private final boolean returnsVoid;
        private final boolean returnsCursor;
        private final boolean returnsOptional;
        private final Class<?> returnType;
        private final String mapKey;
        private final Integer resultHandlerIndex;
        private final Integer rowBoundsIndex;
        private final ParamNameResolver paramNameResolver;

        public MethodSignature(Configuration configuration, Class<?> mapperInterface, Method method) {
            Type resolvedReturnType = TypeParameterResolver.resolveReturnType(method, mapperInterface);
            this.returnType = resolvedReturnType instanceof Class ? (Class<Object>)resolvedReturnType : (resolvedReturnType instanceof ParameterizedType ? (Class<Object>)((ParameterizedType)resolvedReturnType).getRawType() : method.getReturnType());
            this.returnsVoid = Void.TYPE.equals(this.returnType);
            this.returnsMany = configuration.getObjectFactory().isCollection(this.returnType) || this.returnType.isArray();
            this.returnsCursor = Cursor.class.equals(this.returnType);
            this.returnsOptional = Optional.class.equals(this.returnType);
            this.mapKey = this.getMapKey(method);
            this.returnsMap = this.mapKey != null;
            this.rowBoundsIndex = this.getUniqueParamIndex(method, RowBounds.class);
            this.resultHandlerIndex = this.getUniqueParamIndex(method, ResultHandler.class);
            this.paramNameResolver = new ParamNameResolver(configuration, method);
        }

        public Object convertArgsToSqlCommandParam(Object[] args) {
            return this.paramNameResolver.getNamedParams(args);
        }

        public boolean hasRowBounds() {
            return this.rowBoundsIndex != null;
        }

        public RowBounds extractRowBounds(Object[] args) {
            return this.hasRowBounds() ? (RowBounds)args[this.rowBoundsIndex] : null;
        }

        public boolean hasResultHandler() {
            return this.resultHandlerIndex != null;
        }

        public ResultHandler extractResultHandler(Object[] args) {
            return this.hasResultHandler() ? (ResultHandler)args[this.resultHandlerIndex] : null;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public boolean returnsMany() {
            return this.returnsMany;
        }

        public boolean returnsMap() {
            return this.returnsMap;
        }

        public boolean returnsVoid() {
            return this.returnsVoid;
        }

        public boolean returnsCursor() {
            return this.returnsCursor;
        }

        public boolean returnsOptional() {
            return this.returnsOptional;
        }

        private Integer getUniqueParamIndex(Method method, Class<?> paramType) {
            Integer index = null;
            Class<?>[] argTypes = method.getParameterTypes();
            for (int i = 0; i < argTypes.length; ++i) {
                if (!paramType.isAssignableFrom(argTypes[i])) continue;
                if (index == null) {
                    index = i;
                    continue;
                }
                throw new BindingException(method.getName() + " cannot have multiple " + paramType.getSimpleName() + " parameters");
            }
            return index;
        }

        public String getMapKey() {
            return this.mapKey;
        }

        private String getMapKey(Method method) {
            MapKey mapKeyAnnotation;
            String mapKey = null;
            if (Map.class.isAssignableFrom(method.getReturnType()) && (mapKeyAnnotation = method.getAnnotation(MapKey.class)) != null) {
                mapKey = mapKeyAnnotation.value();
            }
            return mapKey;
        }
    }

    public static class SqlCommand {
        private final String name;
        private final SqlCommandType type;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SqlCommand(Configuration configuration, Class<?> mapperInterface, Method method) {
            String methodName = method.getName();
            Class<?> declaringClass = method.getDeclaringClass();
            MappedStatement ms = this.resolveMappedStatement(mapperInterface, methodName, declaringClass, configuration);
            if (ms == null) {
                if (method.getAnnotation(Flush.class) == null) throw new BindingException("Invalid bound statement (not found): " + mapperInterface.getName() + "." + methodName);
                this.name = null;
                this.type = SqlCommandType.FLUSH;
                return;
            } else {
                this.name = ms.getId();
                this.type = ms.getSqlCommandType();
                if (this.type != SqlCommandType.UNKNOWN) return;
                throw new BindingException("Unknown execution method for: " + this.name);
            }
        }

        public String getName() {
            return this.name;
        }

        public SqlCommandType getType() {
            return this.type;
        }

        private MappedStatement resolveMappedStatement(Class<?> mapperInterface, String methodName, Class<?> declaringClass, Configuration configuration) {
            String statementId = mapperInterface.getName() + "." + methodName;
            if (configuration.hasStatement(statementId)) {
                return configuration.getMappedStatement(statementId);
            }
            if (mapperInterface.equals(declaringClass)) {
                return null;
            }
            for (Class<?> superInterface : mapperInterface.getInterfaces()) {
                MappedStatement ms;
                if (!declaringClass.isAssignableFrom(superInterface) || (ms = this.resolveMappedStatement(superInterface, methodName, declaringClass, configuration)) == null) continue;
                return ms;
            }
            return null;
        }
    }

    public static class ParamMap<V>
    extends HashMap<String, V> {
        private static final long serialVersionUID = -2212268410512043556L;

        @Override
        public V get(Object key) {
            if (!super.containsKey(key)) {
                throw new BindingException("Parameter '" + key + "' not found. Available parameters are " + this.keySet());
            }
            return super.get(key);
        }
    }
}

