/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.MessageProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultedMessageProvider
implements MessageProvider {
    private static final Log log = LogFactory.getLog(DefaultedMessageProvider.class);
    private final MessageProvider wrapped;
    private final Properties defaultsMessages;

    public static MessageProvider wrap(MessageProvider wrapped, String defaultsResource) {
        Properties defaults = DefaultedMessageProvider.loadResourceProperties(defaultsResource);
        return defaults == null ? wrapped : new DefaultedMessageProvider(wrapped, defaults);
    }

    protected static Properties loadResourceProperties(String defaultsResource) {
        InputStream in = JRLoader.getResourceInputStream(defaultsResource);
        Properties defaults = null;
        if (in != null) {
            try {
                defaults = new Properties();
                defaults.load(in);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.debug((Object)("Failed to close stream for " + defaultsResource), (Throwable)e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Did not find default messages resource " + defaultsResource));
        }
        return defaults;
    }

    public DefaultedMessageProvider(MessageProvider wrapped, Properties defaultsMessages) {
        this.defaultsMessages = defaultsMessages;
        this.wrapped = wrapped;
    }

    @Override
    public String getMessage(String code, Object[] args, Locale locale) {
        String message;
        block2: {
            try {
                message = this.wrapped.getMessage(code, args, locale);
            }
            catch (MissingResourceException e) {
                message = this.defaultsMessages.getProperty(code);
                if (message != null || !log.isDebugEnabled()) break block2;
                log.debug((Object)("Message not found for " + code));
            }
        }
        return message;
    }
}

