/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.jackson.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;

public class ReportTemplateSerializer
extends StdSerializer<JRReportTemplate> {
    private static final long serialVersionUID = 1L;

    public ReportTemplateSerializer() {
        this(null);
    }

    public ReportTemplateSerializer(Class<JRReportTemplate> vc) {
        super(vc);
    }

    public void serialize(JRReportTemplate value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        ToXmlGenerator xgen;
        ToXmlGenerator toXmlGenerator = xgen = jgen instanceof ToXmlGenerator ? (ToXmlGenerator)jgen : null;
        if (xgen == null) {
            JRExpression expression = value.getSourceExpression();
            if (expression != null) {
                jgen.writeString(expression.getText());
            }
        } else {
            jgen.writeStartObject();
            JRExpression expression = value.getSourceExpression();
            if (expression != null) {
                try {
                    xgen.getStaxWriter().writeCData(expression.getText());
                }
                catch (XMLStreamException e) {
                    throw new IOException(e);
                }
            }
            jgen.writeEndObject();
        }
    }
}

