<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## Change Log

### 5.0.0 (Wed Jun 18 13:54:10 2025 -0300)

**Database Migrations**

- [#31959](https://github.com/apache/superset/pull/31959) refactor: upload data unification, less permissions and less endpoints (@dpgaspar)
- [#31582](https://github.com/apache/superset/pull/31582) refactor: Removes 5.0 approved legacy charts (@michael-s-molina)
- [#31490](https://github.com/apache/superset/pull/31490) feat: use docker in frontend GHA to parallelize work (@mistercrunch)
- [#30398](https://github.com/apache/superset/pull/30398) feat: add and use UUIDMixin for most models (@mistercrunch)
- [#29649](https://github.com/apache/superset/pull/29649) fix: remove old database constraint on the Dataset model (@betodealmeida)
- [#31447](https://github.com/apache/superset/pull/31447) chore: enforce more ruff rules (@mistercrunch)
- [#31303](https://github.com/apache/superset/pull/31303) feat: Adds helper functions for migrations (@luizotavio32)

**Features**

- [#32052](https://github.com/apache/superset/pull/32052) feat: add connector for Parseable (@AdheipSingh)
- [#32051](https://github.com/apache/superset/pull/32051) feat(sqllab): improve table metadata UI (@justinpark)
- [#29900](https://github.com/apache/superset/pull/29900) feat(sqllab): Replace FilterableTable by AgGrid Table (@justinpark)
- [#31979](https://github.com/apache/superset/pull/31979) feat(fe): upgrade `superset-frontend` to Typescript v5 (@hainenber)
- [#31413](https://github.com/apache/superset/pull/31413) feat: add date format to the email subject (@US579)
- [#31984](https://github.com/apache/superset/pull/31984) feat: run prettier before eslint in pre-commit hooks (@mistercrunch)
- [#31889](https://github.com/apache/superset/pull/31889) feat(CalendarFrame): adding previous calendar quarter (@alexandrusoare)
- [#31796](https://github.com/apache/superset/pull/31796) feat: get docker-compose to work as the backend for Cypress tests (@mistercrunch)
- [#31876](https://github.com/apache/superset/pull/31876) feat: use npm run dev-server in docker-compose (@mistercrunch)
- [#31849](https://github.com/apache/superset/pull/31849) feat: old Firebolt dialect (@betodealmeida)
- [#31840](https://github.com/apache/superset/pull/31840) feat: Mutate SQL query executed by alerts (@Vitor-Avila)
- [#31825](https://github.com/apache/superset/pull/31825) feat: Firebolt sqlglot dialect (@betodealmeida)
- [#31575](https://github.com/apache/superset/pull/31575) feat: redesign labels (@mistercrunch)
- [#31747](https://github.com/apache/superset/pull/31747) feat: improve docker-compose services boot sequence (@mistercrunch)
- [#31760](https://github.com/apache/superset/pull/31760) feat: allowing print() statements to be unbuffered in docker (@mistercrunch)
- [#31486](https://github.com/apache/superset/pull/31486) feat: push predicates into virtual datasets (@betodealmeida)
- [#31518](https://github.com/apache/superset/pull/31518) feat: adds a github action to auto label draft prs (@sadpandajoe)
- [#31740](https://github.com/apache/superset/pull/31740) feat: make CI against 'next' python version not-required (@mistercrunch)
- [#31602](https://github.com/apache/superset/pull/31602) feat(Sqllab): Enabling selection and copying of columns and rows in sql lab and dataset view (@samraHanif0340)
- [#31580](https://github.com/apache/superset/pull/31580) feat(doris): add catalog support for Apache Doris (@liujiwen-up)
- [#25869](https://github.com/apache/superset/pull/25869) feat(plugin): add plugin-chart-cartodiagram (@jansule)
- [#31037](https://github.com/apache/superset/pull/31037) feat(country-map): add map for France with all overseas territories (@tarraschk)
- [#31386](https://github.com/apache/superset/pull/31386) feat(gha): various docker / docker-compose build improvements (@mistercrunch)
- [#31316](https://github.com/apache/superset/pull/31316) feat(sqllab): giving the query history pane a facelift (@mistercrunch)
- [#31273](https://github.com/apache/superset/pull/31273) feat: fine-grain chart data telemetry (@betodealmeida)
- [#31141](https://github.com/apache/superset/pull/31141) feat: add YDB as a new database engine (@vgvoleg)
- [#31261](https://github.com/apache/superset/pull/31261) feat(Handlebars): formatNumber and group helpers (@Vitor-Avila)
- [#31260](https://github.com/apache/superset/pull/31260) feat: use uv in CI (@mistercrunch)
- [#31187](https://github.com/apache/superset/pull/31187) feat(sqllab): Popup notification when download data can exceed row count (@justinpark)
- [#31166](https://github.com/apache/superset/pull/31166) feat: make sure to quote formulas on Excel export (@betodealmeida)
- [#31164](https://github.com/apache/superset/pull/31164) feat: purge OAuth2 tokens when DB changes (@betodealmeida)
- [#30870](https://github.com/apache/superset/pull/30870) feat: make ephemeral env use supersetbot + deprecate build_docker.py (@mistercrunch)
- [#30926](https://github.com/apache/superset/pull/30926) feat(trino,presto): add missing time grains (@villebro)
- [#30884](https://github.com/apache/superset/pull/30884) feat: add logging durations for screenshot async service (@mistercrunch)
- [#29609](https://github.com/apache/superset/pull/29609) feat: add a script to check environment software versions (@mistercrunch)
- [#30081](https://github.com/apache/superset/pull/30081) feat(oauth2): add support for trino (@joaoferrao)
- [#30694](https://github.com/apache/superset/pull/30694) feat: allow exporting all tabs to a single PDF in report (@US579)
- [#30674](https://github.com/apache/superset/pull/30674) feat(oauth): adding necessary changes to support bigquery oauth (@fisjac)
- [#30721](https://github.com/apache/superset/pull/30721) feat(dataset API): Add parameter to optionally render Jinja macros in API response (@Vitor-Avila)
- [#30412](https://github.com/apache/superset/pull/30412) feat: cancel impala query on stop (@wugeer)
- [#30710](https://github.com/apache/superset/pull/30710) feat(helm-chart): Add extraLabels to all resources (@maxforasteiro)
- [#29927](https://github.com/apache/superset/pull/29927) feat(db_engine_specs): added support for Denodo Virtual DataPort (@denodo-research-labs)
- [#30593](https://github.com/apache/superset/pull/30593) feat(number-format): Add duration formatter with colon notation (@gerbermichi)
- [#30559](https://github.com/apache/superset/pull/30559) feat(formatting): Add memory units adaptive formatter to format bytes (@mkopec87)
- [#30501](https://github.com/apache/superset/pull/30501) feat(SQL Lab): better SQL parsing error messages (@betodealmeida)
- [#30390](https://github.com/apache/superset/pull/30390) feat(be/cfg): replace deprecated imp.load_source with importlib.util (@hainenber)
- [#29395](https://github.com/apache/superset/pull/29395) feat(dashboard): update tab drag and drop reordering with positional placement and indicators for UI (@rtexelm)
- [#30380](https://github.com/apache/superset/pull/30380) feat(auth): when user is not logged in, failure to access a dashboard should redirect to login screen (@sfirke)
- [#30364](https://github.com/apache/superset/pull/30364) feat(datasets): Allow swap dataset after deletion (@Antonio-RiveroMartnez)
- [#30336](https://github.com/apache/superset/pull/30336) feat(Digest): Add RLS at digest generation for Charts and Dashboards (@geido)
- [#30266](https://github.com/apache/superset/pull/30266) feat: allow configuring an engine context manager (@betodealmeida)
- [#30323](https://github.com/apache/superset/pull/30323) feat(jinja): add option to format time filters using strftime (@villebro)
- [#29897](https://github.com/apache/superset/pull/29897) feat(explore): Add time shift color control to ECharts (@rtexelm)
- [#30016](https://github.com/apache/superset/pull/30016) feat: Displaying details to Dataset/Database deletion modals (@rusackas)
- [#30142](https://github.com/apache/superset/pull/30142) feat(jinja): add advanced temporal filter functionality (@villebro)
- [#28110](https://github.com/apache/superset/pull/28110) feat(db_engine): Implement user impersonation support for StarRocks (@Woellchen)
- [#30126](https://github.com/apache/superset/pull/30126) feat: OAuth2 database field (@betodealmeida)
- [#30082](https://github.com/apache/superset/pull/30082) feat: Oauth2 in DatabaseSelector (@betodealmeida)
- [#30071](https://github.com/apache/superset/pull/30071) feat: allow create/update OAuth2 DB (@betodealmeida)
- [#29912](https://github.com/apache/superset/pull/29912) feat(GAQ): Add Redis Sentinel Support for Global Async Queries (@nsivarajan)
- [#24308](https://github.com/apache/superset/pull/24308) feat(docker): add GUNICORN_LOGLEVEL env var (@drummerwolli)
- [#29333](https://github.com/apache/superset/pull/29333) feat(alert/reports): adding logic to handle downstream reports when tab is deleted from dashboard (@fisjac)
- [#30002](https://github.com/apache/superset/pull/30002) feat(time_comparison): Support all date formats when computing custom and inherit offsets (@Antonio-RiveroMartnez)
- [#25775](https://github.com/apache/superset/pull/25775) feat: Adding Elestio as deployment option (@kaiwalyakoparkar)
- [#29941](https://github.com/apache/superset/pull/29941) feat(docs): fix bug google chrome < 114 not found (@hoalongnatsu)
- [#29917](https://github.com/apache/superset/pull/29917) feat: Enable injecting custom html into head (@kgabryje)
- [#29875](https://github.com/apache/superset/pull/29875) feat(build): webpack visualizer (@rusackas)
- [#29724](https://github.com/apache/superset/pull/29724) feat: get html (links/styling/img/...) to work in pivot table (@mistercrunch)
- [#29795](https://github.com/apache/superset/pull/29795) feat: adding AntdThemeProvider to storybook config (@rusackas)
- [#29096](https://github.com/apache/superset/pull/29096) feat(alerts): enable tab selection for dashboard alerts/reports (@fisjac)
- [#29553](https://github.com/apache/superset/pull/29553) feat(explorer): Add configs and formatting to discrete comparison columns (@rtexelm)
- [#29627](https://github.com/apache/superset/pull/29627) feat(country map): Adding Hungary (and other touchups) (@rusackas)

**Fixes**

- [#33817](https://github.com/apache/superset/pull/33817) fix: SQL Lab warning message sizes (@michael-s-molina)
- [#33779](https://github.com/apache/superset/pull/33779) fix(Echarts): Echarts Legend Scroll fix (@amaannawab923)
- [#33765](https://github.com/apache/superset/pull/33765) fix(tooltip): Sanitize tooltip html (@msyavuz)
- [#33759](https://github.com/apache/superset/pull/33759) fix: apply d3 format to BigNumber(s) (@betodealmeida)
- [#33752](https://github.com/apache/superset/pull/33752) fix(create chart page): add missing space between words (@Quatters)
- [#33748](https://github.com/apache/superset/pull/33748) fix: sync dot color between dashboard chart and edit chart (@anantaoutlook)
- [#33743](https://github.com/apache/superset/pull/33743) fix(dataset): Fix plural toast messages (@rad-pat)
- [#33717](https://github.com/apache/superset/pull/33717) fix(explore): add gap to the "Cached" button (@Quatters)
- [#33719](https://github.com/apache/superset/pull/33719) fix(Alerts & reports): invalid "Last updated" time formatting (@Quatters)
- [#33726](https://github.com/apache/superset/pull/33726) fix(dashboard): show dashboard thumbnail images when retrieved (@rad-pat)
- [#33296](https://github.com/apache/superset/pull/33296) fix(template_processing): get_filters now works for IS_NULL and IS_NOT_NULL operators (@Prokos)
- [#32414](https://github.com/apache/superset/pull/32414) fix(api): Added uuid to list api calls (@withnale)
- [#33710](https://github.com/apache/superset/pull/33710) fix: Migrate charts with empty query_context (@luizotavio32)
- [#33592](https://github.com/apache/superset/pull/33592) fix: Makes time compare migration more resilient (@michael-s-molina)
- [#33596](https://github.com/apache/superset/pull/33596) fix: Missing processor context when rendering Jinja (@michael-s-molina)
- [#33285](https://github.com/apache/superset/pull/33285) fix: Adjust viz migrations to also migrate the queries object (@luizotavio32)
- [#33431](https://github.com/apache/superset/pull/33431) fix(sankey): incorrect nodeValues (@richardfogaca)
- [#33553](https://github.com/apache/superset/pull/33553) fix(AllEntities): Display action buttons according to the user permissions (@Vitor-Avila)
- [#30577](https://github.com/apache/superset/pull/30577) fix(user settings): Update forked cosmo theme to resolve down chevron in caret style (#30514) (@mklumpen)
- [#33540](https://github.com/apache/superset/pull/33540) fix(table): table sort by fix (@amaannawab923)
- [#33522](https://github.com/apache/superset/pull/33522) fix(Sqllab): Autocomplete got stuck in UI when open it too fast (@rebenitez1802)
- [#33444](https://github.com/apache/superset/pull/33444) fix: allow metadata to parse json (@eschutho)
- [#33425](https://github.com/apache/superset/pull/33425) fix(table-chart): time shift is not working (@justinpark)
- [#33364](https://github.com/apache/superset/pull/33364) fix(deckgl): fix deckgl multiple layers chart filter and viewport (@syedbarimanjan)
- [#33422](https://github.com/apache/superset/pull/33422) fix(Row): don't unload charts while embedded to reduce rerenders (@msyavuz)
- [#33354](https://github.com/apache/superset/pull/33354) fix: loading examples from raw.githubusercontent.com fails with 429 errors (@mistercrunch)
- [#31917](https://github.com/apache/superset/pull/31917) fix(be/utils): sync cache timeout for memoized function (@hainenber)
- [#33345](https://github.com/apache/superset/pull/33345) fix(i18n): zh_TW pybabel compile error: placeholders are incompatible (@bestlong)
- [#33337](https://github.com/apache/superset/pull/33337) fix: Edge case with metric not getting quoted in sort by when normalize_columns is enabled (@Vitor-Avila)
- [#33224](https://github.com/apache/superset/pull/33224) fix: Temporal filter conversion in viz migrations (@michael-s-molina)
- [#33306](https://github.com/apache/superset/pull/33306) fix: improve function detection (@betodealmeida)
- [#33269](https://github.com/apache/superset/pull/33269) fix(echarts): rename time series shifted colnames (@justinpark)
- [#33267](https://github.com/apache/superset/pull/33267) fix: mask password on DB import (@betodealmeida)
- [#33025](https://github.com/apache/superset/pull/33025) fix: LocalProxy is not mapped warning (@dpgaspar)
- [#33248](https://github.com/apache/superset/pull/33248) fix(histogram): remove extra single quotes (@rusackas)
- [#33250](https://github.com/apache/superset/pull/33250) fix(DB update): Gracefully handle querry error during DB update (@Vitor-Avila)
- [#33238](https://github.com/apache/superset/pull/33238) fix(heatmap): correctly render int and boolean falsy values on axes (@sfirke)
- [#33237](https://github.com/apache/superset/pull/33237) fix(sqllab permalink): Commit SQL Lab permalinks (@Vitor-Avila)
- [#33234](https://github.com/apache/superset/pull/33234) fix(standalone): Ensure correct URL param value for standalone mode (@Vitor-Avila)
- [#33291](https://github.com/apache/superset/pull/33291) fix(antd): Invalid dashed border in tertiary button (@justinpark)
- [#33214](https://github.com/apache/superset/pull/33214) fix(export): Full CSV/Excel exports respecting SQL_MAX_ROW config (@Vitor-Avila)
- [#33164](https://github.com/apache/superset/pull/33164) fix(sqllab): Invalid SQL Error breaks SQL Lab (@justinpark)
- [#33154](https://github.com/apache/superset/pull/33154) fix(deckgl): Update Arc to properly adjust line width (@rusackas)
- [#33161](https://github.com/apache/superset/pull/33161) fix: os.makedirs race condition (@jamra)
- [#33143](https://github.com/apache/superset/pull/33143) fix(echart): Thrown errors shown after resized (@justinpark)
- [#33138](https://github.com/apache/superset/pull/33138) fix(echart): Tooltip date format doesn't follow time grain (@justinpark)
- [#31692](https://github.com/apache/superset/pull/31692) fix(lang): patch FAB's LocaleView to redirect to previous page (@pomegranited)
- [#33106](https://github.com/apache/superset/pull/33106) fix(dashboard): invalid active tab state (@justinpark)
- [#33037](https://github.com/apache/superset/pull/33037) fix: Viz migration error handling (@michael-s-molina)
- [#33107](https://github.com/apache/superset/pull/33107) fix(playwright): allow screenshotting empty dashboards (@hxtmdev)
- [#33110](https://github.com/apache/superset/pull/33110) fix: resolve recent merge collisio (@mistercrunch)
- [#33103](https://github.com/apache/superset/pull/33103) fix: Allows configuration of Selenium Webdriver binary (@michael-s-molina)
- [#33109](https://github.com/apache/superset/pull/33109) fix(thumbnails): ensure consistent cache_key (@hxtmdev)
- [#32193](https://github.com/apache/superset/pull/32193) fix(dashboard): Generate screenshot via celery (@tahvane1)
- [#33087](https://github.com/apache/superset/pull/33087) fix(docker): fallback to pip if uv is not available (@hossein-khalilian)
- [#33059](https://github.com/apache/superset/pull/33059) fix: Adds missing **init** file to commands/logs (@michael-s-molina)
- [#33048](https://github.com/apache/superset/pull/33048) fix: improve error type on parse error (@justinpark)
- [#31720](https://github.com/apache/superset/pull/31720) fix(export): charts csv export in dashboards (@EmmanuelCbd)
- [#33024](https://github.com/apache/superset/pull/33024) fix(log): Missing failed query log on async queries (@justinpark)
- [#32839](https://github.com/apache/superset/pull/32839) fix: fix bug where dashboard did not enter fullscreen mode. (@LevisNgigi)
- [#28428](https://github.com/apache/superset/pull/28428) fix(dashboard): chart fullscreen issue when filter pane is collapsed (@hlvhe)
- [#29422](https://github.com/apache/superset/pull/29422) fix: `show_filters` URL parameter is not working (@hexcafe)
- [#32965](https://github.com/apache/superset/pull/32965) fix: Bar Chart (legacy) migration to keep labels layout (@michael-s-molina)
- [#30679](https://github.com/apache/superset/pull/30679) fix: fixed Add Metrics to Tree Chart (#29158) (@SBIN2010)
- [#32968](https://github.com/apache/superset/pull/32968) fix(pivot-table): Revert "fix(Pivot Table): Fix column width to respect currency config (#31414)" (@justinpark)
- [#32384](https://github.com/apache/superset/pull/32384) fix: Clicking in the body of a Markdown component does not put it into edit mode (@notHuman9504)
- [#32763](https://github.com/apache/superset/pull/32763) fix(sqllab): Invalid display of table column keys (@justinpark)
- [#32871](https://github.com/apache/superset/pull/32871) fix(Jinja): Emit time grain to table charts even if they don't have a temporal column (@Vitor-Avila)
- [#32372](https://github.com/apache/superset/pull/32372) fix(backend/async_events): allow user to configure username for Redis authentication in GLOBAL_ASYNC_QUERIES_CACHE_BACKEND (@hainenber)
- [#32873](https://github.com/apache/superset/pull/32873) fix: use role_model from security manager (@lohart13)
- [#32851](https://github.com/apache/superset/pull/32851) fix(ColorPickerControl): change color picker control width (@SBIN2010)
- [#32863](https://github.com/apache/superset/pull/32863) fix(table-chart): Do not show comparison columns config if time_compare is set to [] (@Vitor-Avila)
- [#31869](https://github.com/apache/superset/pull/31869) fix(translation): Dutch translations for Current datetime filter (@christiaan)
- [#32829](https://github.com/apache/superset/pull/32829) fix: update dataset/query catalog on DB changes (@betodealmeida)
- [#32850](https://github.com/apache/superset/pull/32850) fix(echarts): Sort series by name using natural comparison (@Vitor-Avila)
- [#32795](https://github.com/apache/superset/pull/32795) fix(log): store navigation path to get correct logging path (@justinpark)
- [#32665](https://github.com/apache/superset/pull/32665) fix: Time Comparison Feature Reverts Metric Labels to Metric Keys in Table Charts (@fardin-developer)
- [#32792](https://github.com/apache/superset/pull/32792) fix: key error in frontend on disallowed GSheets (@chrisvnimbus)
- [#32797](https://github.com/apache/superset/pull/32797) fix: CSV/Excel upload form change column dates description (@SBIN2010)
- [#32802](https://github.com/apache/superset/pull/32802) fix(sec): resolve CVE-2025-29907 and CVE-2025-25977 by pinning `jspdf` to v3 (@hainenber)
- [#32406](https://github.com/apache/superset/pull/32406) fix(model/helper): represent RLS filter clause in proper textual SQL string (@hainenber)
- [#32739](https://github.com/apache/superset/pull/32739) fix(excel export): big number truncation handling (@CharlesNkdl)
- [#32778](https://github.com/apache/superset/pull/32778) fix(config): correct slack image url in talisman (@v9dev)
- [#28350](https://github.com/apache/superset/pull/28350) fix(css): typos in styles (@Kukusik8)
- [#32775](https://github.com/apache/superset/pull/32775) fix(import): Missing catalog field in saved query schema (@Quatters)
- [#32774](https://github.com/apache/superset/pull/32774) fix(sqllab): Pass query_id as kwarg so backoff can see it (@Antonio-RiveroMartnez)
- [#32720](https://github.com/apache/superset/pull/32720) fix(chart control): Change default of "Y Axis Title Margin" (@Quatters)
- [#32761](https://github.com/apache/superset/pull/32761) fix: do not add calculated columns when syncing (@eschutho)
- [#31751](https://github.com/apache/superset/pull/31751) fix: Changing language doesn't affect echarts charts (@jpchev)
- [#28203](https://github.com/apache/superset/pull/28203) fix(contextmenu): uncaught TypeError (@sowo)
- [#32679](https://github.com/apache/superset/pull/32679) fix: ensure datasource permission in explore (@hxtmdev)
- [#32410](https://github.com/apache/superset/pull/32410) fix(import): Ensure import exceptions are logged (@withnale)
- [#32683](https://github.com/apache/superset/pull/32683) fix: coerce datetime conversion errors (@betodealmeida)
- [#32708](https://github.com/apache/superset/pull/32708) fix(logging): missing path in event data (@justinpark)
- [#32701](https://github.com/apache/superset/pull/32701) fix: boolean filters in Explore (@betodealmeida)
- [#32696](https://github.com/apache/superset/pull/32696) fix(spreadsheet uploads): make file extension comparisons case-insensitive (@sfirke)
- [#32691](https://github.com/apache/superset/pull/32691) fix(cosmetics): allow toast message to be toggled off when modal is opened (@hainenber)
- [#32699](https://github.com/apache/superset/pull/32699) fix: Signature of Celery pruner jobs (@michael-s-molina)
- [#32681](https://github.com/apache/superset/pull/32681) fix(log): Update recent_activity by event name (@justinpark)
- [#32678](https://github.com/apache/superset/pull/32678) fix: Update RELEASING/README.md (@michael-s-molina)
- [#32661](https://github.com/apache/superset/pull/32661) fix(gsheets): update params from encrypted extra (@betodealmeida)
- [#32657](https://github.com/apache/superset/pull/32657) fix(import): Import a DB connection with expanded rows enabled (@Vitor-Avila)
- [#32646](https://github.com/apache/superset/pull/32646) fix(dashboard): Ensure `dashboardId` is included in `form_data` for embedded mode (@mostopalove)
- [#32652](https://github.com/apache/superset/pull/32652) fix: Upgrade node base image to Debian 12 bookworm (@dolph)
- [#32608](https://github.com/apache/superset/pull/32608) fix(welcome): perf on distinct recent activities (@justinpark)
- [#32549](https://github.com/apache/superset/pull/32549) fix(dashboard): Support bigint value in native filters (@justinpark)
- [#32599](https://github.com/apache/superset/pull/32599) fix(Slack V2): Specify the filename for the Slack upload method (@Vitor-Avila)
- [#32572](https://github.com/apache/superset/pull/32572) fix: Log table retention policy (@michael-s-molina)
- [#32532](https://github.com/apache/superset/pull/32532) fix: add DateOffset to json serializer (@eschutho)
- [#32523](https://github.com/apache/superset/pull/32523) fix: keep calculated columns when datasource is updated (@eschutho)
- [#32507](https://github.com/apache/superset/pull/32507) fix: Show response message as default error (@eschutho)
- [#32336](https://github.com/apache/superset/pull/32336) fix(Slack): Fix Slack recipients migration to V2 (@Vitor-Avila)
- [#32511](https://github.com/apache/superset/pull/32511) fix(beat): prune_query celery task args fix (@Usiel)
- [#32499](https://github.com/apache/superset/pull/32499) fix(explore): Glitch in a tooltip with metric's name (@kgabryje)
- [#32486](https://github.com/apache/superset/pull/32486) fix: skip DB filter when doing OAuth2 (@betodealmeida)
- [#32488](https://github.com/apache/superset/pull/32488) fix(tooltip): displaying <a> tags correctly (@rusackas)
- [#32473](https://github.com/apache/superset/pull/32473) fix(plugin-chart-echarts): remove erroneous upper bound value (@villebro)
- [#32420](https://github.com/apache/superset/pull/32420) fix(com/grid-comp/markdown): pin `remark-gfm` to v3 to allow inline code block by backticks in Markdown (@hainenber)
- [#32423](https://github.com/apache/superset/pull/32423) fix(clickhouse): get_parameters_from_uri failing when secure is true (@codenamelxl)
- [#32290](https://github.com/apache/superset/pull/32290) fix(viz): update nesting logic to handle multiple dimensions in PartitionViz (@DamianPendrak)
- [#32382](https://github.com/apache/superset/pull/32382) fix(pinot): revert join and subquery flags (@yuribogomolov)
- [#32325](https://github.com/apache/superset/pull/32325) fix: bump FAB to 4.5.4 (@dpgaspar)
- [#32344](https://github.com/apache/superset/pull/32344) fix: ensure metric_macro expands templates (@betodealmeida)
- [#32348](https://github.com/apache/superset/pull/32348) fix: clickhouse-connect engine SSH parameter (@maybedino)
- [#32362](https://github.com/apache/superset/pull/32362) fix(docker): Configure nginx for consistent port mapping and hot reloading (@vedantprajapati)
- [#32350](https://github.com/apache/superset/pull/32350) fix(firebolt): allow backslach escape for single quotes (@betodealmeida)
- [#32356](https://github.com/apache/superset/pull/32356) fix(SSHTunnelForm): make the password tooltip visible (@EnxDev)
- [#32284](https://github.com/apache/superset/pull/32284) fix(roles): Add SqlLabPermalinkRestApi as default sqlab roles. (@LevisNgigi)
- [#32035](https://github.com/apache/superset/pull/32035) fix(fe/dashboard-list): display modifier info for `Last modified` data (@hainenber)
- [#32337](https://github.com/apache/superset/pull/32337) fix: revert "fix: remove sort values on stacked totals (#31333)" (@eschutho)
- [#31993](https://github.com/apache/superset/pull/31993) fix: oauth2 trino (@aurokk)
- [#32332](https://github.com/apache/superset/pull/32332) fix: Download as PDF fails due to cache error (@kgabryje)
- [#30888](https://github.com/apache/superset/pull/30888) fix: keep the tab order (@US579)
- [#32272](https://github.com/apache/superset/pull/32272) fix(viz/table): selected column not shown in Conditional Formatting popover (@hainenber)
- [#32253](https://github.com/apache/superset/pull/32253) fix: Decimal values for Histogram bins (@michael-s-molina)
- [#32218](https://github.com/apache/superset/pull/32218) fix(Datasource): handle undefined datasource_type in fetchSyncedColumns (@tahvane1)
- [#32240](https://github.com/apache/superset/pull/32240) fix: upgrade to 3.11.11-slim-bookworm to address critical vulnerabilities (@gpchandran)
- [#31333](https://github.com/apache/superset/pull/31333) fix: remove sort values on stacked totals (@eschutho)
- [#32227](https://github.com/apache/superset/pull/32227) fix: Update 'Last modified' time when modifying RLS rules (@fardin-developer)
- [#32115](https://github.com/apache/superset/pull/32115) fix(Scope): Correct issue where filters appear out of scope when sort is unchecked. (@LevisNgigi)
- [#32224](https://github.com/apache/superset/pull/32224) fix(sqllab): close the table tab (@justinpark)
- [#32212](https://github.com/apache/superset/pull/32212) fix: set `Rich tooltip` -> 'Show percentage' to false by default (@mistercrunch)
- [#32222](https://github.com/apache/superset/pull/32222) fix(SaveDatasetModal): repairs field alignment in the SaveDatasetModal component (@EnxDev)
- [#32211](https://github.com/apache/superset/pull/32211) fix: hydrate datasetsStatus (@betodealmeida)
- [#32195](https://github.com/apache/superset/pull/32195) fix: handlebars html and css templates reset on dataset update (@DamianPendrak)
- [#32176](https://github.com/apache/superset/pull/32176) fix: TDengine move tdengine.png to databases/ subfolder (@DuanKuanJun)
- [#32185](https://github.com/apache/superset/pull/32185) fix: Adds an entry to UPDATING.md about DISABLE_LEGACY_DATASOURCE_EDITOR (@michael-s-molina)
- [#32154](https://github.com/apache/superset/pull/32154) fix(sqllab): correct URL format for SQL Lab permalinks (@LevisNgigi)
- [#30903](https://github.com/apache/superset/pull/30903) fix(virtual dataset sync): Sync virtual dataset columns when changing the SQL query (@fisjac)
- [#32163](https://github.com/apache/superset/pull/32163) fix(docker): Docker python-translation-build (@EmmanuelCbd)
- [#32156](https://github.com/apache/superset/pull/32156) fix: ScreenshotCachePayload serialization (@betodealmeida)
- [#32151](https://github.com/apache/superset/pull/32151) fix(releasing): fix borked SVN-based image building process (@hainenber)
- [#32137](https://github.com/apache/superset/pull/32137) fix: copy oauth2 capture to `get_sqla_engine` (@betodealmeida)
- [#32135](https://github.com/apache/superset/pull/32135) fix: Local tarball Docker container is missing zstd dependency (@michael-s-molina)
- [#32133](https://github.com/apache/superset/pull/32133) fix: No virtual environment when running Docker translation compiler (@michael-s-molina)
- [#32040](https://github.com/apache/superset/pull/32040) fix(ci): ephemeral env, handle different label, create comment (@dpgaspar)
- [#32064](https://github.com/apache/superset/pull/32064) fix(datepicker): Full width datepicker on filter value select (@msyavuz)
- [#32122](https://github.com/apache/superset/pull/32122) fix: Histogram examples config (@michael-s-molina)
- [#32053](https://github.com/apache/superset/pull/32053) fix: enforce `ALERT_REPORTS_MAX_CUSTOM_SCREENSHOT_WIDTH` (@betodealmeida)
- [#31757](https://github.com/apache/superset/pull/31757) fix(thumbnail cache): Enabling force parameter on screenshot/thumbnail cache (@fisjac)
- [#32061](https://github.com/apache/superset/pull/32061) fix(DatePicker): Increase z-index over Modal (@geido)
- [#32031](https://github.com/apache/superset/pull/32031) fix(fe/explore): prevent runtime error when editing Dataset-origin Chart with empty title (@hainenber)
- [#32045](https://github.com/apache/superset/pull/32045) fix: Revert "fix: re-enable cypress checks" (@mistercrunch)
- [#32008](https://github.com/apache/superset/pull/32008) fix: re-enable cypress checks (@mistercrunch)
- [#32017](https://github.com/apache/superset/pull/32017) fix: eph env + improve docker images to run in userspace (@mistercrunch)
- [#31340](https://github.com/apache/superset/pull/31340) fix(ci): change ephemeral env to use github labels instead of comments (@dpgaspar)
- [#32025](https://github.com/apache/superset/pull/32025) fix: Filters badge disappeared (@kgabryje)
- [#32015](https://github.com/apache/superset/pull/32015) fix(issue #31927): TimeGrain.WEEK_STARTING_MONDAY (@AdrianMastronardi)
- [#30716](https://github.com/apache/superset/pull/30716) fix: Reordering echart props to fix confidence interval in Mixed Charts (@geotab-data-platform)
- [#32005](https://github.com/apache/superset/pull/32005) fix(sqllab): tab layout truncated (@justinpark)
- [#29417](https://github.com/apache/superset/pull/29417) fix(verbose map): Correct raw metrics handling in verbose map (@mcdogg17)
- [#31962](https://github.com/apache/superset/pull/31962) fix: proper URL building (@betodealmeida)
- [#31941](https://github.com/apache/superset/pull/31941) fix(timezoneselector): Correct the order to match names first (@msyavuz)
- [#25166](https://github.com/apache/superset/pull/25166) fix: correct value for config variable `UPLOAD_FOLDER` (@sebastianliebscher)
- [#31948](https://github.com/apache/superset/pull/31948) fix: Load cached DB metadata as DatasourceName and add catalog to schema_list cache key (@Vitor-Avila)
- [#31809](https://github.com/apache/superset/pull/31809) fix: Prevent undo functionality from referencing incorrect dashboard edits (@fardin-developer)
- [#30949](https://github.com/apache/superset/pull/30949) fix: adjust line type as well as weight for time series (@eschutho)
- [#31933](https://github.com/apache/superset/pull/31933) fix(E2E): Fix flaky Dashboard list delete test (@geido)
- [#31867](https://github.com/apache/superset/pull/31867) fix(date_parser): fixed bug for advanced time range filter (@alexandrusoare)
- [#31873](https://github.com/apache/superset/pull/31873) fix(documentation): updated link to CORS_OPTIONS in Networking Settings (@ankur-zignite91)
- [#31910](https://github.com/apache/superset/pull/31910) fix: add catalog to cache key when getting tables/views (@betodealmeida)
- [#31837](https://github.com/apache/superset/pull/31837) fix(bigquery): return no catalogs when creds not set (@betodealmeida)
- [#31848](https://github.com/apache/superset/pull/31848) fix: d3.count doesn't exist (@mistercrunch)
- [#31830](https://github.com/apache/superset/pull/31830) fix: fix/suppress webpack console warnings (@mistercrunch)
- [#31834](https://github.com/apache/superset/pull/31834) fix(OAuth): Remove masked_encrypted_extra from DB update properties (@Vitor-Avila)
- [#31798](https://github.com/apache/superset/pull/31798) fix(Embedded): Skip CSRF validation for dashboard download endpoints (@Vitor-Avila)
- [#31815](https://github.com/apache/superset/pull/31815) fix(modal): fixed z-index issue (@alexandrusoare)
- [#31774](https://github.com/apache/superset/pull/31774) fix: corrects spelling of USE_ANALAGOUS_COLORS to be USE_ANALOGOUS_COLORS (@rusackas)
- [#31777](https://github.com/apache/superset/pull/31777) fix(oauth): Handle updates to the OAuth config (@Vitor-Avila)
- [#31789](https://github.com/apache/superset/pull/31789) fix(button): change back button styles for dropdown buttons (@msyavuz)
- [#31752](https://github.com/apache/superset/pull/31752) fix: Heatmap sorting (@michael-s-molina)
- [#31742](https://github.com/apache/superset/pull/31742) fix: GHA frontend builds fail when frontends hasn't changed (@mistercrunch)
- [#31732](https://github.com/apache/superset/pull/31732) fix: docker builds in forks (@mistercrunch)
- [#31606](https://github.com/apache/superset/pull/31606) fix: docker-compose-image-tag fails to start (@mistercrunch)
- [#31710](https://github.com/apache/superset/pull/31710) fix(inthewild): Update companies using superset (@gwthm-in)
- [#31673](https://github.com/apache/superset/pull/31673) fix: typo in plugin-chart-echats controls (@vhf)
- [#31688](https://github.com/apache/superset/pull/31688) fix(helm): change values.yaml comments (@sule26)
- [#31588](https://github.com/apache/superset/pull/31588) fix: install uv in docker-bootstrap (@mistercrunch)
- [#31583](https://github.com/apache/superset/pull/31583) fix(docs): get quickstart guide working again (@sfirke)
- [#31561](https://github.com/apache/superset/pull/31561) fix: add various recent issues on master CI (@mistercrunch)
- [#31493](https://github.com/apache/superset/pull/31493) fix: master docker builds fail because of multi-platform builds can't --load (@mistercrunch)
- [#31483](https://github.com/apache/superset/pull/31483) fix: Card component background color (@kgabryje)
- [#31472](https://github.com/apache/superset/pull/31472) fix: Tooltip covers the date selector in native filters (@kgabryje)
- [#31473](https://github.com/apache/superset/pull/31473) fix(explore): Styling issue in Search Metrics input field (@kgabryje)
- [#31449](https://github.com/apache/superset/pull/31449) fix(filter options): full size list item targets (@rusackas)
- [#31458](https://github.com/apache/superset/pull/31458) fix(api): typo api.py (@zero-stroke)
- [#31385](https://github.com/apache/superset/pull/31385) fix: docker refactor (@mistercrunch)
- [#31374](https://github.com/apache/superset/pull/31374) fix(Dashboard): Sync color configuration via dedicated endpoint (@geido)
- [#31411](https://github.com/apache/superset/pull/31411) fix: pkg_resources is getting deprecated (@mistercrunch)
- [#31391](https://github.com/apache/superset/pull/31391) fix: don't include chromium on ephemeral envs (@mistercrunch)
- [#31387](https://github.com/apache/superset/pull/31387) fix: Revert "chore(deps-dev): bump esbuild from 0.20.0 to 0.24.0 in /super… (@sadpandajoe)
- [#31236](https://github.com/apache/superset/pull/31236) fix: ephemeral envs fail on noop (@dpgaspar)
- [#31350](https://github.com/apache/superset/pull/31350) fix(alerts&reports): tabs with userfriendly urls (@tahvane1)
- [#30956](https://github.com/apache/superset/pull/30956) fix: added missing pod labels for init job (@glothriel)
- [#31279](https://github.com/apache/superset/pull/31279) fix(filters): improving the add filter/divider UI. (@rusackas)
- [#31155](https://github.com/apache/superset/pull/31155) fix: helm chart deploy to open PRs to now-protected gh-pages branch (@mistercrunch)
- [#31152](https://github.com/apache/superset/pull/31152) fix: try to re-enable gh-pages (@mistercrunch)
- [#31148](https://github.com/apache/superset/pull/31148) fix: touch helm/ folder to trigger doc deploy in CI (@mistercrunch)
- [#31035](https://github.com/apache/superset/pull/31035) fix: ephemeral environments missing env var (@mistercrunch)
- [#30966](https://github.com/apache/superset/pull/30966) fix(helm-chart): Fix broken PodDisruptionBudget due to introduction of extraLabels. (@theoriginalgri)
- [#30964](https://github.com/apache/superset/pull/30964) fix(Card): Use correct class names for Ant Design 5 Card component (@geido)
- [#30924](https://github.com/apache/superset/pull/30924) fix(helm): use submodule on helm release action (@villebro)
- [#30767](https://github.com/apache/superset/pull/30767) fix(empty dashboards): Allow downloading a screenshot of an empty dashboard (@msyavuz)
- [#30885](https://github.com/apache/superset/pull/30885) fix(docs): add missing bracket in openID config (@samarsrivastav)
- [#30858](https://github.com/apache/superset/pull/30858) fix(chart data): removing query from /chart/data payload when accessing as guest user (@fisjac)
- [#30848](https://github.com/apache/superset/pull/30848) fix(time_comparison): Allow deleting dates when using custom shift (@Antonio-RiveroMartnez)
- [#28524](https://github.com/apache/superset/pull/28524) fix: warning emits an error (@eschutho)
- [#30682](https://github.com/apache/superset/pull/30682) fix(explore): Update tooltip copy for rendering html in tables and pivot tables (@yousoph)
- [#30618](https://github.com/apache/superset/pull/30618) fix(mssql db_engine_spec): adds uniqueidentifier to column_type_mappings (@rparsonsbb)
- [#27142](https://github.com/apache/superset/pull/27142) fix(chart): apply number format in Box Plot tooltip only where necessary (@goto-loop)
- [#30608](https://github.com/apache/superset/pull/30608) fix(country-map): Rename incorrect Vietnam province name for Country Map (@tienhung2812)
- [#30702](https://github.com/apache/superset/pull/30702) fix(Dashboard): DatePicker to not autoclose modal (@geido)
- [#30688](https://github.com/apache/superset/pull/30688) fix: bump FAB to 4.5.2 (@dpgaspar)
- [#30659](https://github.com/apache/superset/pull/30659) fix: Link Checking (@CodeWithEmad)
- [#30661](https://github.com/apache/superset/pull/30661) fix: Domain 'undefined' error in Storybook (@kgabryje)
- [#30626](https://github.com/apache/superset/pull/30626) fix: Module is not defined in Partition chart (@michael-s-molina)
- [#30616](https://github.com/apache/superset/pull/30616) fix(docs): leading whitespace line is causing page title and header to be malformed (@sfirke)
- [#30606](https://github.com/apache/superset/pull/30606) fix: Set correct amount of steps to avoid confusing logs while loading examples (@deathstrokedarksky)
- [#30522](https://github.com/apache/superset/pull/30522) fix(SQL Lab): hang when result set size is too big (@anamitraadhikari)
- [#30443](https://github.com/apache/superset/pull/30443) fix(Jinja metric macro): Support Drill By and Excel/CSV download without a dataset ID (@Vitor-Avila)
- [#30569](https://github.com/apache/superset/pull/30569) fix(dev-server): Revert "chore(fe): bump webpack-related packages to v5" (@geido)
- [#30069](https://github.com/apache/superset/pull/30069) fix(frontend/generator): fix failed Viz plugin build due to missing JSDOM config and dep (@hainenber)
- [#30277](https://github.com/apache/superset/pull/30277) fix(examples): fix examples uri for sqlite (@villebro)
- [#30509](https://github.com/apache/superset/pull/30509) fix(plugin/echarts): correct enum values for LABEL_POSITION map (@hainenber)
- [#30500](https://github.com/apache/superset/pull/30500) fix(sqllab): Remove redundant scrolling (@justinpark)
- [#30349](https://github.com/apache/superset/pull/30349) fix(radar-chart): metric options not available & add `min` option (@goncaloacteixeira)
- [#30493](https://github.com/apache/superset/pull/30493) fix(Package.json): Bump dayjs version (@geido)
- [#30406](https://github.com/apache/superset/pull/30406) fix(language): pt_BR translation (@diegolnasc)
- [#30441](https://github.com/apache/superset/pull/30441) fix: battling cypress' dashboard feature (@mistercrunch)
- [#30430](https://github.com/apache/superset/pull/30430) fix: cypress on master doesn't work because of --parallel flag (@mistercrunch)
- [#29444](https://github.com/apache/superset/pull/29444) fix(plugin/country/map): rectify naming for some Vietnamese provinces (@hainenber)
- [#30388](https://github.com/apache/superset/pull/30388) fix(ECharts): Revert ECharts version bump (@geido)
- [#30340](https://github.com/apache/superset/pull/30340) fix(CI): increase node JS heap size (@rusackas)
- [#30325](https://github.com/apache/superset/pull/30325) fix(db_engine_specs): add a few missing time grains to Postgres spec (@sfirke)
- [#30273](https://github.com/apache/superset/pull/30273) fix(dashboard): invalid button style in undo/redo button (@justinpark)
- [#30099](https://github.com/apache/superset/pull/30099) fix: Move copying translation files before npm run build in Docker (@martyngigg)
- [#30279](https://github.com/apache/superset/pull/30279) fix(install/docker): use zstd-baked image for building superset-frontend in containerized env (@hainenber)
- [#30234](https://github.com/apache/superset/pull/30234) fix(deps): release new embedded sdk (@rusackas)
- [#30237](https://github.com/apache/superset/pull/30237) fix(docs): change flask-oidc url (@drblack666)
- [#30217](https://github.com/apache/superset/pull/30217) fix(sdk): use latest @supserset-ui/switchboard version to avoid pulling empty dependency (@hainenber)
- [#30147](https://github.com/apache/superset/pull/30147) fix(docs): typo in docker-compose.mdx (@alexengrig)
- [#30148](https://github.com/apache/superset/pull/30148) fix: Adds the Deprecated label to Time-series Percent Change chart (@michael-s-molina)
- [#30141](https://github.com/apache/superset/pull/30141) fix(sqllab): race condition when updating same cursor position (@justinpark)
- [#30041](https://github.com/apache/superset/pull/30041) fix: Revert "fix(list/chart views): Chart Properties modal now has transitions" (@rusackas)
- [#30034](https://github.com/apache/superset/pull/30034) fix: Handle zstd encoding in webpack proxy config (@kgabryje)
- [#29916](https://github.com/apache/superset/pull/29916) fix: duplicate `truncateXAxis` option in `BarChart` (@dmitriyVasilievich1986)
- [#30013](https://github.com/apache/superset/pull/30013) fix(translations): Fixed APPLY translation in Spanish (@jvines)
- [#30001](https://github.com/apache/superset/pull/30001) fix: Reports are not sent when selecting to send as PNG, CSV or text (@eschutho)
- [#29686](https://github.com/apache/superset/pull/29686) fix: Removed fixed width constraint from Save button (@goldjee)
- [#29951](https://github.com/apache/superset/pull/29951) fix(i18n): translation fix in server side generated time grains (@Seboeb)
- [#29938](https://github.com/apache/superset/pull/29938) fix: thumbnail url json response was malformed (@eschutho)
- [#29944](https://github.com/apache/superset/pull/29944) fix: only show dataset name in list (@eschutho)
- [#29935](https://github.com/apache/superset/pull/29935) fix: Fix delete_fake_db (@stamplevskiyd)
- [#29522](https://github.com/apache/superset/pull/29522) fix(cli): add impersonate_user to db import (@chessman)
- [#29895](https://github.com/apache/superset/pull/29895) fix(PivotTable): Pass string only to safeHtmlSpan (@geido)
- [#29864](https://github.com/apache/superset/pull/29864) fix: mypy issue on py3.9 + prevent similar issues (@mistercrunch)
- [#29861](https://github.com/apache/superset/pull/29861) fix: mypy fails related to simplejson.dumps (@mistercrunch)
- [#24411](https://github.com/apache/superset/pull/24411) fix(docs): update timescale.png (@mathisve)
- [#29851](https://github.com/apache/superset/pull/29851) fix: Add missing icons (@kgabryje)
- [#29591](https://github.com/apache/superset/pull/29591) fix: machine auth for GAQ enabled deployments (@harshit2283)
- [#29798](https://github.com/apache/superset/pull/29798) fix: set default timezone to UTC for cron timezone conversions (@danielli-ziprecruiter)
- [#28796](https://github.com/apache/superset/pull/28796) fix(list/chart views): Chart Properties modal now has transitions (@rusackas)
- [#29688](https://github.com/apache/superset/pull/29688) fix(ci): release process for labeling PRs (@mistercrunch)
- [#29779](https://github.com/apache/superset/pull/29779) fix: remove --no-optional from docker-compose build (@mistercrunch)

**Others**

- [#33745](https://github.com/apache/superset/pull/33745) build: update Dockerfile to 3.11.13-slim-bookworm (@gpchandran)
- [#33612](https://github.com/apache/superset/pull/33612) chore: update Dockerfile - Upgrade to 3.11.12 (@gpchandran)
- [#33339](https://github.com/apache/superset/pull/33339) chore(🦾): bump python h11 0.14.0 -> 0.16.0 (@github-actions[bot])
- [#32745](https://github.com/apache/superset/pull/32745) chore(🦾): bump python sqlglot 26.1.3 -> 26.11.1 (@github-actions[bot])
- [#32239](https://github.com/apache/superset/pull/32239) docs: adding notes about using uv instead of raw pip (@mistercrunch)
- [#32221](https://github.com/apache/superset/pull/32221) chore(ci): fix ephemeral env null issue number (v2) (@dpgaspar)
- [#32220](https://github.com/apache/superset/pull/32220) chore(ci): fix ephemeral env null issue number (@dpgaspar)
- [#32030](https://github.com/apache/superset/pull/32030) chore(timeseries charts): adjust legend width by padding (@eschutho)
- [#32062](https://github.com/apache/superset/pull/32062) chore: Re-enable asnyc event API tests (@Vitor-Avila)
- [#32004](https://github.com/apache/superset/pull/32004) refactor(Radio): Upgrade Radio Component to Ant Design 5 (@EnxDev)
- [#32054](https://github.com/apache/superset/pull/32054) chore: Add more database-related tests (follow up to #31948) (@Vitor-Avila)
- [#31811](https://github.com/apache/superset/pull/31811) chore(Network Errors): Update network errors on filter bars and charts (@msyavuz)
- [#31794](https://github.com/apache/superset/pull/31794) chore: Removing DASHBOARD_CROSS_FILTERS flag and all that comes with it. (@rusackas)
- [#32013](https://github.com/apache/superset/pull/32013) chore: add UPDATING note for CSV_UPLOAD_MAX_SIZE removal (@dpgaspar)
- [#31961](https://github.com/apache/superset/pull/31961) refactor: Upgrade to React 17 (@kgabryje)
- [#32007](https://github.com/apache/superset/pull/32007) chore(fe): correct typing for sheetsColumnNames (@hainenber)
- [#32000](https://github.com/apache/superset/pull/32000) refactor: Remove CSV upload size limit and related validation (@sha174n)
- [#31421](https://github.com/apache/superset/pull/31421) refactor(Shared_url_query): Fix shared query URL access for SQL Lab users. (@LevisNgigi)
- [#31980](https://github.com/apache/superset/pull/31980) chore: Add FYND to INTHEWILD.md (@darpanjain07)
- [#31976](https://github.com/apache/superset/pull/31976) refactor: Removes the legacy dataset editor (@michael-s-molina)
- [#31858](https://github.com/apache/superset/pull/31858) chore: refactor Alert-related components (@mistercrunch)
- [#31547](https://github.com/apache/superset/pull/31547) chore(deps): bump react-transition-group and @types/react-transition-group in /superset-frontend (@dependabot[bot])
- [#31963](https://github.com/apache/superset/pull/31963) chore(build): enforce eslint rule banning antd imports outside of core Superset components (@rusackas)
- [#31965](https://github.com/apache/superset/pull/31965) chore: fix `tsc` errors (@hainenber)
- [#31860](https://github.com/apache/superset/pull/31860) chore: Empty state refactor (@mistercrunch)
- [#31844](https://github.com/apache/superset/pull/31844) chore: replace selenium user with fixed user (@villebro)
- [#31943](https://github.com/apache/superset/pull/31943) refactor: Removes legacy dashboard endpoints (@michael-s-molina)
- [#31942](https://github.com/apache/superset/pull/31942) refactor: Removes legacy CSS template endpoint (@michael-s-molina)
- [#31819](https://github.com/apache/superset/pull/31819) chore(fe): migrate 6 Enzyme-based unit tests to RTL (@hainenber)
- [#31947](https://github.com/apache/superset/pull/31947) chore: bump FAB to 4.5.3 (@dpgaspar)
- [#30284](https://github.com/apache/superset/pull/30284) chore(GAQ): Remove GLOBAL_ASYNC_QUERIES_REDIS_CONFIG (@nsivarajan)
- [#31926](https://github.com/apache/superset/pull/31926) chore: cypress set up tweaks (@mistercrunch)
- [#31905](https://github.com/apache/superset/pull/31905) chore: Reduces the form_data_key length (@michael-s-molina)
- [#31460](https://github.com/apache/superset/pull/31460) docs: Removed mentioning of .env-non-dev in docker/README.md (@nikelborm)
- [#31907](https://github.com/apache/superset/pull/31907) chore: replace Lodash usage with native JS implementation (@hainenber)
- [#31699](https://github.com/apache/superset/pull/31699) refactor(Menu): Upgrade Menu Component to Ant Design 5 (@geido)
- [#31908](https://github.com/apache/superset/pull/31908) chore(fe): dev deps cleanup (@hainenber)
- [#31916](https://github.com/apache/superset/pull/31916) docs: clarify port configuration for Cypress (@mistercrunch)
- [#29163](https://github.com/apache/superset/pull/29163) refactor(sqllab): migrate share queries via kv by permalink (@justinpark)
- [#29121](https://github.com/apache/superset/pull/29121) perf(dashboard): dashboard list endpoint returning large and unnecessary data (@Always-prog)
- [#31894](https://github.com/apache/superset/pull/31894) chore(config): Deprecating Domain Sharding (@rusackas)
- [#31795](https://github.com/apache/superset/pull/31795) chore: Re-enable skipped tests (@michael-s-molina)
- [#31875](https://github.com/apache/superset/pull/31875) chore: add a disable for pylint (@betodealmeida)
- [#31874](https://github.com/apache/superset/pull/31874) docs: add a note about accessing the dev env's postgres database (@mistercrunch)
- [#31845](https://github.com/apache/superset/pull/31845) chore: add eslint to pre-commit hooks (@mistercrunch)
- [#31847](https://github.com/apache/superset/pull/31847) chore(ci): auto delete branches on merge (@rusackas)
- [#31846](https://github.com/apache/superset/pull/31846) chore: properly import expect from chai in cypress-base/cypress/support/e2e.ts (@mistercrunch)
- [#31831](https://github.com/apache/superset/pull/31831) chore: bump @ant-design/icons to fix fill-rule console warning (@mistercrunch)
- [#31503](https://github.com/apache/superset/pull/31503) chore: python version to 3.11 (while supporting 3.10) (@mistercrunch)
- [#31761](https://github.com/apache/superset/pull/31761) build(eslint): disabling wildcard imports with eslint (@rusackas)
- [#25933](https://github.com/apache/superset/pull/25933) chore(deps): bump selenium 4.14.0+ (@gnought)
- [#31820](https://github.com/apache/superset/pull/31820) chore(tests): Changing the logic for an intermittent tag test (@Vitor-Avila)
- [#31631](https://github.com/apache/superset/pull/31631) refactor(bulk_select): Fix bulk select tagging issues for users (@LevisNgigi)
- [#31019](https://github.com/apache/superset/pull/31019) refactor(date picker): Migrate Date Picker to Ant Design 5 (@msyavuz)
- [#31787](https://github.com/apache/superset/pull/31787) docs: improve dev python environment install (@sha174n)
- [#31797](https://github.com/apache/superset/pull/31797) chore: adding Antonio as a helm codeowner (@eschutho)
- [#31452](https://github.com/apache/superset/pull/31452) refactor(dashboard): Migrate ResizableContainer to TypeScript and functional component (@EnxDev)
- [#31791](https://github.com/apache/superset/pull/31791) chore: Skips integration tests affected by legacy charts removal (@michael-s-molina)
- [#31661](https://github.com/apache/superset/pull/31661) build(deps-dev): bump css-loader from 6.8.1 to 7.1.2 in /superset-frontend (@dependabot[bot])
- [#31668](https://github.com/apache/superset/pull/31668) build(deps-dev): bump css-minimizer-webpack-plugin from 5.0.1 to 7.0.0 in /superset-frontend (@dependabot[bot])
- [#31754](https://github.com/apache/superset/pull/31754) refactor: Removes Apply to all panels filters scope configuration (@michael-s-molina)
- [#31623](https://github.com/apache/superset/pull/31623) refactor(Button): Upgrade Button component to Antd5 (@alexandrusoare)
- [#31756](https://github.com/apache/superset/pull/31756) docs: add Remita to list (@mujibishola)
- [#31750](https://github.com/apache/superset/pull/31750) docs: add cover genius to the user list (@US579)
- [#31412](https://github.com/apache/superset/pull/31412) chore(ff): deprecating `DRILL_TO_DETAIL` feature flag to launch it prime-time (@rusackas)
- [#31718](https://github.com/apache/superset/pull/31718) refactor(Steps): Migrate Steps to Ant Design 5 (@msyavuz)
- [#31537](https://github.com/apache/superset/pull/31537) chore(deps): bump react-virtualized-auto-sizer from 1.0.24 to 1.0.25 in /superset-frontend (@dependabot[bot])
- [#31552](https://github.com/apache/superset/pull/31552) chore(deps-dev): bump eslint-plugin-react-hooks from 4.6.0 to 4.6.2 in /superset-frontend (@dependabot[bot])
- [#31545](https://github.com/apache/superset/pull/31545) chore(deps-dev): bump webpack from 5.94.0 to 5.97.1 in /superset-frontend (@dependabot[bot])
- [#31551](https://github.com/apache/superset/pull/31551) chore(deps-dev): bump eslint-plugin-cypress from 3.5.0 to 3.6.0 in /superset-frontend (@dependabot[bot])
- [#31559](https://github.com/apache/superset/pull/31559) chore(deps): bump abortcontroller-polyfill from 1.7.5 to 1.7.8 in /superset-frontend (@dependabot[bot])
- [#31653](https://github.com/apache/superset/pull/31653) build(deps): update @emotion/cache requirement from ^11.4.0 to ^11.14.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31664](https://github.com/apache/superset/pull/31664) build(deps): bump markdown-to-jsx from 7.4.7 to 7.7.2 in /superset-frontend (@dependabot[bot])
- [#31665](https://github.com/apache/superset/pull/31665) build(deps): bump html-webpack-plugin from 5.6.0 to 5.6.3 in /superset-frontend (@dependabot[bot])
- [#31666](https://github.com/apache/superset/pull/31666) build(deps-dev): bump @emotion/babel-plugin from 11.12.0 to 11.13.5 in /superset-frontend (@dependabot[bot])
- [#31667](https://github.com/apache/superset/pull/31667) build(deps-dev): bump jsdom from 24.1.1 to 25.0.1 in /superset-frontend (@dependabot[bot])
- [#31685](https://github.com/apache/superset/pull/31685) build(deps): bump jinja2 from 3.1.4 to 3.1.5 in /superset/translations (@dependabot[bot])
- [#31622](https://github.com/apache/superset/pull/31622) chore: replace `imp` built-in module usage for future Python3.12 usage (@hainenber)
- [#31712](https://github.com/apache/superset/pull/31712) chore(fe/sec): resolve High CVE-2024-21538 and Moderate CVE-2024-55565 by bumping `nanoid` and `cross-spawn` (@hainenber)
- [#31627](https://github.com/apache/superset/pull/31627) chore(helm): bump helm on CI to latest version (@villebro)
- [#31701](https://github.com/apache/superset/pull/31701) chore: add helm code owners (@villebro)
- [#31691](https://github.com/apache/superset/pull/31691) docs: add Open edX to users list (@pomegranited)
- [#31693](https://github.com/apache/superset/pull/31693) refactor(space): Migrate Space to Ant Design 5 (@msyavuz)
- [#31530](https://github.com/apache/superset/pull/31530) chore(deps-dev): bump eslint from 9.14.0 to 9.17.0 in /superset-websocket (@dependabot[bot])
- [#31670](https://github.com/apache/superset/pull/31670) build(deps): update echarts requirement from ^5.4.1 to ^5.6.0 in /superset-frontend/plugins/plugin-chart-echarts (@dependabot[bot])
- [#31652](https://github.com/apache/superset/pull/31652) build(deps): update chalk requirement from ^5.4.0 to ^5.4.1 in /superset-frontend/packages/generator-superset (@dependabot[bot])
- [#31655](https://github.com/apache/superset/pull/31655) build(deps): bump core-js from 3.38.1 to 3.39.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31656](https://github.com/apache/superset/pull/31656) build(deps): bump antd from 5.22.5 to 5.22.7 in /docs (@dependabot[bot])
- [#31657](https://github.com/apache/superset/pull/31657) build(deps-dev): update @babel/core requirement from ^7.23.9 to ^7.26.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31658](https://github.com/apache/superset/pull/31658) build(deps): update @emotion/react requirement from ^11.13.3 to ^11.14.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31662](https://github.com/apache/superset/pull/31662) build(deps-dev): bump @types/node from 22.7.4 to 22.10.3 in /superset-websocket (@dependabot[bot])
- [#31663](https://github.com/apache/superset/pull/31663) build(deps-dev): bump typescript-eslint from 8.12.2 to 8.19.0 in /superset-websocket (@dependabot[bot])
- [#31672](https://github.com/apache/superset/pull/31672) build(deps-dev): update @types/node requirement from ^22.5.4 to ^22.10.3 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#31633](https://github.com/apache/superset/pull/31633) refactor(empty): Migrate Empty component to Ant Design 5 (@msyavuz)
- [#31607](https://github.com/apache/superset/pull/31607) refactor(Divider): Migrate Divider to Ant Design 5 (@msyavuz)
- [#31310](https://github.com/apache/superset/pull/31310) refactor(moment): Replace Moment.js with DayJs (@msyavuz)
- [#30778](https://github.com/apache/superset/pull/30778) build(deps-dev): update @types/jest requirement from ^29.5.12 to ^29.5.14 in /superset-frontend/plugins/plugin-chart-handlebars (@dependabot[bot])
- [#31526](https://github.com/apache/superset/pull/31526) chore(deps): bump hot-shots from 10.0.0 to 10.2.1 in /superset-websocket (@dependabot[bot])
- [#31538](https://github.com/apache/superset/pull/31538) chore(deps-dev): update @babel/preset-react requirement from ^7.23.3 to ^7.26.3 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31217](https://github.com/apache/superset/pull/31217) chore(deps-dev): bump eslint-plugin-jest-dom from 3.6.5 to 5.5.0 in /superset-frontend (@dependabot[bot])
- [#31541](https://github.com/apache/superset/pull/31541) chore(deps): bump antd from 5.22.2 to 5.22.5 in /docs (@dependabot[bot])
- [#31536](https://github.com/apache/superset/pull/31536) chore(deps): bump prism-react-renderer from 2.4.0 to 2.4.1 in /docs (@dependabot[bot])
- [#30322](https://github.com/apache/superset/pull/30322) build(deps): bump find-my-way and @applitools/eyes-cypress in /superset-frontend/cypress-base (@dependabot[bot])
- [#30789](https://github.com/apache/superset/pull/30789) build(deps-dev): update @types/lodash requirement from ^4.17.7 to ^4.17.13 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#31523](https://github.com/apache/superset/pull/31523) chore(deps-dev): bump @types/lodash from 4.17.7 to 4.17.13 in /superset-websocket (@dependabot[bot])
- [#31546](https://github.com/apache/superset/pull/31546) chore(deps-dev): bump @types/rison from 0.0.9 to 0.1.0 in /superset-frontend (@dependabot[bot])
- [#31557](https://github.com/apache/superset/pull/31557) chore(deps): bump react-reverse-portal from 2.1.1 to 2.1.2 in /superset-frontend (@dependabot[bot])
- [#31577](https://github.com/apache/superset/pull/31577) docs: add Virtuoso QA to users list (@shubham-rohatgi)
- [#31520](https://github.com/apache/superset/pull/31520) chore(deps): bump debug from 4.3.7 to 4.4.0 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#30474](https://github.com/apache/superset/pull/30474) build(deps-dev): bump thread-loader from 4.0.2 to 4.0.4 in /superset-frontend (@dependabot[bot])
- [#30085](https://github.com/apache/superset/pull/30085) build(deps): bump gh-pages from 5.0.0 to 6.1.1 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31558](https://github.com/apache/superset/pull/31558) chore(deps-dev): bump eslint-import-resolver-typescript from 3.6.3 to 3.7.0 in /superset-frontend (@dependabot[bot])
- [#31521](https://github.com/apache/superset/pull/31521) chore(deps-dev): bump prettier from 3.3.3 to 3.4.2 in /superset-websocket (@dependabot[bot])
- [#30785](https://github.com/apache/superset/pull/30785) build(deps-dev): update @types/underscore requirement from ^1.11.15 to ^1.13.0 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#30779](https://github.com/apache/superset/pull/30779) build(deps-dev): update @types/lodash requirement from ^4.17.7 to ^4.17.13 in /superset-frontend/plugins/plugin-chart-handlebars (@dependabot[bot])
- [#31539](https://github.com/apache/superset/pull/31539) chore(deps-dev): bump webpack from 5.96.1 to 5.97.1 in /docs (@dependabot[bot])
- [#31540](https://github.com/apache/superset/pull/31540) chore(deps): bump @algolia/client-search from 5.15.0 to 5.18.0 in /docs (@dependabot[bot])
- [#27809](https://github.com/apache/superset/pull/27809) build(deps): bump @math.gl/web-mercator from 3.6.3 to 4.0.1 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#31529](https://github.com/apache/superset/pull/31529) chore(deps): update @deck.gl/aggregation-layers requirement from ^9.0.37 to ^9.0.38 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#31572](https://github.com/apache/superset/pull/31572) chore(deps): bump gh-pages from 5.0.0 to 6.2.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#30458](https://github.com/apache/superset/pull/30458) build(deps): bump @types/d3-format from 1.4.5 to 3.0.4 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#31542](https://github.com/apache/superset/pull/31542) chore(deps): bump @docsearch/react from 3.6.3 to 3.8.2 in /docs (@dependabot[bot])
- [#31225](https://github.com/apache/superset/pull/31225) chore(deps-dev): bump typescript from 4.9.5 to 5.7.2 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31388](https://github.com/apache/superset/pull/31388) chore(deps): update dompurify requirement from ^3.1.3 to ^3.2.3 in /superset-frontend/plugins/legacy-preset-chart-nvd3 (@dependabot[bot])
- [#31543](https://github.com/apache/superset/pull/31543) chore(deps): bump @storybook/types from 8.1.11 to 8.4.7 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31533](https://github.com/apache/superset/pull/31533) chore(deps): update chalk requirement from ^5.3.0 to ^5.4.0 in /superset-frontend/packages/generator-superset (@dependabot[bot])
- [#31532](https://github.com/apache/superset/pull/31532) chore(deps-dev): update @types/d3-time requirement from ^3.0.3 to ^3.0.4 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#31531](https://github.com/apache/superset/pull/31531) chore(deps): update yeoman-generator requirement from ^7.3.2 to ^7.4.0 in /superset-frontend/packages/generator-superset (@dependabot[bot])
- [#31525](https://github.com/apache/superset/pull/31525) chore(deps): update @deck.gl/layers requirement from ^9.0.37 to ^9.0.38 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#31524](https://github.com/apache/superset/pull/31524) chore(deps-dev): update @babel/types requirement from ^7.25.6 to ^7.26.3 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#31389](https://github.com/apache/superset/pull/31389) chore(deps): update @emotion/styled requirement from ^11.3.0 to ^11.14.0 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#31519](https://github.com/apache/superset/pull/31519) chore: remove dependency on func_timeout because LGPL (@mistercrunch)
- [#31517](https://github.com/apache/superset/pull/31517) chore: update browser list (@mistercrunch)
- [#31420](https://github.com/apache/superset/pull/31420) refactor(Modal): Upgrade Modal component to Antd5 (@alexandrusoare)
- [#31511](https://github.com/apache/superset/pull/31511) chore: rename `apply_post_process` (@betodealmeida)
- [#31390](https://github.com/apache/superset/pull/31390) chore(gha): bump ubuntu to latest fresh release (@mistercrunch)
- [#31313](https://github.com/apache/superset/pull/31313) chore: deprecate pip-compile-multi in favor or uv (@mistercrunch)
- [#31515](https://github.com/apache/superset/pull/31515) chore: deprecate fossa in favor of liccheck to validate python licenses (@mistercrunch)
- [#31501](https://github.com/apache/superset/pull/31501) chore(code owners): Update CODEOWNERS file to remove a couple inactive contributors (@rusackas)
- [#31496](https://github.com/apache/superset/pull/31496) docs: Update new user for Careem to user's list (@samraHanif0340)
- [#31451](https://github.com/apache/superset/pull/31451) chore: remove numba and llvmlite deps as they are large and we don't use them (@mistercrunch)
- [#30605](https://github.com/apache/superset/pull/30605) chore(translations): German translation update (@gerbermichi)
- [#31262](https://github.com/apache/superset/pull/31262) chore: deprecate `pylint` in favor of `ruff` (@mistercrunch)
- [#31422](https://github.com/apache/superset/pull/31422) docs: CVEs fixed on 4.1.0 v2 (@dpgaspar)
- [#31268](https://github.com/apache/superset/pull/31268) refactor: Migrate AdhocFilterEditPopoverSqlTabContent to TypeScript (@EnxDev)
- [#30196](https://github.com/apache/superset/pull/30196) build(packages): npm build/publish improvements. Making packages publishable again. (@rusackas)
- [#31378](https://github.com/apache/superset/pull/31378) chore(deps): bump nanoid from 3.3.7 to 3.3.8 in /docs (@dependabot[bot])
- [#31381](https://github.com/apache/superset/pull/31381) chore(embedded sdk): bump sdk version number (@rusackas)
- [#31380](https://github.com/apache/superset/pull/31380) chore(embedded sdk): bumping dependencies (@rusackas)
- [#31362](https://github.com/apache/superset/pull/31362) chore(deps): bump nanoid from 5.0.7 to 5.0.9 in /superset-frontend/cypress-base (@dependabot[bot])
- [#31209](https://github.com/apache/superset/pull/31209) chore(deps): bump antd from 5.21.6 to 5.22.2 in /docs (@dependabot[bot])
- [#31219](https://github.com/apache/superset/pull/31219) chore(deps-dev): bump esbuild from 0.20.0 to 0.24.0 in /superset-frontend (@dependabot[bot])
- [#31314](https://github.com/apache/superset/pull/31314) chore(deps): bump path-to-regexp and express in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#31220](https://github.com/apache/superset/pull/31220) chore(deps): bump winston from 3.15.0 to 3.17.0 in /superset-websocket (@dependabot[bot])
- [#31218](https://github.com/apache/superset/pull/31218) chore(deps-dev): bump @babel/eslint-parser from 7.23.10 to 7.25.9 in /superset-frontend (@dependabot[bot])
- [#31222](https://github.com/apache/superset/pull/31222) chore(deps-dev): bump @eslint/js from 9.14.0 to 9.16.0 in /superset-websocket (@dependabot[bot])
- [#31352](https://github.com/apache/superset/pull/31352) docs: CVEs fixed on 4.1.0 (@dpgaspar)
- [#31168](https://github.com/apache/superset/pull/31168) refactor(Alert): Migrate Alert component to Ant Design V5 (@LevisNgigi)
- [#31290](https://github.com/apache/superset/pull/31290) chore(FilterBar): move the "Add/edit filters" button in the FilterBar to the settings menu (@alexandrusoare)
- [#31312](https://github.com/apache/superset/pull/31312) refactor(Name_column): Make 'Name' column of Saved Query page into links (@LevisNgigi)
- [#31203](https://github.com/apache/superset/pull/31203) chore(deps): bump deck.gl from 9.0.34 to 9.0.36 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#31275](https://github.com/apache/superset/pull/31275) chore: relax greenlet requirements (@sadpandajoe)
- [#31205](https://github.com/apache/superset/pull/31205) chore(deps-dev): bump typescript from 5.6.3 to 5.7.2 in /docs (@dependabot[bot])
- [#31207](https://github.com/apache/superset/pull/31207) chore(deps): bump @algolia/client-search from 5.12.0 to 5.15.0 in /docs (@dependabot[bot])
- [#31208](https://github.com/apache/superset/pull/31208) chore(deps): bump less from 4.2.0 to 4.2.1 in /docs (@dependabot[bot])
- [#31204](https://github.com/apache/superset/pull/31204) chore(deps-dev): bump @docusaurus/tsconfig from 3.5.2 to 3.6.3 in /docs (@dependabot[bot])
- [#31206](https://github.com/apache/superset/pull/31206) chore(deps): bump swagger-ui-react from 5.17.14 to 5.18.2 in /docs (@dependabot[bot])
- [#31224](https://github.com/apache/superset/pull/31224) chore(deps-dev): bump @types/jest from 29.5.12 to 29.5.14 in /superset-websocket (@dependabot[bot])
- [#31228](https://github.com/apache/superset/pull/31228) chore(deps): bump @types/react-table from 7.7.19 to 7.7.20 in /superset-frontend (@dependabot[bot])
- [#31210](https://github.com/apache/superset/pull/31210) chore(deps-dev): bump @docusaurus/module-type-aliases from 3.5.2 to 3.6.3 in /docs (@dependabot[bot])
- [#31213](https://github.com/apache/superset/pull/31213) chore(deps): bump @ant-design/icons from 5.5.1 to 5.5.2 in /docs (@dependabot[bot])
- [#31230](https://github.com/apache/superset/pull/31230) chore(deps): bump @scarf/scarf from 1.3.0 to 1.4.0 in /superset-frontend (@dependabot[bot])
- [#31259](https://github.com/apache/superset/pull/31259) chore(bug report template): bump Superset versions to reflect 4.1.1 release (@sfirke)
- [#31231](https://github.com/apache/superset/pull/31231) chore(deps): bump re-resizable from 6.10.0 to 6.10.1 in /superset-frontend (@dependabot[bot])
- [#31270](https://github.com/apache/superset/pull/31270) refactor: Split SliceHeaderControls into smaller files (@kgabryje)
- [#30864](https://github.com/apache/superset/pull/30864) docs: adapt docs to suggest 'docker compose up --build' (@mistercrunch)
- [#31034](https://github.com/apache/superset/pull/31034) chore: simplify Dockerfile package install calls with bash wrappers (@mistercrunch)
- [#31214](https://github.com/apache/superset/pull/31214) chore(deps): bump codecov/codecov-action from 4 to 5 (@dependabot[bot])
- [#31250](https://github.com/apache/superset/pull/31250) chore(🦾): bump python flask-migrate subpackage(s) (@github-actions[bot])
- [#31249](https://github.com/apache/superset/pull/31249) chore(🦾): bump python nh3 0.2.18 -> 0.2.19 (@github-actions[bot])
- [#31253](https://github.com/apache/superset/pull/31253) chore(🦾): bump python pyjwt 2.10.0 -> 2.10.1 (@github-actions[bot])
- [#31254](https://github.com/apache/superset/pull/31254) chore: pin greenlet in base dependencies (@mistercrunch)
- [#31186](https://github.com/apache/superset/pull/31186) docs(contributing): how to nuke the docker-compose postgres (@mistercrunch)
- [#31244](https://github.com/apache/superset/pull/31244) perf: Optimize DashboardPage and SyncDashboardState (@kgabryje)
- [#31243](https://github.com/apache/superset/pull/31243) perf: Optimize native filters and cross filters (@kgabryje)
- [#31240](https://github.com/apache/superset/pull/31240) perf: Optimize dashboard grid components (@kgabryje)
- [#31242](https://github.com/apache/superset/pull/31242) perf: Optimize Dashboard components (@kgabryje)
- [#31241](https://github.com/apache/superset/pull/31241) perf: Optimize dashboard chart-related components (@kgabryje)
- [#31182](https://github.com/apache/superset/pull/31182) chore(Tooltip): Upgrade Tooltip to Ant Design 5 (@alexandrusoare)
- [#31193](https://github.com/apache/superset/pull/31193) refactor: Creates the VizType enum (@michael-s-molina)
- [#31165](https://github.com/apache/superset/pull/31165) docs: update slack alert instructions to work with V2 slack API (@PJDuszynski)
- [#28461](https://github.com/apache/superset/pull/28461) chore(🦾): bump python sqlglot 23.6.3 -> 23.15.8 (@github-actions[bot])
- [#31171](https://github.com/apache/superset/pull/31171) chore(🦾): bump python pyparsing 3.1.2 -> 3.2.0 (@github-actions[bot])
- [#31170](https://github.com/apache/superset/pull/31170) chore(deps): cap async_timeout<5.0.0 (@mistercrunch)
- [#31032](https://github.com/apache/superset/pull/31032) refactor: remove more sqlparse (@betodealmeida)
- [#31126](https://github.com/apache/superset/pull/31126) chore(🦾): bump python importlib-metadata 7.1.0 -> 8.5.0 (@github-actions[bot])
- [#29382](https://github.com/apache/superset/pull/29382) chore: deprecate tox in favor of act (@mistercrunch)
- [#31109](https://github.com/apache/superset/pull/31109) chore(🦾): bump python billiard 4.2.0 -> 4.2.1 (@github-actions[bot])
- [#31138](https://github.com/apache/superset/pull/31138) chore(🦾): bump python flask-limiter 3.7.0 -> 3.8.0 (@github-actions[bot])
- [#31140](https://github.com/apache/superset/pull/31140) chore(🦾): bump python mako 1.3.5 -> 1.3.6 (@github-actions[bot])
- [#31127](https://github.com/apache/superset/pull/31127) chore(🦾): bump python celery subpackage(s) (@github-actions[bot])
- [#31128](https://github.com/apache/superset/pull/31128) chore(🦾): bump python humanize 4.9.0 -> 4.11.0 (@github-actions[bot])
- [#31129](https://github.com/apache/superset/pull/31129) chore(🦾): bump python simplejson 3.19.2 -> 3.19.3 (@github-actions[bot])
- [#31130](https://github.com/apache/superset/pull/31130) chore(🦾): bump python numexpr 2.10.1 -> 2.10.2 (@github-actions[bot])
- [#31132](https://github.com/apache/superset/pull/31132) chore(🦾): bump python slack-sdk 3.27.2 -> 3.33.4 (@github-actions[bot])
- [#31133](https://github.com/apache/superset/pull/31133) chore(🦾): bump python pyopenssl 24.1.0 -> 24.2.1 (@github-actions[bot])
- [#31135](https://github.com/apache/superset/pull/31135) chore(🦾): bump python dnspython 2.6.1 -> 2.7.0 (@github-actions[bot])
- [#31136](https://github.com/apache/superset/pull/31136) chore(🦾): bump python zstandard 0.22.0 -> 0.23.0 (@github-actions[bot])
- [#31137](https://github.com/apache/superset/pull/31137) chore(🦾): bump python limits 3.12.0 -> 3.13.0 (@github-actions[bot])
- [#31139](https://github.com/apache/superset/pull/31139) chore(🦾): bump python flask-jwt-extended 4.6.0 -> 4.7.1 (@github-actions[bot])
- [#31125](https://github.com/apache/superset/pull/31125) chore(🦾): bump python gunicorn 22.0.0 -> 23.0.0 (@github-actions[bot])
- [#31124](https://github.com/apache/superset/pull/31124) chore(🦾): bump python zipp 3.19.0 -> 3.21.0 (@github-actions[bot])
- [#31123](https://github.com/apache/superset/pull/31123) chore(🦾): bump python flask-compress 1.15 -> 1.17 (@github-actions[bot])
- [#31108](https://github.com/apache/superset/pull/31108) chore(🦾): bump python dill 0.3.8 -> 0.3.9 (@github-actions[bot])
- [#31116](https://github.com/apache/superset/pull/31116) chore(🦾): bump python email-validator 2.1.1 -> 2.2.0 (@github-actions[bot])
- [#31153](https://github.com/apache/superset/pull/31153) chore(asf): add `gh-pages` to protected branches (@rusackas)
- [#31122](https://github.com/apache/superset/pull/31122) chore(🦾): bump python async-timeout 4.0.3 -> 5.0.1 (@github-actions[bot])
- [#31121](https://github.com/apache/superset/pull/31121) chore(🦾): bump python prompt-toolkit 3.0.44 -> 3.0.48 (@github-actions[bot])
- [#31119](https://github.com/apache/superset/pull/31119) chore(🦾): bump python sqlparse 0.5.0 -> 0.5.2 (@github-actions[bot])
- [#30963](https://github.com/apache/superset/pull/30963) refactor(List): Upgrade List from antdesign4 to antdesign5 (@alexandrusoare)
- [#31113](https://github.com/apache/superset/pull/31113) chore(🦾): bump python mysqlclient 2.2.4 -> 2.2.6 (@github-actions[bot])
- [#31114](https://github.com/apache/superset/pull/31114) chore(🦾): bump python grpcio-status subpackage(s) (@github-actions[bot])
- [#31112](https://github.com/apache/superset/pull/31112) chore(🦾): bump python cycler 0.11.0 -> 0.12.1 (@github-actions[bot])
- [#31091](https://github.com/apache/superset/pull/31091) chore(🦾): bump python croniter 2.0.5 -> 5.0.1 (@github-actions[bot])
- [#31107](https://github.com/apache/superset/pull/31107) chore(🦾): bump python google-auth 2.29.0 -> 2.36.0 (@github-actions[bot])
- [#31106](https://github.com/apache/superset/pull/31106) chore(🦾): bump python psutil 6.0.0 -> 6.1.0 (@github-actions[bot])
- [#31105](https://github.com/apache/superset/pull/31105) chore(🦾): bump python dnspython 2.6.1 -> 2.7.0 (@github-actions[bot])
- [#31102](https://github.com/apache/superset/pull/31102) chore(🦾): bump python markdown 3.6 -> 3.7 (@github-actions[bot])
- [#31101](https://github.com/apache/superset/pull/31101) chore(🦾): bump python pluggy 1.4.0 -> 1.5.0 (@github-actions[bot])
- [#31100](https://github.com/apache/superset/pull/31100) chore(🦾): bump python sqloxide 0.1.43 -> 0.1.51 (@github-actions[bot])
- [#31099](https://github.com/apache/superset/pull/31099) chore(🦾): bump python wheel 0.43.0 -> 0.45.1 (@github-actions[bot])
- [#31098](https://github.com/apache/superset/pull/31098) chore(🦾): bump python pyproject-api 1.6.1 -> 1.8.0 (@github-actions[bot])
- [#31096](https://github.com/apache/superset/pull/31096) chore(🦾): bump python pytest-cov 5.0.0 -> 6.0.0 (@github-actions[bot])
- [#31094](https://github.com/apache/superset/pull/31094) chore(🦾): bump python chardet 5.1.0 -> 5.2.0 (@github-actions[bot])
- [#31093](https://github.com/apache/superset/pull/31093) chore(🦾): bump python jsonpath-ng 1.6.1 -> 1.7.0 (@github-actions[bot])
- [#31092](https://github.com/apache/superset/pull/31092) chore(🦾): bump python sshtunnel subpackage(s) (@github-actions[bot])
- [#31097](https://github.com/apache/superset/pull/31097) chore(🦾): bump python mako 1.3.5 -> 1.3.6 (@github-actions[bot])
- [#31090](https://github.com/apache/superset/pull/31090) chore(🦾): bump python tomlkit 0.12.5 -> 0.13.2 (@github-actions[bot])
- [#31087](https://github.com/apache/superset/pull/31087) chore(🦾): bump python isodate 0.6.1 -> 0.7.2 (@github-actions[bot])
- [#31082](https://github.com/apache/superset/pull/31082) chore(🦾): bump python db-dtypes 1.2.0 -> 1.3.1 (@github-actions[bot])
- [#31081](https://github.com/apache/superset/pull/31081) chore(🦾): bump python trino 0.328.0 -> 0.330.0 (@github-actions[bot])
- [#31089](https://github.com/apache/superset/pull/31089) chore(🦾): bump python certifi 2024.2.2 -> 2024.8.30 (@github-actions[bot])
- [#31088](https://github.com/apache/superset/pull/31088) chore(🦾): bump python pydata-google-auth 1.7.0 -> 1.9.0 (@github-actions[bot])
- [#31086](https://github.com/apache/superset/pull/31086) chore(🦾): bump python pyproject-hooks 1.0.0 -> 1.2.0 (@github-actions[bot])
- [#31085](https://github.com/apache/superset/pull/31085) chore(🦾): bump python sqlalchemy-bigquery 1.11.0 -> 1.12.0 (@github-actions[bot])
- [#31084](https://github.com/apache/superset/pull/31084) chore(🦾): bump python kiwisolver 1.4.5 -> 1.4.7 (@github-actions[bot])
- [#31083](https://github.com/apache/superset/pull/31083) chore(🦾): bump python coverage subpackage(s) (@github-actions[bot])
- [#31077](https://github.com/apache/superset/pull/31077) chore(🦾): bump python cfgv 3.3.1 -> 3.4.0 (@github-actions[bot])
- [#31075](https://github.com/apache/superset/pull/31075) chore(🦾): bump python fonttools 4.51.0 -> 4.55.0 (@github-actions[bot])
- [#31076](https://github.com/apache/superset/pull/31076) chore(🦾): bump python pyasn1-modules 0.4.0 -> 0.4.1 (@github-actions[bot])
- [#31079](https://github.com/apache/superset/pull/31079) chore(🦾): bump python pyhive subpackage(s) (@github-actions[bot])
- [#31078](https://github.com/apache/superset/pull/31078) chore(🦾): bump python google-cloud-core 2.3.2 -> 2.4.1 (@github-actions[bot])
- [#31048](https://github.com/apache/superset/pull/31048) chore(🦾): bump python sqlalchemy-utils subpackage(s) (@github-actions[bot])
- [#31073](https://github.com/apache/superset/pull/31073) chore(🦾): bump python amqp 5.2.0 -> 5.3.1 (@github-actions[bot])
- [#31071](https://github.com/apache/superset/pull/31071) chore(🦾): bump python cachetools 5.3.3 -> 5.5.0 (@github-actions[bot])
- [#31074](https://github.com/apache/superset/pull/31074) chore(🦾): bump python kombu 5.3.7 -> 5.4.2 (@github-actions[bot])
- [#31066](https://github.com/apache/superset/pull/31066) chore(🦾): bump python pyyaml 6.0.1 -> 6.0.2 (@github-actions[bot])
- [#31068](https://github.com/apache/superset/pull/31068) chore(🦾): bump python tqdm 4.66.4 -> 4.67.1 (@github-actions[bot])
- [#31069](https://github.com/apache/superset/pull/31069) chore(🦾): bump python proto-plus 1.22.2 -> 1.25.0 (@github-actions[bot])
- [#31067](https://github.com/apache/superset/pull/31067) chore(🦾): bump python importlib-resources 6.4.0 -> 6.4.5 (@github-actions[bot])
- [#31062](https://github.com/apache/superset/pull/31062) chore(🦾): bump python apispec subpackage(s) (@github-actions[bot])
- [#31056](https://github.com/apache/superset/pull/31056) chore(🦾): bump python deprecated 1.2.14 -> 1.2.15 (@github-actions[bot])
- [#31050](https://github.com/apache/superset/pull/31050) chore(🦾): bump python pre-commit 3.7.1 -> 4.0.1 (@github-actions[bot])
- [#31064](https://github.com/apache/superset/pull/31064) chore(🦾): bump python charset-normalizer 3.3.2 -> 3.4.0 (@github-actions[bot])
- [#31001](https://github.com/apache/superset/pull/31001) chore(🦾): bump python ruff 0.4.5 -> 0.8.0 (@github-actions[bot])
- [#31049](https://github.com/apache/superset/pull/31049) chore(🦾): bump python googleapis-common-protos 1.63.0 -> 1.66.0 (@github-actions[bot])
- [#31046](https://github.com/apache/superset/pull/31046) chore(🦾): bump python cron-descriptor 1.4.3 -> 1.4.5 (@github-actions[bot])
- [#31052](https://github.com/apache/superset/pull/31052) chore(🦾): bump python flask-wtf 1.2.1 -> 1.2.2 (@github-actions[bot])
- [#31044](https://github.com/apache/superset/pull/31044) docs: updated the install process in pypi.mdx (@Rkejji)
- [#31054](https://github.com/apache/superset/pull/31054) chore(🦾): bump python nh3 0.2.17 -> 0.2.18 (@github-actions[bot])
- [#31045](https://github.com/apache/superset/pull/31045) chore(🦾): bump python marshmallow 3.21.2 -> 3.23.1 (@github-actions[bot])
- [#31041](https://github.com/apache/superset/pull/31041) chore(🦾): bump python idna 3.7 -> 3.10 (@github-actions[bot])
- [#31042](https://github.com/apache/superset/pull/31042) chore(🦾): bump python pyjwt 2.8.0 -> 2.10.0 (@github-actions[bot])
- [#31040](https://github.com/apache/superset/pull/31040) chore(🦾): bump python et-xmlfile 1.1.0 -> 2.0.0 & remove pyhive[hive] from requirements/development.in (@github-actions[bot])
- [#30651](https://github.com/apache/superset/pull/30651) chore(legacy-plugin-chart-map-box): replace viewport-mercator-project with @math.gl/web-mercator (@birkskyum)
- [#31004](https://github.com/apache/superset/pull/31004) chore(🦾): bump python pandas subpackage(s) (@github-actions[bot])
- [#31030](https://github.com/apache/superset/pull/31030) chore: Cleanup code related to MetadataBar, fix types (@kgabryje)
- [#31029](https://github.com/apache/superset/pull/31029) chore: Refactor dashboard header to func component (@kgabryje)
- [#30998](https://github.com/apache/superset/pull/30998) chore(🦾): bump python cattrs 23.2.3 -> 24.1.2 (@github-actions[bot])
- [#30867](https://github.com/apache/superset/pull/30867) docs: Update doc about CSV upload (@seiyab)
- [#30972](https://github.com/apache/superset/pull/30972) docs: Embedded sdk (@jpchev)
- [#30981](https://github.com/apache/superset/pull/30981) chore: publish wheels (@dimbleby)
- [#31000](https://github.com/apache/superset/pull/31000) chore(🦾): bump python flask-babel subpackage(s) (@github-actions[bot])
- [#31002](https://github.com/apache/superset/pull/31002) chore(🦾): bump python cffi 1.16.0 -> 1.17.1 (@github-actions[bot])
- [#31006](https://github.com/apache/superset/pull/31006) chore(🦾): bump python numexpr 2.10.0 -> 2.10.1 (@github-actions[bot])
- [#31021](https://github.com/apache/superset/pull/31021) chore: add unit tests for `is_mutating()` (@betodealmeida)
- [#30918](https://github.com/apache/superset/pull/30918) chore(helm): bumping app version to 4.1.1 in helm chart (@lodu)
- [#30948](https://github.com/apache/superset/pull/30948) chore: add performance information to tooltip (@eschutho)
- [#30970](https://github.com/apache/superset/pull/30970) build(deps): bump cross-spawn from 7.0.3 to 7.0.6 in /docs (@dependabot[bot])
- [#30969](https://github.com/apache/superset/pull/30969) build(deps): bump cross-spawn from 7.0.3 to 7.0.6 in /superset-frontend/cypress-base (@dependabot[bot])
- [#30818](https://github.com/apache/superset/pull/30818) chore(Accessibility): Fix accessibility for 'Show x entries' dropdown in tables (@LevisNgigi)
- [#30946](https://github.com/apache/superset/pull/30946) chore(docs): Update list of supported databases to include CrateDB (@amotl)
- [#30915](https://github.com/apache/superset/pull/30915) chore: update change log, UPDATING.md and bug-report.yml for 4.1 release (@sadpandajoe)
- [#29243](https://github.com/apache/superset/pull/29243) chore(deps): Migrate from `crate[sqlalchemy]` to `sqlalchemy-cratedb` (@amotl)
- [#30930](https://github.com/apache/superset/pull/30930) docs: add Free2Move to INTHEWILD.md (@PaoloTerzi)
- [#30925](https://github.com/apache/superset/pull/30925) chore(ci): add tai and michael to helm owners (@villebro)
- [#30730](https://github.com/apache/superset/pull/30730) refactor(input): Migrate Input component to Ant Design 5 (@msyavuz)
- [#30740](https://github.com/apache/superset/pull/30740) refactor(Avatar): Migrate Avatar to Ant Design 5 (@msyavuz)
- [#30806](https://github.com/apache/superset/pull/30806) build(deps): bump remark-gfm from 3.0.1 to 4.0.0 in /superset-frontend (@dependabot[bot])
- [#29545](https://github.com/apache/superset/pull/29545) chore(AntD5): touchup on component imports/exports, theming ListViewCard (@rusackas)
- [#30775](https://github.com/apache/superset/pull/30775) chore: update help text copy on dataset settings (@yousoph)
- [#30792](https://github.com/apache/superset/pull/30792) build(deps): bump @algolia/client-search from 4.24.0 to 5.12.0 in /docs (@dependabot[bot])
- [#30770](https://github.com/apache/superset/pull/30770) docs: make it more clear that GLOBAL_ASYNC_QUERIES is experimental/beta (@mistercrunch)
- [#30883](https://github.com/apache/superset/pull/30883) perf: Prevent redundant calls to getRelevantDataMask (@kgabryje)
- [#30847](https://github.com/apache/superset/pull/30847) chore(GHA): Making the Linkinator STEP non-blocking, rather than the JOB. (@rusackas)
- [#30812](https://github.com/apache/superset/pull/30812) chore(FilterBar): Filter bar accessibility (@alexandrusoare)
- [#30854](https://github.com/apache/superset/pull/30854) chore: Chart context menu permissions cleanup (@kgabryje)
- [#30255](https://github.com/apache/superset/pull/30255) chore(scripts): purge node_modules folder on `npm prune` (@rusackas)
- [#30846](https://github.com/apache/superset/pull/30846) chore(actions): Bump Linkinator in superset-docs-verify.yml (@rusackas)
- [#30797](https://github.com/apache/superset/pull/30797) build(deps): bump @docsearch/react from 3.6.2 to 3.6.3 in /docs (@dependabot[bot])
- [#30796](https://github.com/apache/superset/pull/30796) build(deps): bump @mdx-js/react from 3.0.1 to 3.1.0 in /docs (@dependabot[bot])
- [#30793](https://github.com/apache/superset/pull/30793) build(deps-dev): bump @types/react from 18.3.10 to 18.3.12 in /docs (@dependabot[bot])
- [#30795](https://github.com/apache/superset/pull/30795) build(deps-dev): bump typescript from 5.6.2 to 5.6.3 in /docs (@dependabot[bot])
- [#30799](https://github.com/apache/superset/pull/30799) build(deps): bump @saucelabs/theme-github-codeblock from 0.2.3 to 0.3.0 in /docs (@dependabot[bot])
- [#30824](https://github.com/apache/superset/pull/30824) docs: Update INTHEWILD.md with 2070Health Org (@sanjaynayak007)
- [#30838](https://github.com/apache/superset/pull/30838) chore: Revert "build(deps): bump JustinBeckwith/linkinator-action from 1.10.4 to 1.11.0" (@rusackas)
- [#30832](https://github.com/apache/superset/pull/30832) build(deps-dev): bump webpack from 5.95.0 to 5.96.1 in /docs (@dependabot[bot])
- [#30822](https://github.com/apache/superset/pull/30822) docs: Update INTHEWILD.md (@Habeeb556)
- [#30835](https://github.com/apache/superset/pull/30835) build(deps-dev): bump eslint from 9.11.0 to 9.14.0 in /superset-websocket (@dependabot[bot])
- [#30782](https://github.com/apache/superset/pull/30782) build(deps): bump uuid from 10.0.0 to 11.0.2 in /superset-websocket (@dependabot[bot])
- [#30784](https://github.com/apache/superset/pull/30784) build(deps): bump winston from 3.13.0 to 3.15.0 in /superset-websocket (@dependabot[bot])
- [#30786](https://github.com/apache/superset/pull/30786) build(deps): bump deck.gl from 9.0.28 to 9.0.34 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#30803](https://github.com/apache/superset/pull/30803) build(deps-dev): bump eslint-plugin-react from 7.33.2 to 7.37.2 in /superset-frontend (@dependabot[bot])
- [#30781](https://github.com/apache/superset/pull/30781) build(deps-dev): bump typescript-eslint from 8.8.0 to 8.12.2 in /superset-websocket (@dependabot[bot])
- [#30809](https://github.com/apache/superset/pull/30809) build(deps-dev): bump prettier-plugin-packagejson from 2.5.2 to 2.5.3 in /superset-frontend (@dependabot[bot])
- [#30817](https://github.com/apache/superset/pull/30817) build(deps): bump webpack from 5.80.0 to 5.96.1 in /superset-frontend/cypress-base (@dependabot[bot])
- [#30794](https://github.com/apache/superset/pull/30794) build(deps): bump antd from 5.20.5 to 5.21.6 in /docs (@dependabot[bot])
- [#30811](https://github.com/apache/superset/pull/30811) build(deps): bump @rjsf/validator-ajv8 from 5.19.4 to 5.22.3 in /superset-frontend (@dependabot[bot])
- [#30804](https://github.com/apache/superset/pull/30804) build(deps): bump ace-builds from 1.35.4 to 1.36.3 in /superset-frontend (@dependabot[bot])
- [#30810](https://github.com/apache/superset/pull/30810) build(deps-dev): bump eslint-plugin-testing-library from 6.2.2 to 6.4.0 in /superset-frontend (@dependabot[bot])
- [#30805](https://github.com/apache/superset/pull/30805) build(deps-dev): bump eslint-import-resolver-typescript from 3.6.1 to 3.6.3 in /superset-frontend (@dependabot[bot])
- [#30802](https://github.com/apache/superset/pull/30802) build(deps): bump JustinBeckwith/linkinator-action from 1.10.4 to 1.11.0 (@dependabot[bot])
- [#30758](https://github.com/apache/superset/pull/30758) style(databases-upload-form): update Upload Form cosmetics (@vine-trellis)
- [#30697](https://github.com/apache/superset/pull/30697) refactor: Migrate SliceAdder to typescript (@EnxDev)
- [#30731](https://github.com/apache/superset/pull/30731) refactor(Switch): Upgrade Switch to Ant Design 5 (@alexandrusoare)
- [#30757](https://github.com/apache/superset/pull/30757) docs: Adding link to StarRocks official docs (@rusackas)
- [#30747](https://github.com/apache/superset/pull/30747) docs: Update INTHEWILD.md (@MSTartan)
- [#30753](https://github.com/apache/superset/pull/30753) docs: add Sarathi to users list (@SaiSkandaTNI)
- [#30749](https://github.com/apache/superset/pull/30749) docs: Update INTHEWILD.md with Medic (@1yuv)
- [#30355](https://github.com/apache/superset/pull/30355) chore(fe): replace deprecate aliased Jest matchers with corresponding substituents (@hainenber)
- [#30536](https://github.com/apache/superset/pull/30536) build(deps): bump cookie from 0.6.0 to 0.7.0 in /superset-websocket (@dependabot[bot])
- [#30480](https://github.com/apache/superset/pull/30480) build(deps-dev): bump webpack from 5.94.0 to 5.95.0 in /docs (@dependabot[bot])
- [#30571](https://github.com/apache/superset/pull/30571) build(deps): bump cookie, cookie-parser and express in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#30738](https://github.com/apache/superset/pull/30738) docs: rename Twitter to X in the INTHEWILD.md (@wugeer)
- [#30743](https://github.com/apache/superset/pull/30743) docs(templating): Replace "true" with "1 = 1" and explain its purpose (@sfirke)
- [#30709](https://github.com/apache/superset/pull/30709) build(deps-dev): bump http-proxy-middleware from 2.0.6 to 2.0.7 in /superset-frontend (@dependabot[bot])
- [#30654](https://github.com/apache/superset/pull/30654) refactor: Migrate UndoRedoKeyListeners to typescript (@EnxDev)
- [#30653](https://github.com/apache/superset/pull/30653) refactor: Migration publishedStatus to typescript (@EnxDev)
- [#30683](https://github.com/apache/superset/pull/30683) build(deps): bump http-proxy-middleware from 2.0.6 to 2.0.7 in /docs (@dependabot[bot])
- [#30568](https://github.com/apache/superset/pull/30568) refactor: Migrate HeaderActionsDropdown to typescript (@EnxDev)
- [#30655](https://github.com/apache/superset/pull/30655) docs: frontend long build time (@CodeWithEmad)
- [#30662](https://github.com/apache/superset/pull/30662) refactor: Split FastVizSwitcher into multiple files for readability (@kgabryje)
- [#30609](https://github.com/apache/superset/pull/30609) refactor(Dashboard): Native filters form update endpoint (@geido)
- [#30613](https://github.com/apache/superset/pull/30613) chore: Enable suppressing default chart context menu (@kgabryje)
- [#30523](https://github.com/apache/superset/pull/30523) docs: Clarification on which command to use on which Ubuntu version. (@kkovacs)
- [#30599](https://github.com/apache/superset/pull/30599) chore(number-formatter): upgrade pretty-ms to 9.1.0 (@villebro)
- [#30572](https://github.com/apache/superset/pull/30572) build(deps): bump cookie, @applitools/eyes-storybook and express in /superset-frontend (@dependabot[bot])
- [#30357](https://github.com/apache/superset/pull/30357) chore(fe): uplift FE packages to latest version (@hainenber)
- [#30521](https://github.com/apache/superset/pull/30521) chore: enable lint PT009 'use regular assert over self.assert.\*' (@mistercrunch)
- [#28370](https://github.com/apache/superset/pull/28370) refactor: Migration of Chart to TypeScript (@EnxDev)
- [#30528](https://github.com/apache/superset/pull/30528) chore(fe): bump webpack-related packages to v5 (@hainenber)
- [#30526](https://github.com/apache/superset/pull/30526) chore(translations): Slovenian translation update (@dkrat7)
- [#30495](https://github.com/apache/superset/pull/30495) chore: add native filters to Covid Vaccines dashboard (@sadpandajoe)
- [#30463](https://github.com/apache/superset/pull/30463) build(deps-dev): bump typescript from 5.5.4 to 5.6.2 in /superset-websocket (@dependabot[bot])
- [#30472](https://github.com/apache/superset/pull/30472) build(deps): bump express from 4.20.0 to 4.21.0 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#30496](https://github.com/apache/superset/pull/30496) docs: fix broken links in CI (@mistercrunch)
- [#30476](https://github.com/apache/superset/pull/30476) build(deps-dev): bump typescript from 5.5.4 to 5.6.2 in /docs (@dependabot[bot])
- [#30461](https://github.com/apache/superset/pull/30461) build(deps): bump @rjsf/core from 5.19.4 to 5.21.1 in /superset-frontend (@dependabot[bot])
- [#30465](https://github.com/apache/superset/pull/30465) build(deps-dev): bump typescript-eslint from 8.6.0 to 8.8.0 in /superset-websocket (@dependabot[bot])
- [#30466](https://github.com/apache/superset/pull/30466) build(deps-dev): bump @types/node from 22.0.2 to 22.7.4 in /superset-websocket (@dependabot[bot])
- [#30467](https://github.com/apache/superset/pull/30467) build(deps): bump @types/prop-types from 15.7.5 to 15.7.13 in /superset-frontend (@dependabot[bot])
- [#30469](https://github.com/apache/superset/pull/30469) build(deps): bump @types/react-loadable from 5.5.6 to 5.5.11 in /superset-frontend (@dependabot[bot])
- [#30471](https://github.com/apache/superset/pull/30471) build(deps): bump debug from 4.3.6 to 4.3.7 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#30281](https://github.com/apache/superset/pull/30281) refactor(frontend): migrate 6 Enzyme-based tests to RTL, part 2 (@hainenber)
- [#30487](https://github.com/apache/superset/pull/30487) build(deps-dev): bump esbuild-loader from 4.1.0 to 4.2.2 in /superset-frontend (@dependabot[bot])
- [#30460](https://github.com/apache/superset/pull/30460) build(deps-dev): bump eslint-plugin-file-progress from 1.4.0 to 1.5.0 in /superset-frontend (@dependabot[bot])
- [#30459](https://github.com/apache/superset/pull/30459) build(deps-dev): bump @cypress/react from 5.12.5 to 8.0.2 in /superset-frontend (@dependabot[bot])
- [#30464](https://github.com/apache/superset/pull/30464) build(deps-dev): bump @typescript-eslint/eslint-plugin from 8.6.0 to 8.8.0 in /superset-websocket (@dependabot[bot])
- [#30477](https://github.com/apache/superset/pull/30477) build(deps): bump re-resizable from 6.9.11 to 6.10.0 in /superset-frontend (@dependabot[bot])
- [#30473](https://github.com/apache/superset/pull/30473) build(deps-dev): bump webpack-manifest-plugin from 4.1.1 to 5.0.0 in /superset-frontend (@dependabot[bot])
- [#30481](https://github.com/apache/superset/pull/30481) build(deps-dev): bump @types/react from 18.3.5 to 18.3.10 in /docs (@dependabot[bot])
- [#30483](https://github.com/apache/superset/pull/30483) build(deps): bump @docsearch/react from 3.6.1 to 3.6.2 in /docs (@dependabot[bot])
- [#30484](https://github.com/apache/superset/pull/30484) build(deps): bump handlebars from 4.7.7 to 4.7.8 in /superset-frontend (@dependabot[bot])
- [#30485](https://github.com/apache/superset/pull/30485) build(deps-dev): bump @types/yargs from 17.0.32 to 17.0.33 in /superset-frontend (@dependabot[bot])
- [#30445](https://github.com/apache/superset/pull/30445) docs(dashboard): add docs for named and index colors (@villebro)
- [#30410](https://github.com/apache/superset/pull/30410) chore: log warnings for database tables api (@eschutho)
- [#28747](https://github.com/apache/superset/pull/28747) chore: document upper bound for python lib 'holidays' >= 0.26 (@mistercrunch)
- [#30440](https://github.com/apache/superset/pull/30440) chore(Dashboard): Unblock Global Styles (@geido)
- [#30365](https://github.com/apache/superset/pull/30365) chore: add logging for dashboards/get warnings (@eschutho)
- [#30128](https://github.com/apache/superset/pull/30128) chore(View): Remove unnecessary theme view and defer basic styles (@geido)
- [#30407](https://github.com/apache/superset/pull/30407) chore: Merge description and reproduction steps in the issue template (@michael-s-molina)
- [#30305](https://github.com/apache/superset/pull/30305) chore(legacy-plugin-chart-map-box): bump supercluster to v8 (@birkskyum)
- [#30086](https://github.com/apache/superset/pull/30086) build(deps): update @emotion/react requirement from ^11.4.1 to ^11.13.3 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#27827](https://github.com/apache/superset/pull/27827) build(deps): bump @emotion/react from 11.4.1 to 11.11.4 in /superset-frontend (@dependabot[bot])
- [#28346](https://github.com/apache/superset/pull/28346) refactor: Migration of AnnotationLayerControl to TypeScript (@EnxDev)
- [#30251](https://github.com/apache/superset/pull/30251) build(deps-dev): bump sinon from 18.0.0 to 18.0.1 in /superset-frontend (@dependabot[bot])
- [#30315](https://github.com/apache/superset/pull/30315) docs: Corrected Dremio connection string (@doernemt)
- [#30352](https://github.com/apache/superset/pull/30352) chore(docs): fix an agreement error in caching docs (@sfirke)
- [#30346](https://github.com/apache/superset/pull/30346) docs: add HANA database logo in README.md (@axuew)
- [#28290](https://github.com/apache/superset/pull/28290) build(deps): update dompurify requirement from ^3.1.0 to ^3.1.2 in /superset-frontend/plugins/legacy-preset-chart-nvd3 (@dependabot[bot])
- [#30089](https://github.com/apache/superset/pull/30089) build(deps-dev): bump @storybook/react-webpack5 from 8.1.11 to 8.2.9 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#30359](https://github.com/apache/superset/pull/30359) build(websocket): upgrade ESLint to v9 (@hainenber)
- [#30084](https://github.com/apache/superset/pull/30084) build(deps): bump deck.gl from 9.0.24 to 9.0.28 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#30300](https://github.com/apache/superset/pull/30300) build(deps): bump dompurify from 3.1.0 to 3.1.3 in /superset-frontend (@dependabot[bot])
- [#30247](https://github.com/apache/superset/pull/30247) build(deps): bump path-to-regexp from 1.8.0 to 1.9.0 in /superset-frontend/cypress-base (@dependabot[bot])
- [#30337](https://github.com/apache/superset/pull/30337) docs: sql-templating (@torgge)
- [#30333](https://github.com/apache/superset/pull/30333) docs: Update cache.mdx, add needed space (@varfigstar)
- [#30123](https://github.com/apache/superset/pull/30123) chore: correct a typo (@dl57934)
- [#30262](https://github.com/apache/superset/pull/30262) chore: bump cypress to v 11 (@eschutho)
- [#30313](https://github.com/apache/superset/pull/30313) chore(UPDATING.md): Add item to UPDATING describing translations build flag (@martyngigg)
- [#30227](https://github.com/apache/superset/pull/30227) build(deps): bump express from 4.19.2 to 4.20.0 in /docs (@dependabot[bot])
- [#30032](https://github.com/apache/superset/pull/30032) docs: HTML embedding of charts/dashboards without authentication (@lindner-tj)
- [#30254](https://github.com/apache/superset/pull/30254) style(explore): clarify ambiguously named "sort by" field (@sfirke)
- [#30321](https://github.com/apache/superset/pull/30321) chore(explore): Medium font weight for section headers (@kasiazjc)
- [#30261](https://github.com/apache/superset/pull/30261) chore: remove redundant code (@villebro)
- [#25910](https://github.com/apache/superset/pull/25910) chore(deps): bump dremio deps (@gnought)
- [#30268](https://github.com/apache/superset/pull/30268) docs: Update kubernetes.mdx (@nyandajr)
- [#29771](https://github.com/apache/superset/pull/29771) chore(docker): move mysql os-level deps (GPL) to dev image only (@mistercrunch)
- [#30151](https://github.com/apache/superset/pull/30151) refactor(frontend): migrate 6 tests from Enzyme to RTL (@hainenber)
- [#30253](https://github.com/apache/superset/pull/30253) chore(build): remove extraneous prettier step in superset-frontend CI (@hainenber)
- [#30257](https://github.com/apache/superset/pull/30257) build(ci): make linkinator advisory (@rusackas)
- [#30242](https://github.com/apache/superset/pull/30242) build(deps, deps-dev): upgrade major versions for dependencies of `@superset/embedded-sdk` (@hainenber)
- [#30228](https://github.com/apache/superset/pull/30228) build(deps): bump send and express in /superset-frontend (@dependabot[bot])
- [#30229](https://github.com/apache/superset/pull/30229) build(deps): bump serve-static and express in /superset-frontend (@dependabot[bot])
- [#30232](https://github.com/apache/superset/pull/30232) refactor(explore): Migrate MetricsControl test suite to RTL (@rtexelm)
- [#30226](https://github.com/apache/superset/pull/30226) build(deps): bump serve-static and express in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#30225](https://github.com/apache/superset/pull/30225) build(deps): bump send and express in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#30091](https://github.com/apache/superset/pull/30091) build(deps): update @babel/runtime requirement from ^7.1.2 to ^7.25.6 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#25452](https://github.com/apache/superset/pull/25452) chore(frontend): Spelling (@jsoref)
- [#30103](https://github.com/apache/superset/pull/30103) build(deps-dev): update @babel/types requirement from ^7.25.2 to ^7.25.6 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#30199](https://github.com/apache/superset/pull/30199) chore(docs): Removing dead link from INTHEWILD.md (@rusackas)
- [#30101](https://github.com/apache/superset/pull/30101) build(deps-dev): bump @types/react from 18.3.3 to 18.3.5 in /docs (@dependabot[bot])
- [#30036](https://github.com/apache/superset/pull/30036) build(deps-dev): bump webpack from 5.93.0 to 5.94.0 in /docs (@dependabot[bot])
- [#30179](https://github.com/apache/superset/pull/30179) build(deps): bump antd from 5.20.0 to 5.20.5 in /docs (@dependabot[bot])
- [#30166](https://github.com/apache/superset/pull/30166) build(deps): bump @types/node from 20.12.7 to 22.5.4 in /superset-frontend (@dependabot[bot])
- [#30097](https://github.com/apache/superset/pull/30097) build(deps-dev): bump typescript from 4.9.5 to 5.5.4 in /superset-websocket (@dependabot[bot])
- [#30088](https://github.com/apache/superset/pull/30088) build(deps): bump core-js from 3.37.1 to 3.38.1 in /superset-frontend/packages/superset-ui-demo (@dependabot[bot])
- [#29963](https://github.com/apache/superset/pull/29963) build(dev-deps, deps): upgrade major versions for FE deps (@hainenber)
- [#30167](https://github.com/apache/superset/pull/30167) chore(docs): bump docusaurus from 3.4.0 to 3.5.2 (@villebro)
- [#30094](https://github.com/apache/superset/pull/30094) build(deps): bump ws and @types/ws in /superset-websocket (@dependabot[bot])
- [#30105](https://github.com/apache/superset/pull/30105) build(deps-dev): bump @docusaurus/module-type-aliases from 3.4.0 to 3.5.2 in /docs (@dependabot[bot])
- [#30111](https://github.com/apache/superset/pull/30111) build(deps): bump react-ultimate-pagination and @types/react-ultimate-pagination in /superset-frontend (@dependabot[bot])
- [#30106](https://github.com/apache/superset/pull/30106) build(deps): bump prism-react-renderer from 2.3.1 to 2.4.0 in /docs (@dependabot[bot])
- [#30107](https://github.com/apache/superset/pull/30107) build(deps-dev): bump @docusaurus/tsconfig from 3.4.0 to 3.5.2 in /docs (@dependabot[bot])
- [#30108](https://github.com/apache/superset/pull/30108) build(deps): bump react-svg-pan-zoom from 3.12.1 to 3.13.1 in /docs (@dependabot[bot])
- [#30095](https://github.com/apache/superset/pull/30095) build(deps-dev): bump ts-jest from 29.1.5 to 29.2.5 in /superset-websocket (@dependabot[bot])
- [#30096](https://github.com/apache/superset/pull/30096) build(deps): bump uuid and @types/uuid in /superset-websocket (@dependabot[bot])
- [#30143](https://github.com/apache/superset/pull/30143) build(deps): bump cryptography from 42.0.7 to 42.0.8 (@dependabot[bot])
- [#30118](https://github.com/apache/superset/pull/30118) build(deps-dev): bump prettier-plugin-packagejson from 2.4.10 to 2.5.2 in /superset-frontend (@dependabot[bot])
- [#30127](https://github.com/apache/superset/pull/30127) docs: Fixing missing 'c' in installation guide documentation (@JordanTB)
- [#30155](https://github.com/apache/superset/pull/30155) chore(docs): replace http with https (@villebro)
- [#30072](https://github.com/apache/superset/pull/30072) chore(tests): skip extremely flaky gaq test (@villebro)
- [#30153](https://github.com/apache/superset/pull/30153) chore(docs): update xendit link (@villebro)
- [#30021](https://github.com/apache/superset/pull/30021) chore: accelerate docker compose by skipping frontend build (@mistercrunch)
- [#30090](https://github.com/apache/superset/pull/30090) build(deps): bump aws-actions/amazon-ecs-deploy-task-definition from 1 to 2 (@dependabot[bot])
- [#30037](https://github.com/apache/superset/pull/30037) build(deps-dev): bump webpack from 5.76.0 to 5.94.0 in /superset-embedded-sdk (@dependabot[bot])
- [#30038](https://github.com/apache/superset/pull/30038) build(deps-dev): bump webpack from 5.93.0 to 5.94.0 in /superset-frontend (@dependabot[bot])
- [#30102](https://github.com/apache/superset/pull/30102) build(deps-dev): bump eslint-plugin-react-prefer-function-component from 0.0.7 to 3.3.0 in /superset-frontend (@dependabot[bot])
- [#30117](https://github.com/apache/superset/pull/30117) build(deps): bump d3-time-format and @types/d3-time-format in /superset-frontend (@dependabot[bot])
- [#30116](https://github.com/apache/superset/pull/30116) build(deps-dev): bump eslint-plugin-no-only-tests from 2.4.0 to 3.3.0 in /superset-frontend (@dependabot[bot])
- [#30027](https://github.com/apache/superset/pull/30027) refactor(databases): Create constants.ts, move interface to types.ts (@rtexelm)
- [#30030](https://github.com/apache/superset/pull/30030) chore(docs): docker instructions use `docker compose` instead of the deprecated `docker-compose` (@rusackas)
- [#30057](https://github.com/apache/superset/pull/30057) chore(docs): clean up a few md errors (@villebro)
- [#29586](https://github.com/apache/superset/pull/29586) chore(translations): Arabic translations (@abdilra7eem)
- [#30011](https://github.com/apache/superset/pull/30011) chore(deps): bump core-js (@rusackas)
- [#30007](https://github.com/apache/superset/pull/30007) chore(deps): bump cross-env (@rusackas)
- [#30008](https://github.com/apache/superset/pull/30008) build(deps): bump micromatch from 4.0.4 to 4.0.8 in /superset-frontend/cypress-base (@dependabot[bot])
- [#30009](https://github.com/apache/superset/pull/30009) build(deps): bump micromatch from 4.0.5 to 4.0.8 in /docs (@dependabot[bot])
- [#27832](https://github.com/apache/superset/pull/27832) build(deps): bump remark-gfm from 3.0.1 to 4.0.0 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#28292](https://github.com/apache/superset/pull/28292) build(deps): bump d3-time from 1.1.0 to 3.1.0 in /superset-frontend/packages/superset-ui-core (@dependabot[bot])
- [#29990](https://github.com/apache/superset/pull/29990) chore(init): adding link to secret key instructions (@rusackas)
- [#29947](https://github.com/apache/superset/pull/29947) build(deps): bump ws and @applitools/eyes-cypress in /superset-frontend/cypress-base (@dependabot[bot])
- [#29988](https://github.com/apache/superset/pull/29988) build(node): Bumping to Node 20 (@rusackas)
- [#25454](https://github.com/apache/superset/pull/25454) chore(tests): Spelling (@jsoref)
- [#29970](https://github.com/apache/superset/pull/29970) docs: improve pre-commit docs and discoverability when CI fails (@mistercrunch)
- [#29964](https://github.com/apache/superset/pull/29964) build(deps-dev): bump eslint-plugin-cypress from 2.11.2 to 3.4.0 in /superset-frontend + corresponding refactor (@hainenber)
- [#29969](https://github.com/apache/superset/pull/29969) chore(antd): straightening out button import paths (@rusackas)
- [#29948](https://github.com/apache/superset/pull/29948) chore(deps): bump micromatch (@rusackas)
- [#29952](https://github.com/apache/superset/pull/29952) chore: add additional code owners to migrations (@sadpandajoe)
- [#29945](https://github.com/apache/superset/pull/29945) build(deps): bump axios from 1.6.8 to 1.7.4 in /docs (@dependabot[bot])
- [#29949](https://github.com/apache/superset/pull/29949) build(deps-dev): bump axios from 1.7.3 to 1.7.4 in /superset-frontend (@dependabot[bot])
- [#29946](https://github.com/apache/superset/pull/29946) build(deps-dev): bump axios from 1.6.0 to 1.7.4 in /superset-embedded-sdk (@dependabot[bot])
- [#29904](https://github.com/apache/superset/pull/29904) chore: Changes the migrations owners (@michael-s-molina)
- [#29868](https://github.com/apache/superset/pull/29868) chore: remove useless GitHub action (@mistercrunch)
- [#29869](https://github.com/apache/superset/pull/29869) chore: remove useless GitHub action required check (@mistercrunch)
- [#29859](https://github.com/apache/superset/pull/29859) chore(deps): bumping underscore via npm override (@rusackas)
- [#29876](https://github.com/apache/superset/pull/29876) chore(docs): reorder fs users (@villebro)
- [#29841](https://github.com/apache/superset/pull/29841) chore(deps): bumping jquery (@rusackas)
- [#29870](https://github.com/apache/superset/pull/29870) docs: add unit to companies list (@amitmiran137)
- [#29652](https://github.com/apache/superset/pull/29652) chore(build): uplift several outdated frontend packages (@hainenber)
- [#29866](https://github.com/apache/superset/pull/29866) chore: pre-matrixify pre-commit check (@mistercrunch)
- [#29844](https://github.com/apache/superset/pull/29844) chore(cleanup): Removing bootstrap (experimental) (@rusackas)
- [#29863](https://github.com/apache/superset/pull/29863) chore: describe timezone issue with alerts and reports scheduler in UPDATING.md (@danielli-ziprecruiter)
- [#29855](https://github.com/apache/superset/pull/29855) perf: Lazy load rehype-raw and react-markdown (@kgabryje)
- [#29788](https://github.com/apache/superset/pull/29788) perf: Remove antd-with-locales import (@kgabryje)
- [#29791](https://github.com/apache/superset/pull/29791) perf: Lazy load moment-timezone (@kgabryje)
- [#29808](https://github.com/apache/superset/pull/29808) build(deps-dev): update @babel/types requirement from ^7.24.5 to ^7.25.2 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#29838](https://github.com/apache/superset/pull/29838) chore(deps): npm audit fix results (@rusackas)
- [#28294](https://github.com/apache/superset/pull/28294) build(deps): bump react-bootstrap-slider from 2.1.5 to 3.0.0 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#29756](https://github.com/apache/superset/pull/29756) build(deps): bump react-diff-viewer-continued from 3.2.5 to 3.4.0 in /superset-frontend (@dependabot[bot])
- [#29759](https://github.com/apache/superset/pull/29759) build(deps-dev): bump eslint-plugin-file-progress from 1.2.0 to 1.4.0 in /superset-frontend (@dependabot[bot])
- [#29812](https://github.com/apache/superset/pull/29812) build(deps): bump @fontsource/inter from 5.0.19 to 5.0.20 in /superset-frontend (@dependabot[bot])
- [#29813](https://github.com/apache/superset/pull/29813) build(deps): bump chrono-node from 2.7.5 to 2.7.6 in /superset-frontend (@dependabot[bot])
- [#29815](https://github.com/apache/superset/pull/29815) build(deps): bump mustache from 2.3.2 to 4.2.0 in /superset-frontend (@dependabot[bot])
- [#29816](https://github.com/apache/superset/pull/29816) build(deps-dev): bump @types/react-syntax-highlighter from 15.5.11 to 15.5.13 in /superset-frontend (@dependabot[bot])
- [#29820](https://github.com/apache/superset/pull/29820) build(deps-dev): bump style-loader from 3.3.4 to 4.0.0 in /superset-frontend (@dependabot[bot])
- [#29821](https://github.com/apache/superset/pull/29821) build(deps): bump memoize-one from 5.1.1 to 5.2.1 in /superset-frontend (@dependabot[bot])
- [#29809](https://github.com/apache/superset/pull/29809) build(deps-dev): bump @types/jest from 27.0.2 to 29.5.12 in /superset-websocket (@dependabot[bot])
- [#29811](https://github.com/apache/superset/pull/29811) build(deps-dev): bump @types/node from 22.0.0 to 22.0.2 in /superset-websocket (@dependabot[bot])
- [#29758](https://github.com/apache/superset/pull/29758) build(deps): bump rimraf from 3.0.2 to 6.0.1 in /superset-frontend (@dependabot[bot])
- [#29787](https://github.com/apache/superset/pull/29787) perf: Antd icons tree shaking (@kgabryje)
- [#29796](https://github.com/apache/superset/pull/29796) perf: Lazy load React Ace (@kgabryje)
- [#29792](https://github.com/apache/superset/pull/29792) chore: deleting vestigial EMAIL_NOTIFICATIONS (@rusackas)
- [#29673](https://github.com/apache/superset/pull/29673) style: remove uppercase from labels, buttons, tabs to align with design system (@mistercrunch)
- [#29755](https://github.com/apache/superset/pull/29755) build(deps): bump @types/lodash from 4.17.0 to 4.17.7 in /superset-frontend (@dependabot[bot])
- [#29765](https://github.com/apache/superset/pull/29765) build(deps-dev): bump webpack from 5.89.0 to 5.93.0 in /superset-frontend (@dependabot[bot])
- [#29794](https://github.com/apache/superset/pull/29794) chore(deps): bump dayjs to unblock CI. (@rusackas)
- [#29790](https://github.com/apache/superset/pull/29790) chore(docs): remove mention of MariaDB in dev environment setup (@sfirke)
- [#29738](https://github.com/apache/superset/pull/29738) build(deps-dev): bump @types/node from 20.13.0 to 22.0.0 in /superset-websocket (@dependabot[bot])
- [#29748](https://github.com/apache/superset/pull/29748) build(deps): bump @ant-design/icons from 5.3.7 to 5.4.0 in /docs (@dependabot[bot])
- [#29747](https://github.com/apache/superset/pull/29747) build(deps-dev): bump webpack from 5.92.1 to 5.93.0 in /docs (@dependabot[bot])
- [#29427](https://github.com/apache/superset/pull/29427) chore(deps): bump abortcontroller-polyfill from 1.2.1 to 1.7.5 in /superset-frontend (@dependabot[bot])
- [#28820](https://github.com/apache/superset/pull/28820) chore(deps): bump d3-hierarchy from 1.1.9 to 3.1.2 in /superset-frontend (@dependabot[bot])
- [#29740](https://github.com/apache/superset/pull/29740) build(deps-dev): update @types/lodash requirement from ^4.17.6 to ^4.17.7 in /superset-frontend/plugins/plugin-chart-handlebars (@dependabot[bot])
- [#29743](https://github.com/apache/superset/pull/29743) build(deps): update underscore requirement from ^1.13.6 to ^1.13.7 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#29763](https://github.com/apache/superset/pull/29763) build(deps-dev): bump history from 4.10.1 to 5.3.0 in /superset-frontend (@dependabot[bot])
- [#29760](https://github.com/apache/superset/pull/29760) build(deps-dev): bump ts-loader from 7.0.5 to 9.5.1 in /superset-frontend (@dependabot[bot])
- [#28297](https://github.com/apache/superset/pull/28297) build(deps-dev): update @babel/types requirement from ^7.24.0 to ^7.24.5 in /superset-frontend/plugins/plugin-chart-pivot-table (@dependabot[bot])
- [#29767](https://github.com/apache/superset/pull/29767) build(deps): bump fast-xml-parser from 4.2.7 to 4.4.1 in /superset-frontend (@dependabot[bot])
- [#29739](https://github.com/apache/superset/pull/29739) build(deps): bump debug from 4.3.5 to 4.3.6 in /superset-websocket/utils/client-ws-app (@dependabot[bot])
- [#29742](https://github.com/apache/superset/pull/29742) build(deps-dev): bump prettier from 3.2.5 to 3.3.3 in /superset-websocket (@dependabot[bot])
- [#29744](https://github.com/apache/superset/pull/29744) build(deps): bump deck.gl from 9.0.21 to 9.0.24 in /superset-frontend/plugins/legacy-preset-chart-deckgl (@dependabot[bot])
- [#29746](https://github.com/apache/superset/pull/29746) build(deps): bump @types/lodash from 4.17.4 to 4.17.7 in /superset-websocket (@dependabot[bot])
- [#29750](https://github.com/apache/superset/pull/29750) build(deps-dev): bump typescript from 5.5.2 to 5.5.4 in /docs (@dependabot[bot])
- [#29751](https://github.com/apache/superset/pull/29751) build(deps): bump @docsearch/react from 3.6.0 to 3.6.1 in /docs (@dependabot[bot])
- [#29753](https://github.com/apache/superset/pull/29753) build(deps-dev): bump mini-css-extract-plugin from 2.7.6 to 2.9.0 in /superset-frontend (@dependabot[bot])
- [#29754](https://github.com/apache/superset/pull/29754) build(deps-dev): bump @svgr/webpack from 8.0.1 to 8.1.0 in /superset-frontend (@dependabot[bot])
- [#29762](https://github.com/apache/superset/pull/29762) build(deps): bump ace-builds from 1.4.14 to 1.35.4 in /superset-frontend (@dependabot[bot])
- [#29731](https://github.com/apache/superset/pull/29731) chore(build): pin Storybook-related packages to 8.1.11 as further v8+ version requires React 18 (@hainenber)
- [#26557](https://github.com/apache/superset/pull/26557) build(deps-dev): bump thread-loader from 3.0.4 to 4.0.2 in /superset-frontend (@dependabot[bot])
