/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.dp;

import org.apache.sysds.parser.Statement;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.DCLocalScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.DRLocalScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.DRRLocalScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.DataPartitionLocalScheme;
import org.apache.sysds.runtime.controlprogram.paramserv.dp.ORLocalScheme;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LocalDataPartitioner {
    private DataPartitionLocalScheme _scheme;

    public LocalDataPartitioner(Statement.PSScheme scheme) {
        switch (scheme) {
            case DISJOINT_CONTIGUOUS: {
                this._scheme = new DCLocalScheme();
                break;
            }
            case DISJOINT_ROUND_ROBIN: {
                this._scheme = new DRRLocalScheme();
                break;
            }
            case DISJOINT_RANDOM: {
                this._scheme = new DRLocalScheme();
                break;
            }
            case OVERLAP_RESHUFFLE: {
                this._scheme = new ORLocalScheme();
                break;
            }
            default: {
                throw new DMLRuntimeException(String.format("LocalDataPartitioner: not support data partition scheme '%s'", new Object[]{scheme}));
            }
        }
    }

    public DataPartitionLocalScheme.Result doPartitioning(int workersNum, MatrixBlock features, MatrixBlock labels) {
        return this._scheme.doPartitioning(workersNum, features, labels);
    }
}

