/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.MatrixMatrixRelationalBinaryGPUInstruction;
import org.apache.sysds.runtime.instructions.gpu.ScalarMatrixRelationalBinaryGPUInstruction;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.MultiThreadedOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public abstract class RelationalBinaryGPUInstruction
extends GPUInstruction {
    protected RelationalBinaryGPUInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._gputype = GPUInstruction.GPUINSTRUCTION_TYPE.RelationalBinary;
    }

    public static RelationalBinaryGPUInstruction parseInstruction(String str) {
        BinaryOperator operator;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 3);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[3]);
        Types.DataType dt1 = in1.getDataType();
        Types.DataType dt2 = in2.getDataType();
        Types.DataType dt3 = out.getDataType();
        MultiThreadedOperator multiThreadedOperator = dt1 != dt2 ? InstructionUtils.parseScalarBinaryOperator(opcode, dt1 == Types.DataType.SCALAR) : (operator = InstructionUtils.parseBinaryOperator(opcode));
        if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX && dt3 == Types.DataType.MATRIX) {
            return new MatrixMatrixRelationalBinaryGPUInstruction(operator, in1, in2, out, opcode, str);
        }
        if (dt3 == Types.DataType.MATRIX && (dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.MATRIX || dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.SCALAR)) {
            return new ScalarMatrixRelationalBinaryGPUInstruction(operator, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("Unsupported GPU RelationalBinaryGPUInstruction.");
    }
}

