/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Set;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry5.internal.services.ComponentModelSource;
import org.apache.tapestry5.internal.services.PageSource;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.services.ComponentClassResolver;

public class ComponentModelSourceImpl
implements ComponentModelSource {
    private final ComponentClassResolver resolver;
    private final ComponentInstantiatorSource source;
    private final ComponentDependencyRegistry componentDependencyRegistry;
    private final PageSource pageSource;
    private final boolean multipleClassLoaders;

    public ComponentModelSourceImpl(ComponentClassResolver resolver, ComponentInstantiatorSource source, ComponentDependencyRegistry componentDependencyRegistry, PageSource pageSource, @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders) {
        this.resolver = resolver;
        this.source = source;
        this.componentDependencyRegistry = componentDependencyRegistry;
        this.pageSource = pageSource;
        this.multipleClassLoaders = !productionMode && multipleClassLoaders;
    }

    @Override
    public ComponentModel getModel(String componentClassName) {
        String superclass;
        Set<String> superclasses;
        if (this.multipleClassLoaders && this.isPage(componentClassName) && !(superclasses = this.componentDependencyRegistry.getDependencies(componentClassName, ComponentDependencyRegistry.DependencyType.SUPERCLASS)).isEmpty() && this.isPage(superclass = superclasses.iterator().next())) {
            this.getModel(superclass);
            try {
                this.pageSource.getPage(this.resolver.getLogicalName(componentClassName));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.source.getInstantiator(componentClassName).getModel();
    }

    @Override
    public ComponentModel getPageModel(String pageName) {
        return this.getModel(this.resolver.resolvePageNameToClassName(pageName));
    }

    private boolean isPage(String componentClassName) {
        return componentClassName.contains(".pages.");
    }
}

