/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.jaxrs.client.spec.ClientConfigurableImpl;
import org.apache.cxf.jaxrs.client.spec.ClientImpl;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;

public class ClientBuilderImpl
extends ClientBuilder {
    private ClientConfigurableImpl<ClientBuilder> configImpl;
    private TLSConfiguration secConfig = new TLSConfiguration();

    public ClientBuilderImpl() {
        this.configImpl = new ClientConfigurableImpl<ClientBuilderImpl>(this);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configImpl.getConfiguration();
    }

    @Override
    public ClientBuilder property(String name, Object value) {
        return (ClientBuilder)this.configImpl.property(name, value);
    }

    @Override
    public ClientBuilder register(Class<?> cls) {
        return (ClientBuilder)this.configImpl.register(cls);
    }

    @Override
    public ClientBuilder register(Object object) {
        return (ClientBuilder)this.configImpl.register(object);
    }

    @Override
    public ClientBuilder register(Class<?> cls, int index) {
        return (ClientBuilder)this.configImpl.register(cls, index);
    }

    @Override
    public ClientBuilder register(Class<?> cls, Class<?> ... contracts) {
        return (ClientBuilder)this.configImpl.register(cls, contracts);
    }

    @Override
    public ClientBuilder register(Class<?> cls, Map<Class<?>, Integer> map) {
        return (ClientBuilder)this.configImpl.register(cls, map);
    }

    @Override
    public ClientBuilder register(Object object, int index) {
        return (ClientBuilder)this.configImpl.register(object, index);
    }

    @Override
    public ClientBuilder register(Object object, Class<?> ... contracts) {
        return (ClientBuilder)this.configImpl.register(object, contracts);
    }

    @Override
    public ClientBuilder register(Object object, Map<Class<?>, Integer> map) {
        return (ClientBuilder)this.configImpl.register(object, map);
    }

    @Override
    public Client build() {
        return new ClientImpl(this.configImpl.getConfiguration(), this.secConfig){

            @Override
            public void close() {
                super.close();
                ClientBuilderImpl.this.configImpl.close();
            }
        };
    }

    @Override
    public ClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.secConfig.getTlsClientParams().setHostnameVerifier(verifier);
        return this;
    }

    @Override
    public ClientBuilder sslContext(SSLContext sslContext) {
        this.secConfig.getTlsClientParams().setKeyManagers(null);
        this.secConfig.getTlsClientParams().setTrustManagers(null);
        this.secConfig.setSslContext(sslContext);
        return this;
    }

    @Override
    public ClientBuilder keyStore(KeyStore store, char[] password) {
        this.secConfig.setSslContext(null);
        try {
            KeyManagerFactory tmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            tmf.init(store, password);
            this.secConfig.getTlsClientParams().setKeyManagers(tmf.getKeyManagers());
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
        return this;
    }

    @Override
    public ClientBuilder trustStore(KeyStore store) {
        this.secConfig.setSslContext(null);
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(store);
            this.secConfig.getTlsClientParams().setTrustManagers(tmf.getTrustManagers());
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
        return this;
    }

    @Override
    public ClientBuilder withConfig(Configuration cfg) {
        if (cfg.getRuntimeType() != RuntimeType.CLIENT) {
            throw new IllegalArgumentException();
        }
        this.configImpl = new ClientConfigurableImpl<ClientBuilderImpl>(this, cfg);
        return this;
    }

    @Override
    public ClientBuilder executorService(ExecutorService executorService) {
        return (ClientBuilder)this.configImpl.property("executorService", executorService);
    }

    @Override
    public ClientBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return (ClientBuilder)this.configImpl.property("scheduledExecutorService", scheduledExecutorService);
    }

    @Override
    public ClientBuilder connectTimeout(long timeout, TimeUnit timeUnit) {
        this.validateTimeout(timeout);
        return this.property("http.connection.timeout", timeUnit.toMillis(timeout));
    }

    @Override
    public ClientBuilder readTimeout(long timeout, TimeUnit timeUnit) {
        this.validateTimeout(timeout);
        return this.property("http.receive.timeout", timeUnit.toMillis(timeout));
    }

    private void validateTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout is not allowed.");
        }
    }
}

