/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class LinkBuilderImpl
implements Link.Builder {
    private static final String DOUBLE_QUOTE = "\"";
    private UriBuilder ub;
    private URI baseUri;
    private Map<String, String> params = new HashMap<String, String>(6);

    @Override
    public Link build(Object ... values) {
        URI resolvedLinkUri = this.getResolvedUri(values);
        return new LinkImpl(resolvedLinkUri, new HashMap<String, String>(this.params));
    }

    @Override
    public Link buildRelativized(URI requestUri, Object ... values) {
        URI resolvedLinkUri = this.getResolvedUri(values);
        URI relativized = HttpUtils.relativize(requestUri, resolvedLinkUri);
        return new LinkImpl(relativized, new HashMap<String, String>(this.params));
    }

    private URI getResolvedUri(Object ... values) {
        URI uri;
        if (this.ub == null) {
            this.ub = new UriBuilderImpl();
            if (this.baseUri != null) {
                this.ub.uri(this.baseUri);
            }
        }
        if (!(uri = this.ub.build(values)).isAbsolute() && this.baseUri != null && this.baseUri.isAbsolute()) {
            UriBuilder linkUriBuilder = UriBuilder.fromUri(this.baseUri);
            return HttpUtils.resolve(linkUriBuilder, uri);
        }
        return uri;
    }

    @Override
    public Link.Builder link(Link link) {
        this.ub = UriBuilder.fromLink(link);
        this.params.putAll(link.getParams());
        return this;
    }

    @Override
    public Link.Builder link(String link) {
        String[] tokens;
        int index;
        if ((link = link.trim()).length() > 1 && link.startsWith("<") && (index = link.lastIndexOf(62, link.length())) != -1) {
            String uri = link.substring(1, index);
            this.ub = UriBuilder.fromUri(uri);
            link = index + 1 == link.length() ? "" : link.substring(index + 1);
        }
        for (String token : tokens = link.split(";")) {
            int i;
            String theToken = token.trim();
            if (theToken.isEmpty() || (i = theToken.indexOf(61)) == -1) continue;
            String name = theToken.substring(0, i);
            String value = this.stripQuotes(theToken.substring(i + 1));
            this.params.put(name, value);
        }
        return this;
    }

    @Override
    public Link.Builder param(String name, String value) {
        this.checkNotNull(name);
        this.checkNotNull(value);
        this.params.put(name, value);
        return this;
    }

    @Override
    public Link.Builder rel(String rel) {
        String exisingRel = this.params.get("rel");
        String newRel = exisingRel == null ? rel : exisingRel + " " + rel;
        return this.param("rel", newRel);
    }

    @Override
    public Link.Builder title(String title) {
        return this.param("title", title);
    }

    @Override
    public Link.Builder type(String type) {
        return this.param("type", type);
    }

    @Override
    public Link.Builder uri(URI uri) {
        this.ub = UriBuilder.fromUri(uri);
        return this;
    }

    @Override
    public Link.Builder uri(String uri) {
        this.ub = UriBuilder.fromUri(uri);
        return this;
    }

    @Override
    public Link.Builder uriBuilder(UriBuilder builder) {
        this.ub = builder;
        return this;
    }

    private String stripQuotes(String value) {
        return value.replaceAll(DOUBLE_QUOTE, "");
    }

    private void checkNotNull(String value) {
        if (value == null) {
            throw new IllegalArgumentException(value);
        }
    }

    @Override
    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    @Override
    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }

    static class LinkImpl
    extends Link {
        private static final Set<String> MAIN_PARAMETERS = new HashSet<String>(Arrays.asList("rel", "title", "type"));
        private URI uri;
        private Map<String, String> params;

        LinkImpl(URI uri, Map<String, String> params) {
            this.uri = uri;
            this.params = params;
        }

        @Override
        public Map<String, String> getParams() {
            return Collections.unmodifiableMap(this.params);
        }

        @Override
        public String getRel() {
            return this.params.get("rel");
        }

        @Override
        public List<String> getRels() {
            String rel = this.getRel();
            if (rel == null) {
                return Collections.emptyList();
            }
            String[] values = rel.split(" ");
            ArrayList<String> rels = new ArrayList<String>(values.length);
            for (String val : values) {
                rels.add(val.trim());
            }
            return rels;
        }

        @Override
        public String getTitle() {
            return this.params.get("title");
        }

        @Override
        public String getType() {
            return this.params.get("type");
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        @Override
        public UriBuilder getUriBuilder() {
            return UriBuilder.fromUri(this.uri);
        }

        @Override
        public String toString() {
            String type;
            String title;
            StringBuilder sb = new StringBuilder();
            sb.append('<').append(this.uri.toString()).append('>');
            String rel = this.getRel();
            if (rel != null) {
                sb.append(';').append("rel").append("=\"").append(rel).append('\"');
            }
            if ((title = this.getTitle()) != null) {
                sb.append(';').append("title").append("=\"").append(title).append('\"');
            }
            if ((type = this.getType()) != null) {
                sb.append(';').append("type").append("=\"").append(type).append('\"');
            }
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                if (MAIN_PARAMETERS.contains(entry.getKey())) continue;
                sb.append(';').append(entry.getKey()).append("=\"").append(entry.getValue()).append('\"');
            }
            return sb.toString();
        }

        public int hashCode() {
            return this.uri.hashCode() + 37 * this.params.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Link) {
                Link other = (Link)o;
                return this.uri.equals(other.getUri()) && this.getParams().equals(other.getParams());
            }
            return false;
        }
    }
}

