/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.nio;

import jakarta.servlet.ReadListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.AsyncResponse;
import org.apache.cxf.jaxrs.nio.NioErrorHandler;
import org.apache.cxf.jaxrs.nio.NioReadCompletionHandler;
import org.apache.cxf.jaxrs.nio.NioReadHandler;
import org.apache.cxf.jaxrs.nio.NioReadListenerImpl;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class NioReadEntity {
    private final NioReadHandler reader;
    private final NioReadCompletionHandler completion;
    private final NioErrorHandler error;

    public NioReadEntity(NioReadHandler reader, NioReadCompletionHandler completion) {
        this(reader, completion, null);
    }

    public NioReadEntity(NioReadHandler reader, NioReadCompletionHandler completion, NioErrorHandler error) {
        this.reader = reader;
        this.completion = completion;
        this.error = error;
        Message m = JAXRSUtils.getCurrentMessage();
        try {
            if (m.get(AsyncResponse.class) == null) {
                throw new IllegalStateException("AsyncResponse is not available");
            }
            HttpServletRequest request = (HttpServletRequest)m.get("HTTP.REQUEST");
            request.getInputStream().setReadListener((ReadListener)new NioReadListenerImpl(this, request.getInputStream()));
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to initialize NIO entity", ex);
        }
    }

    public NioReadHandler getReader() {
        return this.reader;
    }

    public NioReadCompletionHandler getCompletion() {
        return this.completion;
    }

    public NioErrorHandler getError() {
        return this.error;
    }
}

