/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.security;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.claims.ClaimBean;
import org.apache.cxf.rt.security.claims.interceptor.ClaimsAuthorizingInterceptor;

public class ClaimsAuthorizingFilter
implements ContainerRequestFilter {
    private ClaimsAuthorizingInterceptor interceptor;

    public ClaimsAuthorizingFilter() {
        this.interceptor = new ClaimsAuthorizingInterceptor();
    }

    public ClaimsAuthorizingFilter(ClaimsAuthorizingInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public void filter(ContainerRequestContext context) {
        Message message = JAXRSUtils.getCurrentMessage();
        try {
            this.interceptor.handleMessage(message);
        }
        catch (AccessDeniedException ex) {
            context.abortWith(Response.status(Response.Status.FORBIDDEN).build());
        }
    }

    @Deprecated
    public void setClaims(Map<String, List<ClaimBean>> claimsMap) {
        this.interceptor.setClaims(claimsMap);
    }

    @Deprecated
    public void setSecuredObject(Object securedObject) {
        this.interceptor.setSecuredObject(securedObject);
    }
}

