/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.j2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.sis.geometry.wrapper.j2d.FlatShape;
import org.apache.sis.geometry.wrapper.j2d.Polyline;
import org.apache.sis.referencing.util.j2d.IntervalRectangle;
import org.apache.sis.util.Classes;

final class MultiPolylines
extends FlatShape {
    private final Polyline[] polylines;

    public MultiPolylines(Polyline[] polylines) {
        super(new IntervalRectangle());
        this.polylines = polylines;
        this.bounds.setRect(polylines[0].bounds);
        for (int i = 1; i < polylines.length; ++i) {
            this.bounds.add(polylines[i].bounds);
        }
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.bounds.contains(x, y)) {
            for (Polyline p : this.polylines) {
                if (!p.contains(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (this.bounds.intersects(x, y, w, h)) {
            for (Polyline p : this.polylines) {
                if (!p.intersects(x, y, w, h)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        if (this.bounds.intersects(r)) {
            for (Polyline p : this.polylines) {
                if (!p.intersects(r)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (this.bounds.contains(x, y, w, h)) {
            for (Polyline p : this.polylines) {
                if (!p.contains(x, y, w, h)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        if (this.bounds.contains(r)) {
            for (Polyline p : this.polylines) {
                if (!p.contains(r)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        Iterator<Polyline> it = Arrays.asList(this.polylines).iterator();
        return it.hasNext() ? new Polyline.Iter(at, it.next(), it) : new Polyline.Iter();
    }

    @Override
    public FlatShape fastClip(Rectangle2D areaOfInterest) {
        if (this.bounds.intersects(areaOfInterest)) {
            Polyline[] clipped = new Polyline[this.polylines.length];
            int count = 0;
            for (Polyline p : this.polylines) {
                if (!p.bounds.intersects(areaOfInterest)) continue;
                clipped[count++] = p;
            }
            if (count != 0) {
                if (count == this.polylines.length) {
                    return this;
                }
                return new MultiPolylines(Arrays.copyOf(clipped, count));
            }
        }
        return null;
    }

    public String toString() {
        return Classes.getShortClassName(this) + "[" + this.polylines.length / 2 + " polylines]";
    }
}

