/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.io.stream.ChannelImageInputStream;
import org.apache.sis.io.stream.ChannelImageOutputStream;
import org.apache.sis.io.stream.InputStreamAdapter;
import org.apache.sis.io.stream.OutputStreamAdapter;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class IOUtilities
extends Static {
    public static final String CURRENT_DIRECTORY_SYMBOL = ".";

    private IOUtilities() {
    }

    public static boolean isKindOfPath(Object path) {
        return path instanceof URI || path instanceof URL || path instanceof Path || path instanceof File || path instanceof CharSequence;
    }

    public static String filename(Object path) {
        return IOUtilities.part(path, false);
    }

    public static String extension(Object path) {
        return IOUtilities.part(path, true);
    }

    private static String part(Object path, boolean extension) {
        int end;
        String name;
        int fromIndex = 0;
        if (path instanceof File) {
            name = ((File)path).getName();
            end = name.length();
        } else if (path instanceof Path) {
            name = ((Path)path).getFileName().toString();
            end = name.length();
        } else {
            int separator = 47;
            if (path instanceof URL) {
                name = ((URL)path).getPath();
            } else if (path instanceof URI) {
                URI uri = (URI)path;
                name = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
            } else if (path instanceof CharSequence) {
                name = path.toString();
                separator = File.separatorChar;
            } else {
                return null;
            }
            end = name.length();
            do {
                if (--end < 0) {
                    return "";
                }
                fromIndex = name.lastIndexOf(47, end);
                if (separator == 47) continue;
                fromIndex = Math.max(fromIndex, name.lastIndexOf(separator, end));
            } while (fromIndex == end);
            ++fromIndex;
            ++end;
        }
        if (extension && (fromIndex = CharSequences.lastIndexOf(name, 46, fromIndex, end) + 1) <= 1) {
            return "";
        }
        return name.substring(fromIndex, end);
    }

    public static String toString(Object path) {
        if (path instanceof CharSequence || path instanceof Path || path instanceof URL || path instanceof URI) {
            return path.toString();
        }
        if (path instanceof File) {
            return ((File)path).getPath();
        }
        return null;
    }

    public static URI toAuxiliaryURI(URI location, String extension) throws URISyntaxException {
        if (location == null || !location.isAbsolute() || location.isOpaque()) {
            return null;
        }
        Object path = location.getRawPath();
        int s = ((String)path).indexOf(63);
        if (s < 0 && (s = ((String)path).indexOf(35)) < 0) {
            s = ((String)path).length();
        }
        path = (s = ((String)path).lastIndexOf(46, s)) >= 0 ? ((String)path).substring(0, s + 1) + extension : (String)path + CURRENT_DIRECTORY_SYMBOL + extension;
        return new URI(location.getScheme(), location.getRawAuthority(), (String)path, null, null);
    }

    public static String filenameWithoutExtension(String path) {
        if (path != null) {
            int e;
            int s = path.lastIndexOf(File.separatorChar);
            if (s < 0 && File.separatorChar != '/') {
                s = path.lastIndexOf(47);
            }
            if ((e = path.lastIndexOf(46)) <= ++s) {
                e = path.length();
            }
            path = path.substring(s, e);
        }
        return path;
    }

    public static String encodeURI(String path) {
        int n;
        if (path == null) {
            return null;
        }
        StringBuilder buffer = null;
        int length = path.length();
        for (int i = 0; i < length; i += n) {
            int c = path.codePointAt(i);
            n = Character.charCount(c);
            if (!Character.isSpaceChar(c) && !Character.isISOControl(c) && c != 37) {
                if (buffer == null) continue;
                buffer.appendCodePoint(c);
                continue;
            }
            if (buffer == null) {
                buffer = new StringBuilder(path);
                buffer.setLength(i);
            }
            for (byte b : path.substring(i, i + n).getBytes(StandardCharsets.UTF_8)) {
                buffer.append('%');
                String hex = Integer.toHexString(Byte.toUnsignedInt(b)).toUpperCase(Locale.ROOT);
                if (hex.length() < 2) {
                    buffer.append('0');
                }
                buffer.append(hex);
            }
        }
        return buffer != null ? buffer.toString() : path;
    }

    public static URL toURL(String url, String encoding) throws IOException {
        if (url == null) {
            return null;
        }
        if (encoding != null) {
            url = URLDecoder.decode(url, encoding);
        }
        url = IOUtilities.encodeURI(url);
        try {
            return new URI(url).parseServerAuthority().toURL();
        }
        catch (IllegalArgumentException | URISyntaxException cause) {
            throw (MalformedURLException)new MalformedURLException(IOUtilities.malformed(url, cause)).initCause(cause);
        }
    }

    public static URI toURI(URL url, String encoding) throws IOException {
        String specified;
        if (url == null) {
            return null;
        }
        String path = specified = url.toExternalForm();
        if (encoding != null) {
            path = URLDecoder.decode(path, encoding);
        }
        path = IOUtilities.encodeURI(path);
        try {
            return path.equals(specified) ? url.toURI() : new URI(path);
        }
        catch (URISyntaxException cause) {
            throw (MalformedURLException)new MalformedURLException(IOUtilities.malformed(url, cause)).initCause(cause);
        }
    }

    public static File toFile(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException | URISyntaxException cause) {
            throw new IOException(IOUtilities.malformed(url, cause), cause);
        }
    }

    private static String malformed(Object url, Exception cause) {
        return Exceptions.formatChainedMessages(null, Errors.format((short)45, "URL", url), cause);
    }

    public static Path toPath(URL url, String encoding) throws IOException {
        if (url == null) {
            return null;
        }
        URI uri = IOUtilities.toURI(url, encoding);
        try {
            return Path.of(uri);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException cause) {
            IOException e;
            String message = IOUtilities.malformed(url, cause);
            if (cause instanceof IllegalArgumentException) {
                e = new MalformedURLException(message);
                e.initCause(cause);
            } else {
                e = new IOException(message, cause);
            }
            throw e;
        }
    }

    public static Object toFileOrURL(String path, String encoding) throws IOException {
        int s;
        if (path == null) {
            return null;
        }
        if (path.indexOf(63) < 0 && path.indexOf(35) < 0 && ((s = path.indexOf(58)) < 0 || s == 1 && Character.isLetter(path.charAt(0)) && !path.startsWith("//", 2))) {
            return new File(path);
        }
        URL url = IOUtilities.toURL(path, encoding);
        String scheme = url.getProtocol();
        if (scheme != null && scheme.equalsIgnoreCase("file")) {
            return IOUtilities.toFile(url);
        }
        return url;
    }

    public static Path toPathOrNull(Object path) {
        if (path instanceof Path) {
            return (Path)path;
        }
        if (path instanceof File) {
            return ((File)path).toPath();
        }
        if (path instanceof URI) {
            return Path.of((URI)path);
        }
        if (path instanceof CharSequence) {
            return Path.of(path.toString(), new String[0]);
        }
        return null;
    }

    public static InputStream toInputStream(AutoCloseable stream) throws IOException {
        if (stream != null) {
            if (stream instanceof InputStream) {
                return (InputStream)stream;
            }
            if (stream instanceof OutputStreamAdapter) {
                stream = ((OutputStreamAdapter)stream).output;
            }
            if (stream instanceof ChannelDataOutput) {
                ChannelDataOutput c = (ChannelDataOutput)((Object)stream);
                if (c.channel instanceof ReadableByteChannel) {
                    stream = new ChannelImageInputStream(c.filename, (ReadableByteChannel)((Object)c.channel), c.buffer, true);
                }
            }
            if (stream instanceof ImageInputStream) {
                return new InputStreamAdapter((ImageInputStream)stream);
            }
        }
        return null;
    }

    public static OutputStream toOutputStream(AutoCloseable stream) throws IOException {
        if (stream != null) {
            if (stream instanceof OutputStream) {
                return (OutputStream)stream;
            }
            if (stream instanceof InputStreamAdapter) {
                stream = ((InputStreamAdapter)stream).input;
            }
            if (stream instanceof ChannelDataInput) {
                ChannelDataInput c = (ChannelDataInput)((Object)stream);
                if (c.channel instanceof WritableByteChannel) {
                    stream = new ChannelImageOutputStream(c.filename, (WritableByteChannel)((Object)c.channel), c.buffer);
                }
            }
            if (stream instanceof ChannelImageOutputStream) {
                return new OutputStreamAdapter((ChannelImageOutputStream)stream);
            }
        }
        return null;
    }

    public static boolean truncate(AutoCloseable stream) throws IOException {
        if (stream instanceof OutputStreamAdapter) {
            stream = ((OutputStreamAdapter)stream).output;
        }
        if (stream instanceof ChannelDataOutput) {
            stream = ((ChannelDataOutput)((Object)stream)).channel;
        }
        if (stream instanceof SeekableByteChannel) {
            SeekableByteChannel s = (SeekableByteChannel)stream;
            s.truncate(s.position());
            return true;
        }
        return false;
    }

    public static boolean isWriteOnly(Object output) {
        if (output instanceof DataInput || output instanceof ReadableByteChannel) {
            return false;
        }
        return output instanceof OutputStream || output instanceof DataOutput || output instanceof ChannelDataOutput || output instanceof WritableByteChannel;
    }

    public static boolean isWrite(OpenOption[] options) {
        boolean isRead = false;
        boolean isWrite = false;
        boolean truncate = false;
        if (options != null) {
            block5: for (OpenOption op : options) {
                if (!(op instanceof StandardOpenOption)) continue;
                switch ((StandardOpenOption)op) {
                    case READ: {
                        isRead = true;
                        continue block5;
                    }
                    case WRITE: {
                        isWrite = true;
                        continue block5;
                    }
                    case CREATE_NEW: 
                    case TRUNCATE_EXISTING: {
                        truncate = true;
                    }
                }
            }
        }
        return isWrite & (!isRead | truncate);
    }

    public static boolean isHTTP(String protocol) {
        return "http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol);
    }

    public static int readCodePoint(Reader in) throws IOException {
        int c = in.read();
        while (c >= 55296 && c <= 56319) {
            int low = in.read();
            if (low >= 56320 && low <= 57343) {
                c = Character.toCodePoint((char)c, (char)low);
                break;
            }
            c = low;
        }
        return c;
    }

    public static String canNotReadFile(Locale locale, String format, String filename, Object store) {
        Object[] parameters = IOUtilities.errorMessageParameters(format, filename, store);
        return Resources.forLocale(locale).getString(IOUtilities.errorMessageKey(parameters), parameters);
    }

    public static short errorMessageKey(Object[] parameters) {
        return (short)(parameters.length == 2 ? 1 : (parameters.length == 3 ? 2 : 3));
    }

    public static Object[] errorMessageParameters(String format, String filename, Object store) {
        int line = 0;
        int column = 0;
        if (store instanceof XMLStreamReader) {
            Location location = ((XMLStreamReader)store).getLocation();
            line = location.getLineNumber() + 1;
            column = location.getColumnNumber() + 1;
        } else if (store instanceof LineNumberReader) {
            line = ((LineNumberReader)store).getLineNumber();
        }
        Object[] params = new Object[line == 0 ? 2 : (column == 0 ? 3 : 4)];
        switch (params.length) {
            default: {
                params[3] = column;
            }
            case 3: {
                params[2] = line;
            }
            case 2: {
                params[1] = filename;
            }
            case 1: {
                params[0] = format;
            }
            case 0: 
        }
        return params;
    }
}

