/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import javax.measure.Unit;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbridgedMolodensky;
import org.apache.sis.referencing.operation.provider.Molodensky;
import org.apache.sis.referencing.operation.transform.AbridgedMolodenskyTransform2D;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.MolodenskyFormula;
import org.apache.sis.referencing.operation.transform.MolodenskyTransform2D;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class MolodenskyTransform
extends MolodenskyFormula {
    private static final long serialVersionUID = 7206439437113286122L;
    private static ParameterDescriptorGroup DESCRIPTOR;
    private final MolodenskyTransform inverse;

    public MolodenskyTransform(Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, double tX, double tY, double tZ, boolean isAbridged) {
        super(source, isSource3D, target, isTarget3D, tX, tY, tZ, null, isAbridged, isAbridged ? AbridgedMolodensky.PARAMETERS : Molodensky.PARAMETERS);
        this.inverse = !isSource3D && !isTarget3D ? (isAbridged && tX == 0.0 && tY == 0.0 && tZ == 0.0 ? new AbridgedMolodenskyTransform2D(this, source, target) : new MolodenskyTransform2D(this, source, target)) : new MolodenskyTransform(this, source, target);
    }

    MolodenskyTransform(MolodenskyTransform inverse, Ellipsoid source, Ellipsoid target) {
        super(inverse, source, target, inverse.context.getDescriptor());
        this.inverse = inverse;
    }

    @Override
    final void completeParameters(Parameters pg, double semiMinor, Unit<?> unit, double \u0394f) {
        if (Double.isNaN(\u0394f)) {
            \u0394f = this.context.doubleValue(Molodensky.FLATTENING_DIFFERENCE);
        }
        super.completeParameters(pg, semiMinor, unit, \u0394f);
        pg.getOrCreate(Molodensky.TX).setValue(this.tX, unit);
        pg.getOrCreate(Molodensky.TY).setValue(this.tY, unit);
        pg.getOrCreate(Molodensky.TZ).setValue(this.tZ, unit);
        pg.getOrCreate(Molodensky.AXIS_LENGTH_DIFFERENCE).setValue(this.\u0394a, unit);
        pg.getOrCreate(Molodensky.FLATTENING_DIFFERENCE).setValue(\u0394f, Units.UNITY);
        if (pg != this.context) {
            pg.parameter("abridged").setValue(this.isAbridged);
        }
    }

    public static MathTransform createGeodeticTransformation(MathTransformFactory factory, Ellipsoid source, boolean isSource3D, Ellipsoid target, boolean isTarget3D, double tX, double tY, double tZ, boolean isAbridged) throws FactoryException {
        MolodenskyTransform tr = !isSource3D && !isTarget3D ? (isAbridged && tX == 0.0 && tY == 0.0 && tZ == 0.0 ? new AbridgedMolodenskyTransform2D(source, target) : new MolodenskyTransform2D(source, target, tX, tY, tZ, isAbridged)) : new MolodenskyTransform(source, isSource3D, target, isTarget3D, tX, tY, tZ, isAbridged);
        tr.inverse.context.completeTransform(factory, null);
        return tr.context.completeTransform(factory, tr);
    }

    @Override
    public boolean isIdentity() {
        return this.tX == 0.0 && this.tY == 0.0 && this.tZ == 0.0 && this.\u0394a == 0.0 && this.\u0394fmod == 0.0 && this.getSourceDimensions() == this.getTargetDimensions();
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        return this.transform(srcPts[srcOff], srcPts[srcOff + 1], this.isSource3D ? srcPts[srcOff + 2] : 0.0, dstPts, dstOff, this.tX, this.tY, this.tZ, null, derivate);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int srcInc = 0;
        int dstInc = 0;
        int offFinal = 0;
        double[] dstFinal = null;
        if (srcPts == dstPts) {
            int srcDim = this.isSource3D ? 3 : 2;
            int dstDim = this.isTarget3D ? 3 : 2;
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -2 * srcDim;
                    dstInc = -2 * dstDim;
                    break;
                }
                default: {
                    int upper = srcOff + numPts * srcDim;
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, upper);
                    srcOff = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dstFinal = dstPts;
                    dstPts = new double[numPts * dstDim];
                    offFinal = dstOff;
                    dstOff = 0;
                }
            }
        }
        while (--numPts >= 0) {
            double \u03bb = srcPts[srcOff++];
            double \u03c6 = srcPts[srcOff++];
            double h = this.isSource3D ? srcPts[srcOff++] : 0.0;
            double sin\u03bb = Math.sin(\u03bb);
            double cos\u03bb = Math.cos(\u03bb);
            double sin\u03c6 = Math.sin(\u03c6);
            double cos\u03c6 = Math.cos(\u03c6);
            double sin2\u03c6 = sin\u03c6 * sin\u03c6;
            double \u03c1den = 1.0 - this.eccentricitySquared * sin2\u03c6;
            double \u03bdden = Math.sqrt(\u03c1den);
            double \u03c1 = this.semiMajor * (1.0 - this.eccentricitySquared) / (\u03c1den *= \u03bdden);
            double \u03bd = this.semiMajor / \u03bdden;
            double t = this.\u0394fmod * 2.0;
            if (!this.isAbridged) {
                \u03c1 += h;
                \u03bd += h;
                t = t * (0.5 / \u03bdden + 0.5 / \u03c1den) + this.\u0394a * this.eccentricitySquared / \u03bdden;
            }
            double spc\u03bb = this.tY * sin\u03bb + this.tX * cos\u03bb;
            dstPts[dstOff++] = \u03bb + 1.0000000000039175 * (this.tY * cos\u03bb - this.tX * sin\u03bb) / (\u03bd * cos\u03c6);
            dstPts[dstOff++] = \u03c6 + 1.0000000000039175 * ((t * cos\u03c6 - spc\u03bb) * sin\u03c6 + this.tZ * cos\u03c6) / \u03c1;
            if (this.isTarget3D) {
                t = this.\u0394fmod * sin2\u03c6;
                double d = this.\u0394a;
                if (!this.isAbridged) {
                    t /= \u03bdden;
                    d *= \u03bdden;
                }
                dstPts[dstOff++] = h + spc\u03bb * cos\u03c6 + this.tZ * sin\u03c6 + t - d;
            }
            srcOff += srcInc;
            dstOff += dstInc;
        }
        if (dstFinal != null) {
            System.arraycopy(dstPts, 0, dstFinal, offFinal, dstPts.length);
        }
    }

    @Override
    public MathTransform inverse() {
        return this.inverse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        Class<MolodenskyTransform> clazz = MolodenskyTransform.class;
        synchronized (MolodenskyTransform.class) {
            if (DESCRIPTOR == null) {
                DESCRIPTOR = Molodensky.internal();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DESCRIPTOR;
        }
    }
}

