/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class DateDiffStep<S>
extends ScalarMapStep<S, Long>
implements TraversalParent {
    private OffsetDateTime value;
    private Traversal.Admin<S, OffsetDateTime> dateTraversal;

    public DateDiffStep(Traversal.Admin traversal, OffsetDateTime value) {
        super(traversal);
        this.value = value;
    }

    public DateDiffStep(Traversal.Admin traversal, Traversal<?, OffsetDateTime> dateTraversal) {
        super(traversal);
        this.dateTraversal = this.integrateChild(dateTraversal.asAdmin());
    }

    @Override
    protected Long map(Traverser.Admin<S> traverser) {
        Object object = traverser.get();
        if (!(object instanceof OffsetDateTime)) {
            throw new IllegalArgumentException(String.format("DateDiff can only take DateTime as argument, encountered %s", object.getClass()));
        }
        OffsetDateTime otherDate = this.value != null ? this.value : (this.dateTraversal != null ? TraversalUtil.apply(traverser, this.dateTraversal) : null);
        long otherDateMs = otherDate == null ? 0L : otherDate.toEpochSecond();
        return ((OffsetDateTime)object).toEpochSecond() - otherDateMs;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : this.dateTraversal.hashCode());
        return result;
    }

    @Override
    public DateDiffStep<S> clone() {
        DateDiffStep clone = (DateDiffStep)super.clone();
        clone.value = this.value;
        clone.dateTraversal = this.dateTraversal;
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    public OffsetDateTime getValue() {
        return this.value;
    }

    public Traversal.Admin<S, OffsetDateTime> getDateTraversal() {
        return this.dateTraversal;
    }
}

