/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.util.TimeBucketCounterBase;

public class TimeBucketCounter
extends TimeBucketCounterBase {
    private final int numBits;
    private final double ratio;

    public TimeBucketCounter(int bucketDuration, ScheduledExecutorService executorService) {
        super(TimeBucketCounter.getActualDuration(bucketDuration), executorService);
        this.numBits = TimeBucketCounter.determineShiftBitsOfDuration(bucketDuration);
        this.ratio = TimeBucketCounter.ratioToPowerOf2(bucketDuration * 1000);
    }

    @Override
    public long getBucketIndex(long timestamp) {
        return timestamp >> this.numBits;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getActualDuration() {
        return (int)Math.pow(2.0, this.getNumBits());
    }

    protected static int determineShiftBitsOfDuration(int duration) {
        int pof2;
        int bits = 0;
        int bitCheck = pof2 = TimeBucketCounter.nextPowerOf2(duration * 1000);
        while (bitCheck > 1) {
            bitCheck = pof2 >> ++bits;
        }
        return bits;
    }

    private static int getActualDuration(int duration) {
        return (int)(1L << TimeBucketCounter.determineShiftBitsOfDuration(duration)) / 1000;
    }

    @Override
    public double getRatio() {
        return this.ratio;
    }

    static double ratioToPowerOf2(int value) {
        double nextPO2 = TimeBucketCounter.nextPowerOf2(value);
        return (double)Math.round(1000.0 * nextPO2 / (double)value) / 1000.0;
    }

    static int nextPowerOf2(int value) {
        int valueOfHighestBit = Integer.highestOneBit(value);
        if (valueOfHighestBit == value) {
            return value;
        }
        return valueOfHighestBit << 1;
    }

    @Override
    public long getMillisUntilNextBucket() {
        long millis = System.currentTimeMillis();
        long nextTimeBucketMillis = millis + (long)Math.pow(2.0, this.numBits) >> this.numBits << this.numBits;
        return nextTimeBucketMillis - millis;
    }
}

