/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.util.Iterator;
import org.apache.torque.om.Persistent;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.RolePeerManager;
import org.apache.turbine.services.security.torque.TorqueObject;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.TurbineSecurityException;

public class TorqueRole
extends TorqueObject
implements Role,
Comparable {
    private static final long serialVersionUID = -7774684697021445523L;
    private PermissionSet permissionSet = null;

    public TorqueRole() {
    }

    public TorqueRole(String name) {
        super(name);
    }

    public TorqueRole(Persistent obj) {
        super(obj);
    }

    public Persistent getPersistentObj() {
        if (this.obj == null) {
            this.obj = RolePeerManager.newPersistentInstance();
        }
        return this.obj;
    }

    public String getName() {
        return RolePeerManager.getRoleName(this.getPersistentObj());
    }

    public void setName(String name) {
        RolePeerManager.setRoleName(this.getPersistentObj(), name);
    }

    public int getId() {
        return RolePeerManager.getIdAsObj(this.getPersistentObj());
    }

    public Integer getIdAsObj() {
        return RolePeerManager.getIdAsObj(this.getPersistentObj());
    }

    public void setId(int id) {
        RolePeerManager.setId(this.getPersistentObj(), id);
    }

    public PermissionSet getPermissions() throws Exception {
        return this.permissionSet;
    }

    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet;
    }

    public Role create(String name) throws TurbineSecurityException {
        return TurbineSecurity.createRole(name);
    }

    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveRole(this);
    }

    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeRole(this);
    }

    public void rename(String name) throws TurbineSecurityException {
        TurbineSecurity.renameRole(this, name);
    }

    public void grant(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.grant(this, permission);
    }

    public void grant(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.iterator();
        while (permissions.hasNext()) {
            TurbineSecurity.grant(this, (Permission)permissions.next());
        }
    }

    public void revoke(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.revoke(this, permission);
    }

    public void revoke(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.iterator();
        while (permissions.hasNext()) {
            TurbineSecurity.revoke(this, (Permission)permissions.next());
        }
    }
}

