/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.role;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.fulcrum.yaafi.framework.role.RoleEntry;
import org.apache.fulcrum.yaafi.framework.util.ToStringBuilder;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class RoleEntryImpl
implements RoleEntry {
    private String name;
    private String implementationClazzName;
    private String shorthand;
    private boolean isEarlyInit;
    private String description;
    private String componentType;
    private String componentFlavour;
    private boolean hasDynamicProxy;
    private ArrayList interceptorList;
    private String logCategory;

    public RoleEntryImpl(String name, String defaultClass, String shorthand, boolean earlyInit, String description, String componentType, String componentFlavour, boolean hasProxy, ArrayList interceptorList, String logCategory) {
        Validate.notEmpty(name, "name");
        Validate.notEmpty(defaultClass, "defaultClass");
        Validate.notEmpty(shorthand, "shorthand");
        Validate.notEmpty(componentType, "componentType");
        Validate.notEmpty(componentFlavour, "componentFlavour");
        Validate.notNull(interceptorList, "interceptorList");
        Validate.notEmpty(logCategory, "logCategory");
        this.name = name;
        this.implementationClazzName = defaultClass;
        this.shorthand = shorthand;
        this.isEarlyInit = earlyInit;
        this.description = description;
        this.componentType = componentType;
        this.componentFlavour = componentFlavour;
        this.hasDynamicProxy = hasProxy;
        this.interceptorList = interceptorList;
        this.logCategory = logCategory;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImplementationClazzName() {
        return this.implementationClazzName;
    }

    public boolean isEarlyInit() {
        return this.isEarlyInit;
    }

    public String getName() {
        return this.name;
    }

    public String getShorthand() {
        return this.shorthand;
    }

    public String getComponentFlavour() {
        return this.componentFlavour;
    }

    public boolean hasDynamicProxy() {
        return this.hasDynamicProxy;
    }

    public void setHasDynamicProxy(boolean hasProxy) {
        this.hasDynamicProxy = hasProxy;
    }

    public boolean hasInterceptor(String interceptorName) {
        String currInterceptorName = null;
        Iterator iterator = this.interceptorList.iterator();
        while (iterator.hasNext()) {
            currInterceptorName = (String)iterator.next();
            if (!currInterceptorName.equals(interceptorName)) continue;
            return true;
        }
        return false;
    }

    public void addInterceptors(Collection collection) {
        String currInterceptorName = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            currInterceptorName = (String)iterator.next();
            if (this.hasInterceptor(currInterceptorName)) continue;
            this.interceptorList.add(currInterceptorName);
        }
    }

    public String[] getInterceptorList() {
        return this.interceptorList.toArray(new String[this.interceptorList.size()]);
    }

    public String getLogCategory() {
        return this.logCategory;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        toStringBuilder.append("name", this.name);
        toStringBuilder.append("shorthand", this.shorthand);
        toStringBuilder.append("implementationClazzName", this.implementationClazzName);
        toStringBuilder.append("isEarlyInit", this.isEarlyInit);
        toStringBuilder.append("hasDynamicProxy", this.hasDynamicProxy);
        toStringBuilder.append("componentType", this.componentType);
        toStringBuilder.append("componentFlavour", this.componentFlavour);
        toStringBuilder.append("interceptorList", this.interceptorList);
        toStringBuilder.append("logCategory", this.logCategory);
        toStringBuilder.append("description", this.description);
        return toStringBuilder.toString();
    }
}

