/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.service.reconfiguration;

import java.io.File;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.activity.Suspendable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.yaafi.framework.container.ServiceLifecycleManager;
import org.apache.fulcrum.yaafi.service.reconfiguration.ReconfigurationEntry;
import org.apache.fulcrum.yaafi.service.reconfiguration.ReconfigurationService;

public class ReconfigurationServiceImpl
extends AbstractLogEnabled
implements ReconfigurationService,
Serviceable,
Contextualizable,
Reconfigurable,
Initializable,
Runnable,
Startable,
Disposable {
    private int interval;
    private boolean terminateNow = false;
    private Thread workerThread;
    private ServiceManager serviceManager;
    private File applicationDir;
    private ReconfigurationEntry[] reconfigurationEntryList;
    private ServiceLifecycleManager serviceLifecycleManager;

    public void service(ServiceManager manager) throws ServiceException {
        this.serviceManager = manager;
        this.serviceLifecycleManager = (ServiceLifecycleManager)manager;
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationDir = (File)context.get((Object)"urn:avalon:home");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.interval = Math.max(configuration.getAttributeAsInteger("interval", 5000), 1000);
        this.getLogger().debug("Monitoring the resources every " + this.interval + " ms");
        Configuration entry = null;
        Configuration services = null;
        Configuration[] serviceEntries = null;
        Configuration[] entryList = configuration.getChildren("entry");
        String location = null;
        String serviceName = null;
        String[] serviceNameList = null;
        ReconfigurationEntry reconfigurationEntry = null;
        ReconfigurationEntry[] list = new ReconfigurationEntry[entryList.length];
        for (int i = 0; i < entryList.length; ++i) {
            entry = entryList[i];
            location = entry.getChild("location").getValue();
            services = entry.getChild("services", false);
            this.getLogger().debug("Adding the following resource to monitor : " + location);
            if (services != null) {
                serviceEntries = services.getChildren("service");
                serviceNameList = new String[serviceEntries.length];
                for (int j = 0; j < serviceEntries.length; ++j) {
                    serviceNameList[j] = serviceName = serviceEntries[j].getAttribute("name");
                }
            }
            list[i] = reconfigurationEntry = new ReconfigurationEntry(this.getLogger(), this.applicationDir, location, serviceNameList);
        }
        this.getLogger().debug("Monitoring " + list.length + " resources");
        this.setReconfigurationEntryList(list);
    }

    public void initialize() throws Exception {
        MessageDigest.getInstance("SHA1");
        if (!(this.serviceManager instanceof ServiceLifecycleManager)) {
            String msg = "The ServiceManager instance does not implement ServiceLifecycleManager?!";
            throw new IllegalArgumentException(msg);
        }
        this.workerThread = new Thread((Runnable)this, "ReconfigurationService");
    }

    public void start() throws Exception {
        this.getLogger().debug("Starting worker thread ...");
        this.workerThread.start();
    }

    public void stop() throws Exception {
        this.getLogger().debug("Stopping worker thread ...");
        this.terminateNow = true;
        this.workerThread.interrupt();
        this.workerThread.join(10000L);
    }

    public void dispose() {
        this.terminateNow = false;
        this.applicationDir = null;
        this.workerThread = null;
        this.serviceManager = null;
        this.reconfigurationEntryList = null;
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        this.configure(configuration);
    }

    public void run() {
        ReconfigurationEntry reconfigurationEntry = null;
        ReconfigurationEntry[] list = null;
        while (!this.terminateNow) {
            list = this.getReconfigurationEntryList();
            try {
                for (int i = 0; i < list.length; ++i) {
                    reconfigurationEntry = list[i];
                    if (!reconfigurationEntry.hasChanged()) continue;
                    this.onReconfigure(reconfigurationEntry);
                }
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                String msg = "The ReconfigurationService had a problem";
                this.getLogger().error(msg, (Throwable)e);
            }
        }
    }

    protected void onReconfigure(ReconfigurationEntry reconfigurationEntry) throws Exception {
        if (reconfigurationEntry.getServiceList() == null) {
            InputStream is = reconfigurationEntry.locate();
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            Configuration configuration = builder.build(is);
            is.close();
            is = null;
            this.getLogger().warn("Starting to reconfigure the container");
            if (this.serviceManager instanceof Suspendable) {
                this.getLogger().info("Calling suspend() of the container");
                ((Suspendable)this.serviceManager).suspend();
            }
            if (this.serviceManager instanceof Reconfigurable) {
                this.getLogger().info("Calling reconfigure() of the container");
                ((Reconfigurable)this.serviceManager).reconfigure(configuration);
            }
            if (this.serviceManager instanceof Suspendable) {
                this.getLogger().info("Calling resume() of the container");
                ((Suspendable)this.serviceManager).resume();
            }
            this.getLogger().info("Reconfiguring the container was successful");
        } else {
            String[] serviceList = reconfigurationEntry.getServiceList();
            this.getLogger().warn("Calling reconfigure() on individual services : " + serviceList.length);
            this.serviceLifecycleManager.reconfigure(serviceList);
        }
    }

    private synchronized ReconfigurationEntry[] getReconfigurationEntryList() {
        return this.reconfigurationEntryList;
    }

    private synchronized void setReconfigurationEntryList(ReconfigurationEntry[] reconfigurationEntryList) {
        this.reconfigurationEntryList = reconfigurationEntryList;
    }
}

