/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.BaseService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.Service;
import org.apache.turbine.services.ServiceBroker;

public abstract class BaseServiceBroker
implements ServiceBroker {
    protected Configuration mapping = new BaseConfiguration();
    protected Hashtable services = new Hashtable();
    protected Configuration configuration;
    public static final String SERVICE_PREFIX = "services.";
    public static final String CLASSNAME_SUFFIX = ".classname";
    protected Hashtable serviceObjects = new Hashtable();
    private static Log log = LogFactory.getLog((Class)BaseServiceBroker.class);
    protected String applicationRoot;

    protected BaseServiceBroker() {
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void init() throws InitializationException {
        this.initMapping();
        this.initServices(false);
    }

    public void setServiceObject(String name, Object value) {
        this.serviceObjects.put(name, value);
    }

    public Object getServiceObject(String name) {
        return this.serviceObjects.get(name);
    }

    protected void initMapping() {
        Iterator keys = this.configuration.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] keyParts = StringUtils.split((String)key, (String)".");
            if (keyParts.length != 3 || !(keyParts[0] + ".").equals(SERVICE_PREFIX) || !("." + keyParts[2]).equals(CLASSNAME_SUFFIX)) continue;
            String serviceKey = keyParts[1];
            log.info((Object)("Added Mapping for Service: " + serviceKey));
            if (this.mapping.containsKey(serviceKey)) continue;
            this.mapping.setProperty(serviceKey, (Object)this.configuration.getString(key));
        }
    }

    public boolean isRegistered(String serviceName) {
        return this.services.get(serviceName) != null;
    }

    public Iterator getServiceNames() {
        return this.mapping.getKeys();
    }

    public Iterator getServiceNames(String prefix) {
        return this.mapping.getKeys(prefix);
    }

    public synchronized void initService(String name) throws InitializationException {
        Service instance = this.getServiceInstance(name);
        if (!instance.getInit()) {
            instance.init();
        }
    }

    public void initServices() {
        try {
            this.initServices(false);
        }
        catch (InstantiationException notThrown) {
            log.debug((Object)"Caught non fatal exception", (Throwable)((Object)notThrown));
        }
        catch (InitializationException notThrown) {
            log.debug((Object)"Caught non fatal exception", (Throwable)((Object)notThrown));
        }
    }

    public void initServices(boolean report) throws InstantiationException, InitializationException {
        if (report) {
            Iterator names = this.getServiceNames();
            while (names.hasNext()) {
                this.doInitService((String)names.next());
            }
        } else {
            Iterator names = this.getServiceNames();
            while (names.hasNext()) {
                try {
                    this.doInitService((String)names.next());
                }
                catch (InstantiationException e) {
                    log.error((Object)e);
                }
                catch (InitializationException e) {
                    log.error((Object)e);
                }
            }
        }
        log.info((Object)"Finished initializing all services!");
    }

    private void doInitService(String name) throws InstantiationException, InitializationException {
        if (this.getConfiguration(name).getBoolean("earlyInit", false)) {
            log.info((Object)("Start Initializing service (early): " + name));
            this.initService(name);
            log.info((Object)("Finish Initializing service (early): " + name));
        }
    }

    public synchronized void shutdownService(String name) {
        try {
            Service service = this.getServiceInstance(name);
            if (service != null && service.getInit()) {
                service.shutdown();
                if (service.getInit() && service instanceof BaseService) {
                    ((BaseService)service).setInit(false);
                }
            }
        }
        catch (InstantiationException e) {
            log.error((Object)("Shutdown of a nonexistent Service '" + name + "' was requested"), (Throwable)((Object)e));
        }
    }

    public void shutdownServices() {
        log.info((Object)"Shutting down all services!");
        String serviceName = null;
        ArrayList<String> reverseServicesList = new ArrayList<String>();
        Iterator serviceNames = this.getServiceNames();
        while (serviceNames.hasNext()) {
            serviceName = (String)serviceNames.next();
            reverseServicesList.add(0, serviceName);
        }
        serviceNames = reverseServicesList.iterator();
        while (serviceNames.hasNext()) {
            serviceName = (String)serviceNames.next();
            log.info((Object)("Shutting down service: " + serviceName));
            this.shutdownService(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service getService(String name) throws InstantiationException {
        try {
            Service service = this.getServiceInstance(name);
            if (!service.getInit()) {
                Class<?> clazz = service.getClass();
                synchronized (clazz) {
                    if (!service.getInit()) {
                        log.info((Object)("Start Initializing service (late): " + name));
                        service.init();
                        log.info((Object)("Finish Initializing service (late): " + name));
                    }
                }
            }
            if (!service.getInit()) {
                throw new InitializationException("init() failed to initialize service " + name);
            }
            return service;
        }
        catch (InitializationException e) {
            throw new InstantiationException("Service " + name + " failed to initialize", (Throwable)((Object)e));
        }
    }

    protected Service getServiceInstance(String name) throws InstantiationException {
        Service service = (Service)this.services.get(name);
        if (service == null) {
            block9: {
                String className = this.mapping.getString(name);
                if (StringUtils.isEmpty((String)className)) {
                    throw new InstantiationException("ServiceBroker: unknown service " + name + " requested");
                }
                try {
                    service = (Service)this.services.get(className);
                    if (service != null) break block9;
                    try {
                        service = (Service)Class.forName(className).newInstance();
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (OutOfMemoryError t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        String msg = null;
                        msg = t instanceof NoClassDefFoundError ? "A class referenced by " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassNotFoundException ? "Class " + className + " is unavailable. Check your jars and classes." : (t instanceof ClassCastException ? "Class " + className + " doesn't implement the Service interface" : "Failed to instantiate " + className));
                        throw new InstantiationException(msg, t);
                    }
                }
                catch (ClassCastException e) {
                    throw new InstantiationException("ServiceBroker: Class " + className + " does not implement Service interface.", e);
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Failed to instantiate service " + name, (Throwable)((Object)e));
                }
            }
            service.setServiceBroker(this);
            service.setName(name);
            this.services.put(name, service);
        }
        return service;
    }

    public Configuration getConfiguration(String name) {
        return this.configuration.subset(SERVICE_PREFIX + name);
    }

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }

    public String getApplicationRoot() {
        return this.applicationRoot;
    }
}

