/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.DateStringValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.TurbineRuntimeException;

public class DateStringField
extends Field {
    private static DateFormat df = DateFormat.getInstance();

    public DateStringField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.defaultValue = this.getDate(prop);
        }
        catch (ParseException e) {
            throw new TurbineRuntimeException("Could not parse " + prop + " into a valid Date for the default value", e);
        }
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        try {
            this.emptyValue = this.getDate(prop);
        }
        catch (ParseException e) {
            throw new TurbineRuntimeException("Could not parse " + prop + " into a valid Date for the empty value", e);
        }
    }

    protected String getDefaultValidator() {
        return DateStringValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            String[] inputs = this.parser.getStrings(this.getKey());
            Date[] values = new Date[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                try {
                    values[i] = StringUtils.isNotEmpty((String)inputs[i]) ? this.getDate(inputs[i]) : (Date)this.getEmptyValue();
                    continue;
                }
                catch (ParseException e) {
                    values[i] = null;
                }
            }
            this.setTestValue(values);
        } else {
            String val = this.parser.getString(this.getKey());
            try {
                this.setTestValue(StringUtils.isNotEmpty((String)val) ? this.getDate(val) : (Date)this.getEmptyValue());
            }
            catch (ParseException e) {
                this.setTestValue(null);
            }
        }
    }

    private Date getDate(String dateString) throws ParseException {
        Date date = null;
        date = this.validator != null && this.validator instanceof DateStringValidator ? ((DateStringValidator)this.validator).parse(dateString) : df.parse(dateString);
        return date;
    }

    public String toString() {
        String s = null;
        Object value = this.getValue();
        s = value == null ? "" : (value instanceof String ? (String)value : (this.validator != null && this.validator instanceof DateStringValidator ? ((DateStringValidator)this.validator).format((Date)value) : df.format((Date)value)));
        return s;
    }

    static {
        df.setLenient(true);
    }
}

