/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.LongValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class LongField
extends Field {
    public LongField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new Long(prop);
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new Long(prop);
    }

    protected Object getSafeEmptyValue() {
        if (this.isMultiValued) {
            return new long[0];
        }
        return null == this.getEmptyValue() ? new Long(0L) : this.getEmptyValue();
    }

    protected String getDefaultValidator() {
        return LongValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            Long[] inputs = this.parser.getLongObjects(this.getKey());
            long[] values = new long[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Long)this.getEmptyValue()).longValue() : inputs[i].longValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getLongObject(this.getKey(), (Long)this.getEmptyValue()));
        }
    }
}

