/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.security.torque.om.TurbineGroup;
import org.apache.turbine.services.security.torque.om.TurbineGroupPeer;
import org.apache.turbine.services.security.torque.om.TurbineRole;
import org.apache.turbine.services.security.torque.om.TurbineRolePeer;
import org.apache.turbine.services.security.torque.om.TurbineUser;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRole;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.turbine.services.security.torque.om.TurbineUserPeer;

public abstract class BaseTurbineUserGroupRole
extends BaseObject {
    private static final long serialVersionUID = 1225810431540L;
    private static final TurbineUserGroupRolePeer peer = new TurbineUserGroupRolePeer();
    private int userId;
    private int groupId;
    private int roleId;
    private TurbineUser aTurbineUser;
    private TurbineGroup aTurbineGroup;
    private TurbineRole aTurbineRole;
    private static List fieldNames = null;
    private boolean alreadyInSave = false;
    private final SimpleKey[] pks = new SimpleKey[3];
    private final ComboKey comboPK = new ComboKey(this.pks);

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int v) throws TorqueException {
        if (this.userId != v) {
            this.userId = v;
            this.setModified(true);
        }
        if (this.aTurbineUser != null && this.aTurbineUser.getUserId() != v) {
            this.aTurbineUser = null;
        }
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int v) throws TorqueException {
        if (this.groupId != v) {
            this.groupId = v;
            this.setModified(true);
        }
        if (this.aTurbineGroup != null && this.aTurbineGroup.getGroupId() != v) {
            this.aTurbineGroup = null;
        }
    }

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int v) throws TorqueException {
        if (this.roleId != v) {
            this.roleId = v;
            this.setModified(true);
        }
        if (this.aTurbineRole != null && this.aTurbineRole.getRoleId() != v) {
            this.aTurbineRole = null;
        }
    }

    public void setTurbineUser(TurbineUser v) throws TorqueException {
        if (v == null) {
            this.setUserId(0);
        } else {
            this.setUserId(v.getUserId());
        }
        this.aTurbineUser = v;
    }

    public TurbineUser getTurbineUser() throws TorqueException {
        if (this.aTurbineUser == null && this.userId != 0) {
            this.aTurbineUser = TurbineUserPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.userId));
        }
        return this.aTurbineUser;
    }

    public TurbineUser getTurbineUser(Connection connection) throws TorqueException {
        if (this.aTurbineUser == null && this.userId != 0) {
            this.aTurbineUser = TurbineUserPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.userId), connection);
        }
        return this.aTurbineUser;
    }

    public void setTurbineUserKey(ObjectKey key) throws TorqueException {
        this.setUserId(((NumberKey)key).intValue());
    }

    public void setTurbineGroup(TurbineGroup v) throws TorqueException {
        if (v == null) {
            this.setGroupId(0);
        } else {
            this.setGroupId(v.getGroupId());
        }
        this.aTurbineGroup = v;
    }

    public TurbineGroup getTurbineGroup() throws TorqueException {
        if (this.aTurbineGroup == null && this.groupId != 0) {
            this.aTurbineGroup = TurbineGroupPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.groupId));
        }
        return this.aTurbineGroup;
    }

    public TurbineGroup getTurbineGroup(Connection connection) throws TorqueException {
        if (this.aTurbineGroup == null && this.groupId != 0) {
            this.aTurbineGroup = TurbineGroupPeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.groupId), connection);
        }
        return this.aTurbineGroup;
    }

    public void setTurbineGroupKey(ObjectKey key) throws TorqueException {
        this.setGroupId(((NumberKey)key).intValue());
    }

    public void setTurbineRole(TurbineRole v) throws TorqueException {
        if (v == null) {
            this.setRoleId(0);
        } else {
            this.setRoleId(v.getRoleId());
        }
        this.aTurbineRole = v;
    }

    public TurbineRole getTurbineRole() throws TorqueException {
        if (this.aTurbineRole == null && this.roleId != 0) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.roleId));
        }
        return this.aTurbineRole;
    }

    public TurbineRole getTurbineRole(Connection connection) throws TorqueException {
        if (this.aTurbineRole == null && this.roleId != 0) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK((ObjectKey)SimpleKey.keyFor((int)this.roleId), connection);
        }
        return this.aTurbineRole;
    }

    public void setTurbineRoleKey(ObjectKey key) throws TorqueException {
        this.setRoleId(((NumberKey)key).intValue());
    }

    public static synchronized List getFieldNames() {
        if (fieldNames == null) {
            fieldNames = new ArrayList();
            fieldNames.add("UserId");
            fieldNames.add("GroupId");
            fieldNames.add("RoleId");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    public Object getByName(String name) {
        if (name.equals("UserId")) {
            return new Integer(this.getUserId());
        }
        if (name.equals("GroupId")) {
            return new Integer(this.getGroupId());
        }
        if (name.equals("RoleId")) {
            return new Integer(this.getRoleId());
        }
        return null;
    }

    public boolean setByName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (name.equals("UserId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setUserId((Integer)value);
            return true;
        }
        if (name.equals("GroupId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setGroupId((Integer)value);
            return true;
        }
        if (name.equals("RoleId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setRoleId((Integer)value);
            return true;
        }
        return false;
    }

    public Object getByPeerName(String name) {
        if (name.equals(TurbineUserGroupRolePeer.USER_ID)) {
            return new Integer(this.getUserId());
        }
        if (name.equals(TurbineUserGroupRolePeer.GROUP_ID)) {
            return new Integer(this.getGroupId());
        }
        if (name.equals(TurbineUserGroupRolePeer.ROLE_ID)) {
            return new Integer(this.getRoleId());
        }
        return null;
    }

    public boolean setByPeerName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (TurbineUserGroupRolePeer.USER_ID.equals(name)) {
            return this.setByName("UserId", value);
        }
        if (TurbineUserGroupRolePeer.GROUP_ID.equals(name)) {
            return this.setByName("GroupId", value);
        }
        if (TurbineUserGroupRolePeer.ROLE_ID.equals(name)) {
            return this.setByName("RoleId", value);
        }
        return false;
    }

    public Object getByPosition(int pos) {
        if (pos == 0) {
            return new Integer(this.getUserId());
        }
        if (pos == 1) {
            return new Integer(this.getGroupId());
        }
        if (pos == 2) {
            return new Integer(this.getRoleId());
        }
        return null;
    }

    public boolean setByPosition(int position, Object value) throws TorqueException, IllegalArgumentException {
        if (position == 0) {
            return this.setByName("UserId", value);
        }
        if (position == 1) {
            return this.setByName("GroupId", value);
        }
        if (position == 2) {
            return this.setByName("RoleId", value);
        }
        return false;
    }

    public void save() throws Exception {
        this.save(TurbineUserGroupRolePeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin((String)dbName);
            this.save(con);
            Transaction.commit((Connection)con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback((Connection)con);
            throw e;
        }
    }

    public void save(Connection con) throws TorqueException {
        if (!this.alreadyInSave) {
            this.alreadyInSave = true;
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineUserGroupRolePeer.doInsert((TurbineUserGroupRole)this, con);
                    this.setNew(false);
                } else {
                    TurbineUserGroupRolePeer.doUpdate((TurbineUserGroupRole)this, con);
                }
            }
            this.alreadyInSave = false;
        }
    }

    public void setPrimaryKey(ObjectKey key) throws TorqueException {
        SimpleKey[] keys = (SimpleKey[])key.getValue();
        this.setUserId(((NumberKey)keys[0]).intValue());
        this.setGroupId(((NumberKey)keys[1]).intValue());
        this.setRoleId(((NumberKey)keys[2]).intValue());
    }

    public void setPrimaryKey(int userId, int groupId, int roleId) throws TorqueException {
        this.setUserId(userId);
        this.setGroupId(groupId);
        this.setRoleId(roleId);
    }

    public void setPrimaryKey(String key) throws TorqueException {
        this.setPrimaryKey((ObjectKey)new ComboKey(key));
    }

    public ObjectKey getPrimaryKey() {
        this.pks[0] = SimpleKey.keyFor((int)this.getUserId());
        this.pks[1] = SimpleKey.keyFor((int)this.getGroupId());
        this.pks[2] = SimpleKey.keyFor((int)this.getRoleId());
        return this.comboPK;
    }

    public TurbineUserGroupRole copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineUserGroupRole copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineUserGroupRole copy(boolean deepcopy) throws TorqueException {
        return this.copyInto(new TurbineUserGroupRole(), deepcopy);
    }

    public TurbineUserGroupRole copy(boolean deepcopy, Connection con) throws TorqueException {
        return this.copyInto(new TurbineUserGroupRole(), deepcopy, con);
    }

    protected TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    protected TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setUserId(this.userId);
        copyObj.setGroupId(this.groupId);
        copyObj.setRoleId(this.roleId);
        copyObj.setUserId(0);
        copyObj.setGroupId(0);
        copyObj.setRoleId(0);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    protected TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setUserId(this.userId);
        copyObj.setGroupId(this.groupId);
        copyObj.setRoleId(this.roleId);
        copyObj.setUserId(0);
        copyObj.setGroupId(0);
        copyObj.setRoleId(0);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TurbineUserGroupRolePeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineUserGroupRolePeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineUserGroupRole:\n");
        str.append("UserId = ").append(this.getUserId()).append("\n");
        str.append("GroupId = ").append(this.getGroupId()).append("\n");
        str.append("RoleId = ").append(this.getRoleId()).append("\n");
        return str.toString();
    }
}

