/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.session.SessionService;

public class TurbineSessionService
extends TurbineBaseService
implements SessionService {
    private Map activeSessions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getActiveSessions() {
        Map map = this.activeSessions;
        synchronized (map) {
            return new ArrayList(this.activeSessions.values());
        }
    }

    public void addSession(HttpSession session) {
        this.activeSessions.put(session.getId(), session);
    }

    public void removeSession(HttpSession session) {
        this.activeSessions.remove(session.getId());
    }

    public boolean isUserLoggedIn(User user) {
        return this.getActiveUsers().contains(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getActiveUsers() {
        ArrayList<User> users;
        Map map = this.activeSessions;
        synchronized (map) {
            users = new ArrayList<User>((int)((double)this.activeSessions.size() * 0.7));
            Iterator i = this.activeSessions.values().iterator();
            while (i.hasNext()) {
                User u = this.getUserFromSession((HttpSession)i.next());
                if (u == null || !u.hasLoggedIn()) continue;
                users.add(u);
            }
        }
        return users;
    }

    public User getUserFromSession(HttpSession session) {
        try {
            return (User)session.getAttribute("turbine.user");
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public HttpSession getSession(String sessionId) {
        return (HttpSession)this.activeSessions.get(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSessionsForUser(User user) {
        ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
        Map map = this.activeSessions;
        synchronized (map) {
            Iterator i = this.activeSessions.values().iterator();
            while (i.hasNext()) {
                HttpSession session = (HttpSession)i.next();
                User u = this.getUserFromSession(session);
                if (!user.equals(u)) continue;
                sessions.add(session);
            }
        }
        return sessions;
    }

    public void init() {
        this.activeSessions = new Hashtable();
        this.setInit(true);
    }

    public void shutdown() {
        this.activeSessions = null;
        this.setInit(false);
    }
}

