/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.parser;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.parser.BaseValueParser;
import org.apache.turbine.util.parser.CookieParser;
import org.apache.turbine.util.pool.Recyclable;
import org.apache.turbine.util.uri.DataURI;
import org.apache.turbine.util.uri.URI;

public class DefaultCookieParser
extends BaseValueParser
implements CookieParser,
Recyclable {
    private static Log log = LogFactory.getLog((Class)DefaultCookieParser.class);
    private RunData data = null;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private URI cookiePath = null;

    public void dispose() {
        this.data = null;
        this.cookiePath = null;
        this.request = null;
        this.response = null;
        super.dispose();
    }

    public RunData getRunData() {
        return this.data;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRunData(RunData data) {
        this.data = data;
        this.setData(data.getRequest(), data.getResponse());
    }

    public void setData(HttpServletRequest request, HttpServletResponse response) {
        this.clear();
        String enc = request.getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "US-ASCII");
        this.cookiePath = new DataURI(new ServerData(request));
        Cookie[] cookies = request.getCookies();
        int cookiesCount = cookies != null ? cookies.length : 0;
        log.debug((Object)("Number of Cookies: " + cookiesCount));
        for (int i = 0; i < cookiesCount; ++i) {
            String name = this.convert(cookies[i].getName());
            String value = cookies[i].getValue();
            log.debug((Object)("Adding " + name + "=" + value));
            this.add(name, value);
        }
        this.request = request;
        this.response = response;
    }

    public URI getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(URI cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void set(String name, String value) {
        this.set(name, value, -1);
    }

    public void set(String name, String value, int seconds_age) {
        if (this.response == null) {
            throw new IllegalStateException("Servlet response not available");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(seconds_age);
        cookie.setPath(this.cookiePath.getContextPath() + this.cookiePath.getScriptName());
        this.response.addCookie(cookie);
    }

    public void unset(String name) {
        this.set(name, " ", 0);
    }
}

