/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.StackKeyedObjectPool;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.IntakeService;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.transform.XmlToAppData;
import org.apache.turbine.services.intake.xmlmodel.AppData;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;

public class TurbineIntakeService
extends TurbineBaseService
implements IntakeService {
    private Map groupNames;
    private Map groupNameMap;
    private Map groupKeyMap;
    private Map getterMap;
    private Map setterMap;
    private Map keyedPools;
    private static Log log = LogFactory.getLog((Class)TurbineIntakeService.class);

    public void init() throws InitializationException {
        Iterator<Object> it;
        Vector<String> defaultXmlPathes = new Vector<String>();
        defaultXmlPathes.add("WEB-INF/conf/intake.xml");
        List xmlPathes = this.getConfiguration().getList("xml.path", defaultXmlPathes);
        HashMap<AppData, String> appDataElements = null;
        String serialDataPath = this.getConfiguration().getString("serialize.path", "WEB-INF/appData.ser");
        serialDataPath = !serialDataPath.equalsIgnoreCase("none") ? Turbine.getRealPath(serialDataPath) : null;
        log.debug((Object)("Path for serializing: " + serialDataPath));
        this.groupNames = new HashMap();
        this.groupKeyMap = new HashMap();
        this.groupNameMap = new HashMap();
        this.getterMap = new HashMap();
        this.setterMap = new HashMap();
        this.keyedPools = new HashMap();
        if (xmlPathes == null) {
            String LOAD_ERROR = "No pathes for XML files were specified. Check that the property exists in TurbineResources.props and were loaded.";
            log.error((Object)LOAD_ERROR);
            throw new InitializationException(LOAD_ERROR);
        }
        HashSet<String> xmlFiles = new HashSet<String>();
        long timeStamp = 0L;
        Iterator it2 = xmlPathes.iterator();
        while (it2.hasNext()) {
            String xmlPath = Turbine.getRealPath((String)it2.next());
            File xmlFile = new File(xmlPath);
            log.debug((Object)("Path for XML File: " + xmlFile));
            if (!xmlFile.canRead()) {
                String READ_ERR = "Could not read input file " + xmlPath;
                log.error((Object)READ_ERR);
                throw new InitializationException(READ_ERR);
            }
            xmlFiles.add(xmlPath);
            log.debug((Object)("Added " + xmlPath + " as File to parse"));
            timeStamp = xmlFile.lastModified() > timeStamp ? xmlFile.lastModified() : timeStamp;
        }
        HashMap<AppData, String> serializedMap = this.loadSerialized(serialDataPath, timeStamp);
        if (serializedMap != null) {
            appDataElements = serializedMap;
            log.debug((Object)"Using the serialized map");
        } else {
            appDataElements = new HashMap<AppData, String>();
            it = xmlFiles.iterator();
            while (it.hasNext()) {
                String xmlPath = (String)it.next();
                AppData appData = null;
                log.debug((Object)("Now parsing: " + xmlPath));
                try {
                    XmlToAppData xmlApp = new XmlToAppData();
                    appData = xmlApp.parseFile(xmlPath);
                }
                catch (Exception e) {
                    log.error((Object)("Could not parse XML file " + xmlPath), (Throwable)e);
                    throw new InitializationException("Could not parse XML file " + xmlPath, e);
                }
                appDataElements.put(appData, xmlPath);
                log.debug((Object)("Saving appData for " + xmlPath));
            }
            this.saveSerialized(serialDataPath, appDataElements);
        }
        try {
            it = appDataElements.keySet().iterator();
            while (it.hasNext()) {
                AppData appData = (AppData)it.next();
                int maxPooledGroups = 0;
                List glist = appData.getGroups();
                String groupPrefix = appData.getGroupPrefix();
                for (int i = glist.size() - 1; i >= 0; --i) {
                    XmlGroup g = (XmlGroup)glist.get(i);
                    String groupName = g.getName();
                    boolean registerUnqualified = this.registerGroup(groupName, g, appData, true);
                    if (!registerUnqualified) {
                        log.info((Object)("Ignored redefinition of Group " + groupName + " or Key " + g.getKey() + " from " + appDataElements.get(appData)));
                    }
                    if (groupPrefix != null) {
                        StringBuffer qualifiedName = new StringBuffer();
                        qualifiedName.append(groupPrefix).append(':').append(groupName);
                        if (!this.registerGroup(qualifiedName.toString(), g, appData, !registerUnqualified)) {
                            log.error((Object)("Could not register fully qualified name " + qualifiedName + ", maybe two XML files have the same prefix. Ignoring it."));
                        }
                    }
                    maxPooledGroups = Math.max(maxPooledGroups, Integer.parseInt(g.getPoolCapacity()));
                }
                Group.GroupFactory factory = new Group.GroupFactory(appData);
                this.keyedPools.put(appData, new StackKeyedObjectPool((KeyedPoolableObjectFactory)factory, maxPooledGroups));
            }
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineIntakeService failed to initialize", e);
        }
    }

    public void init(ServletConfig config) throws InitializationException {
        this.init();
    }

    private boolean registerGroup(String groupName, XmlGroup group, AppData appData, boolean checkKey) {
        if (this.groupNames.keySet().contains(groupName)) {
            return false;
        }
        boolean keyExists = this.groupNameMap.keySet().contains(group.getKey());
        if (checkKey && keyExists) {
            return false;
        }
        this.groupNames.put(groupName, appData);
        this.groupKeyMap.put(groupName, group.getKey());
        if (!keyExists) {
            this.groupNameMap.put(group.getKey(), groupName);
        }
        List classNames = group.getMapToObjects();
        Iterator iter2 = classNames.iterator();
        while (iter2.hasNext()) {
            String className = (String)iter2.next();
            if (this.getterMap.containsKey(className)) continue;
            this.getterMap.put(className, new HashMap());
            this.setterMap.put(className, new HashMap());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map loadSerialized(String serialDataPath, long timeStamp) {
        Map serialData;
        block16: {
            FileInputStream in;
            block15: {
                log.debug((Object)("Entered loadSerialized(" + serialDataPath + ", " + timeStamp + ")"));
                if (serialDataPath == null) {
                    return null;
                }
                File serialDataFile = new File(serialDataPath);
                if (!serialDataFile.exists()) {
                    log.info((Object)"No serialized file found, parsing XML");
                    return null;
                }
                if (serialDataFile.lastModified() <= timeStamp) {
                    log.info((Object)"serialized file too old, parsing XML");
                    return null;
                }
                in = null;
                serialData = null;
                in = new FileInputStream(serialDataFile);
                ObjectInputStream p = new ObjectInputStream(in);
                Object o = p.readObject();
                if (o instanceof Map) {
                    serialData = (Map)o;
                    break block15;
                }
                log.info((Object)"serialized object is not an intake map, ignoring");
                ((InputStream)in).close();
                in = null;
                serialDataFile.delete();
            }
            Object var10_9 = null;
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                break block16;
            }
            catch (Exception e2) {
                log.error((Object)"Exception while closing file", (Throwable)e2);
            }
            break block16;
            {
                catch (Exception e) {
                    log.error((Object)"Serialized File could not be read.", (Throwable)e);
                    serialData = null;
                    Object var10_10 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        break block16;
                    }
                    catch (Exception e2) {
                        log.error((Object)"Exception while closing file", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)"Exception while closing file", (Throwable)e2);
                }
                throw throwable;
            }
        }
        log.info((Object)"Loaded serialized map object, ignoring XML");
        return serialData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveSerialized(String serialDataPath, Map appDataElements) {
        block17: {
            log.debug((Object)("Entered saveSerialized(" + serialDataPath + ", appDataElements)"));
            if (serialDataPath == null) {
                return;
            }
            File serialData = new File(serialDataPath);
            try {
                serialData.createNewFile();
                serialData.delete();
            }
            catch (Exception e) {
                log.info((Object)("Could not create serialized file " + serialDataPath + ", not serializing the XML data"));
                return;
            }
            FileOutputStream out = null;
            InputStream in = null;
            out = new FileOutputStream(serialDataPath);
            ObjectOutputStream pout = new ObjectOutputStream(out);
            pout.writeObject(appDataElements);
            pout.flush();
            in = new FileInputStream(serialDataPath);
            ObjectInputStream pin = new ObjectInputStream(in);
            Map dummy = (Map)pin.readObject();
            log.debug((Object)"Serializing successful");
            Object var10_11 = null;
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (in != null) {
                    in.close();
                }
                break block17;
            }
            catch (Exception e2) {
                log.error((Object)"Exception while closing file", (Throwable)e2);
            }
            break block17;
            {
                catch (Exception e) {
                    log.info((Object)("Could not write serialized file to " + serialDataPath + ", not serializing the XML data"));
                    Object var10_12 = null;
                    try {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        if (in != null) {
                            in.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {
                        log.error((Object)"Exception while closing file", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                try {
                    if (out != null) {
                        ((OutputStream)out).close();
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    log.error((Object)"Exception while closing file", (Throwable)e2);
                }
                throw throwable;
            }
        }
    }

    public Group getGroup(String groupName) throws IntakeException {
        Group group = null;
        AppData appData = (AppData)this.groupNames.get(groupName);
        if (groupName == null) {
            throw new IntakeException("Intake TurbineIntakeService.getGroup(groupName) is null");
        }
        if (appData == null) {
            throw new IntakeException("Intake TurbineIntakeService.getGroup(groupName): No XML definition for Group " + groupName + " found");
        }
        try {
            group = (Group)((KeyedObjectPool)this.keyedPools.get(appData)).borrowObject((Object)groupName);
        }
        catch (Exception e) {
            throw new IntakeException("Could not get group " + groupName, e);
        }
        return group;
    }

    public void releaseGroup(Group instance) throws IntakeException {
        if (instance != null) {
            String groupName = instance.getIntakeGroupName();
            AppData appData = (AppData)this.groupNames.get(groupName);
            if (appData == null) {
                throw new IntakeException("Intake TurbineIntakeService.releaseGroup(groupName): No XML definition for Group " + groupName + " found");
            }
            try {
                ((KeyedObjectPool)this.keyedPools.get(appData)).returnObject((Object)groupName, (Object)instance);
            }
            catch (Exception e) {
                new IntakeException("Could not get group " + groupName, e);
            }
        }
    }

    public int getSize(String groupName) throws IntakeException {
        AppData appData = (AppData)this.groupNames.get(groupName);
        if (appData == null) {
            throw new IntakeException("Intake TurbineIntakeService.Size(groupName): No XML definition for Group " + groupName + " found");
        }
        KeyedObjectPool kop = (KeyedObjectPool)this.keyedPools.get(groupName);
        return kop.getNumActive((Object)groupName) + kop.getNumIdle((Object)groupName);
    }

    public String[] getGroupNames() {
        return this.groupNames.keySet().toArray(new String[0]);
    }

    public String getGroupKey(String groupName) {
        return (String)this.groupKeyMap.get(groupName);
    }

    public String getGroupName(String groupKey) {
        return (String)this.groupNameMap.get(groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getFieldSetter(String className, String propName) throws ClassNotFoundException, IntrospectionException {
        Map settersForClassName = (Map)this.setterMap.get(className);
        if (settersForClassName == null) {
            throw new IntrospectionException("No setter Map for " + className + " available!");
        }
        Method setter = (Method)settersForClassName.get(propName);
        if (setter == null) {
            PropertyDescriptor pd = null;
            Map map = this.setterMap;
            synchronized (map) {
                try {
                    pd = new PropertyDescriptor(propName, Class.forName(className));
                }
                catch (IntrospectionException ie) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Trying to find only a setter for " + propName));
                    }
                    pd = new PropertyDescriptor(propName, Class.forName(className), "set" + StringUtils.capitalize((String)propName), null);
                }
                setter = pd.getWriteMethod();
                settersForClassName.put(propName, setter);
                if (setter == null) {
                    log.error((Object)("Intake: setter for '" + propName + "' in class '" + className + "' could not be found."));
                }
            }
            if (pd.getReadMethod() != null) {
                map = this.getterMap;
                synchronized (map) {
                    Map gettersForClassName = (Map)this.getterMap.get(className);
                    if (gettersForClassName != null) {
                        try {
                            Method getter = pd.getReadMethod();
                            if (getter != null) {
                                gettersForClassName.put(propName, getter);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return setter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getFieldGetter(String className, String propName) throws ClassNotFoundException, IntrospectionException {
        Map gettersForClassName = (Map)this.getterMap.get(className);
        if (gettersForClassName == null) {
            throw new IntrospectionException("No getter Map for " + className + " available!");
        }
        Method getter = (Method)gettersForClassName.get(propName);
        if (getter == null) {
            PropertyDescriptor pd = null;
            Map map = this.getterMap;
            synchronized (map) {
                try {
                    pd = new PropertyDescriptor(propName, Class.forName(className));
                }
                catch (IntrospectionException ie) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Trying to find only a getter for " + propName));
                    }
                    pd = new PropertyDescriptor(propName, Class.forName(className), "get" + StringUtils.capitalize((String)propName), null);
                }
                getter = pd.getReadMethod();
                gettersForClassName.put(propName, getter);
                if (getter == null) {
                    log.error((Object)("Intake: getter for '" + propName + "' in class '" + className + "' could not be found."));
                }
            }
            if (pd.getWriteMethod() != null) {
                map = this.setterMap;
                synchronized (map) {
                    Map settersForClassName = (Map)this.getterMap.get(className);
                    if (settersForClassName != null) {
                        try {
                            Method setter = pd.getWriteMethod();
                            if (setter != null) {
                                settersForClassName.put(propName, setter);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return getter;
    }
}

