/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;

public class FloatValidator
extends NumberValidator {
    private float minValue = Float.NEGATIVE_INFINITY;
    private float maxValue = Float.POSITIVE_INFINITY;

    public FloatValidator(Map paramMap) throws InvalidMaskException {
        this.invalidNumberMessage = "Entry was not a valid Float";
        this.init(paramMap);
    }

    public FloatValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        String param;
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = Float.parseFloat(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = Float.parseFloat(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    public void assertValidity(Field field) throws ValidationException {
        Locale locale = field.getLocale();
        if (field.isMultiValued()) {
            String[] stringValues = (String[])field.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], locale);
            }
        } else {
            this.assertValidity((String)field.getTestValue(), locale);
        }
    }

    public void assertValidity(String testValue, Locale locale) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            float f = 0.0f;
            NumberFormat nf = NumberFormat.getInstance(locale);
            try {
                f = nf.parse(testValue).floatValue();
            }
            catch (ParseException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            if (f < this.minValue) {
                this.errorMessage = this.minValueMessage;
                throw new ValidationException(this.minValueMessage);
            }
            if (f > this.maxValue) {
                this.errorMessage = this.maxValueMessage;
                throw new ValidationException(this.maxValueMessage);
            }
        }
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }
}

