/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.GroupCacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;

public class JCSCacheService
extends AbstractLogEnabled
implements GlobalCacheService,
Runnable,
Configurable,
Disposable,
Initializable,
ThreadSafe {
    public static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    private long cacheCheckFrequency;
    private GroupCacheAccess<String, CachedObject<?>> cacheManager;
    private String region;
    private String configFile;
    private static String group = "default_group";
    private Thread refreshing;
    private boolean continueThread;

    public void configure(Configuration config) throws ConfigurationException {
        this.cacheCheckFrequency = config.getChild("cacheCheckFrequency").getValueAsLong(5000L);
        this.region = config.getChild("region").getValue("fulcrum");
        this.configFile = config.getChild("configurationFile").getValue("/cache.ccf");
    }

    public void initialize() throws Exception {
        JCS.setConfigFilename((String)this.configFile);
        this.cacheManager = JCS.getGroupCacheInstance((String)this.region);
        this.continueThread = true;
        this.refreshing = new Thread(this);
        this.refreshing.setDaemon(true);
        this.refreshing.setName("JCSCacheService Refreshing");
        this.refreshing.start();
        this.getLogger().debug("JCSCacheService started.");
    }

    public void dispose() {
        this.continueThread = false;
        this.refreshing.interrupt();
        this.cacheManager.dispose();
        this.cacheManager = null;
        CompositeCacheManager.getInstance().shutDown();
        this.getLogger().debug("JCSCacheService stopped.");
    }

    @Override
    public <T> CachedObject<T> getObject(String objectId) throws ObjectExpiredException {
        CachedObject cachedObject = (CachedObject)this.cacheManager.getFromGroup((Object)objectId, group);
        if (cachedObject == null) {
            throw new ObjectExpiredException();
        }
        if (cachedObject.isStale()) {
            if (cachedObject instanceof RefreshableCachedObject) {
                RefreshableCachedObject refreshableObject = (RefreshableCachedObject)cachedObject;
                if (refreshableObject.isUntouched()) {
                    this.removeObject(objectId);
                    throw new ObjectExpiredException();
                }
                refreshableObject.refresh();
                if (refreshableObject.isStale()) {
                    this.removeObject(objectId);
                    throw new ObjectExpiredException();
                }
            } else {
                this.removeObject(objectId);
                throw new ObjectExpiredException();
            }
        }
        if (cachedObject instanceof RefreshableCachedObject) {
            RefreshableCachedObject refreshableCachedObject = (RefreshableCachedObject)cachedObject;
            refreshableCachedObject.touch();
        }
        return cachedObject;
    }

    @Override
    public <T> void addObject(String objectId, CachedObject<T> cachedObject) {
        try {
            if (!(cachedObject.getContents() instanceof Serializable)) {
                this.getLogger().warn("Object (contents) with id [" + objectId + "] is not serializable. Expect problems with auxiliary caches: " + cachedObject.getContents().getClass().getSimpleName());
            }
            ElementAttributes attrib = (ElementAttributes)this.cacheManager.getDefaultElementAttributes();
            if (cachedObject instanceof RefreshableCachedObject) {
                attrib.setIsEternal(true);
            } else {
                attrib.setIsEternal(false);
                double tmp0 = (double)(cachedObject.getExpires() + 500L) / 1000.0;
                this.getLogger().debug("setting maxlife seconds (minimum 1sec) from expiry + 0.5s: " + (int)tmp0);
                attrib.setMaxLife(tmp0 > 0.0 ? (long)((int)Math.floor(tmp0)) : 1L);
            }
            attrib.setLastAccessTimeNow();
            attrib.setCreateTime();
            this.cacheManager.putInGroup((Object)objectId, group, cachedObject, (IElementAttributes)attrib);
        }
        catch (CacheException e) {
            this.getLogger().error("Could not add object " + objectId + " to cache", (Throwable)e);
        }
    }

    @Override
    public void removeObject(String objectId) {
        this.cacheManager.removeFromGroup((Object)objectId, group);
    }

    @Override
    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.cacheManager.getGroupKeys(group));
        return keys;
    }

    @Override
    public List<CachedObject<?>> getCachedObjects() {
        ArrayList values = new ArrayList();
        for (String key : this.cacheManager.getGroupKeys(group)) {
            CachedObject cachedObject = (CachedObject)this.cacheManager.getFromGroup((Object)key, group);
            if (cachedObject == null) continue;
            values.add(cachedObject);
        }
        return values;
    }

    @Override
    public void run() {
        while (this.continueThread) {
            block6: {
                try {
                    Thread.sleep(this.cacheCheckFrequency);
                }
                catch (InterruptedException exc) {
                    if (this.continueThread) break block6;
                    return;
                }
            }
            for (String key : this.cacheManager.getGroupKeys(group)) {
                CachedObject cachedObject = (CachedObject)this.cacheManager.getFromGroup((Object)key, group);
                if (cachedObject == null) {
                    this.removeObject(key);
                    continue;
                }
                if (!(cachedObject instanceof RefreshableCachedObject)) continue;
                RefreshableCachedObject refreshableObject = (RefreshableCachedObject)cachedObject;
                if (refreshableObject.isUntouched()) {
                    this.cacheManager.removeFromGroup((Object)key, group);
                    continue;
                }
                if (!refreshableObject.isStale()) continue;
                refreshableObject.refresh();
            }
        }
    }

    @Override
    public int getCacheSize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        Set keys = this.cacheManager.getGroupKeys(group);
        for (String key : keys) {
            out.writeObject(this.cacheManager.getFromGroup((Object)key, group));
        }
        out.flush();
        return baos.toByteArray().length - 4 * keys.size();
    }

    @Override
    public int getNumberOfObjects() {
        int count = 0;
        for (String key : this.cacheManager.getGroupKeys(group)) {
            if (this.cacheManager.getFromGroup((Object)key, group) == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void flushCache() {
        this.cacheManager.invalidateGroup(group);
    }
}

