/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.text;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.ide.core.codeassist.RutaReferenceVisitor;
import org.apache.uima.ruta.ide.core.codeassist.RutaSelectionParser;
import org.apache.uima.ruta.ide.parser.ast.RutaModuleDeclaration;
import org.apache.uima.ruta.ide.parser.ast.RutaVariableReference;
import org.apache.uima.ruta.ide.ui.text.ExternalTypeHyperlink;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTypeHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public ExternalTypeHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || !(this.fTextEditor instanceof ScriptEditor)) {
            return null;
        }
        int offset = region.getOffset();
        org.eclipse.dltk.core.ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fTextEditor, (boolean)false);
        if (input == null) {
            return null;
        }
        try {
            IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
            IRegion wordRegion = ScriptWordFinder.findWord((IDocument)document, (int)offset);
            if (wordRegion == null) {
                return null;
            }
            if (input instanceof ISourceModule) {
                ISourceModule sm = (ISourceModule)input;
                IModelElement modelElement = sm.getModelElement();
                RutaSelectionParser parser = new RutaSelectionParser();
                ModuleDeclaration moduleDeclaration = parser.parse((IModuleSource)sm);
                String word = document.get(wordRegion.getOffset(), wordRegion.getLength());
                RutaReferenceVisitor referenceVisitor = new RutaReferenceVisitor(wordRegion.getOffset());
                moduleDeclaration.traverse((ASTVisitor)referenceVisitor);
                ASTNode node = referenceVisitor.getResult();
                if (node instanceof RutaVariableReference && moduleDeclaration instanceof RutaModuleDeclaration) {
                    RutaVariableReference vr = (RutaVariableReference)node;
                    RutaModuleDeclaration parsed = (RutaModuleDeclaration)moduleDeclaration;
                    if (vr.getType() == 0x800000) {
                        String nodeText = vr.getStringRepresentation();
                        Collection importedTypeSystems = parsed.descriptorInfo.getImportedTypeSystems();
                        ArrayList<ExternalTypeHyperlink> result = new ArrayList<ExternalTypeHyperlink>();
                        for (String tsString : importedTypeSystems) {
                            IFolder folder = modelElement.getScriptProject().getProject().getFolder(RutaProjectUtils.getDefaultDescriptorLocation());
                            String xmlFilePath = tsString.replaceAll("\\.", "/");
                            Set<String> types = this.getTypes(folder, xmlFilePath = xmlFilePath.substring(0, xmlFilePath.length()) + ".xml");
                            if (!types.contains(nodeText)) continue;
                            IFile iFile = this.getFile(folder, xmlFilePath);
                            ExternalTypeHyperlink link = new ExternalTypeHyperlink(nodeText, wordRegion, iFile, tsString, this.fTextEditor);
                            result.add(link);
                        }
                        if (!result.isEmpty()) {
                            return result.toArray(new IHyperlink[0]);
                        }
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private Set<String> getTypes(IFolder folder, String filePath) throws InvalidXMLException, IOException {
        Set<String> types = new HashSet<String>();
        IFile iFile = this.getFile(folder, filePath);
        try {
            URL url = iFile.getLocationURI().toURL();
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            resMgr.setDataPath(folder.getLocation().toPortableString());
            types = this.getTypes(url, resMgr);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return types;
    }

    private Set<String> getTypes(URL resource, ResourceManager resMgr) throws IOException, InvalidXMLException {
        HashSet<String> types = new HashSet<String>();
        TypeSystemDescription typeSysDescr = null;
        typeSysDescr = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(resource));
        typeSysDescr.resolveImports(resMgr);
        for (TypeDescription each : typeSysDescr.getTypes()) {
            String name = each.getName();
            String[] nameSpace = name.split("[.]");
            types.add(nameSpace[nameSpace.length - 1]);
            StringBuffer fullName = new StringBuffer();
            if (nameSpace.length > 0) {
                fullName.append(nameSpace[0]);
            }
            for (int i = 1; i < nameSpace.length; ++i) {
                if (nameSpace[i].equals("type")) continue;
                fullName.append('.');
                fullName.append(nameSpace[i]);
            }
            types.add(fullName.toString());
        }
        return types;
    }

    private IFile getFile(IFolder folder, String filePath) {
        int lastDot = filePath.lastIndexOf(46);
        int sndLastDot = filePath.lastIndexOf(46, lastDot - 1);
        String fName = filePath;
        if (sndLastDot >= 0) {
            String subFolder = filePath.substring(0, sndLastDot);
            folder = folder.getFolder(subFolder);
            fName = filePath.substring(sndLastDot + 1);
        }
        return folder.getFile(fName);
    }
}

